/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.blocks.NotificationBus;

public class NotificationBusDemo
implements NotificationBus.Consumer {
    NotificationBus bus = null;
    BufferedReader in = null;
    String line;
    final long timeout = 0L;
    final Vector cache = null;
    Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String bus_name, String props) {
        block11: {
            try {
                this.bus = new NotificationBus(bus_name, props);
                this.bus.setConsumer(this);
                this.bus.start();
                this.in = new BufferedReader(new InputStreamReader(System.in));
                while (true) {
                    try {
                        while (true) {
                            System.out.print("> ");
                            System.out.flush();
                            this.line = this.in.readLine();
                            if (this.line.startsWith("quit") || this.line.startsWith("exit")) {
                                this.bus.stop();
                                this.bus = null;
                                break block11;
                            }
                            this.bus.sendNotification((Serializable)((Object)this.line));
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex);
            }
            finally {
                if (this.bus != null) {
                    this.bus.stop();
                }
            }
        }
    }

    @Override
    public void handleNotification(Serializable n) {
        System.out.println("** Received notification: " + n);
    }

    @Override
    public Serializable getCache() {
        return null;
    }

    @Override
    public void memberJoined(Address mbr) {
        System.out.println("** Member joined: " + mbr);
    }

    @Override
    public void memberLeft(Address mbr) {
        System.out.println("** Member left: " + mbr);
    }

    public static void main(String[] args) {
        String name = "BusDemo";
        String props = "udp.xml";
        for (int i = 0; i < args.length; ++i) {
            if ("-bus_name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            System.out.println("NotificationBusDemo [-help] [-bus_name <name>] [-props <properties>]");
            return;
        }
        System.out.println("Starting NotificationBus with name " + name);
        new NotificationBusDemo().start(name, props);
    }
}

