/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

public class SecurityManager {
    private static Log LOG = ExoLogger.getLogger(SecurityManager.class);

    public static boolean canAccessActivity(PortalContainer portalContainer, String userIdentityId, ExoSocialActivity existingActivity) {
        IdentityManager identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        Identity authenticateIdentity = identityManager.getOrCreateIdentity("organization", userIdentityId, false);
        if (authenticateIdentity == null || existingActivity == null) {
            return false;
        }
        return SecurityManager.canAccessActivity(portalContainer, authenticateIdentity, existingActivity);
    }

    public static boolean canAccessActivity(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingActivity) {
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        if (authenticatedIdentity == null || existingActivity == null) {
            return false;
        }
        if (authenticatedIdentity.getId().equals(existingActivity.getUserId())) {
            return true;
        }
        switch (existingActivity.getActivityStream().getType()) {
            case SPACE: {
                String spaceName = existingActivity.getActivityStream().getPrettyId();
                Space space = spaceService.getSpaceByPrettyName(spaceName);
                ArrayList<String> allIds = new ArrayList<String>();
                allIds.addAll(Arrays.asList(space.getMembers()));
                allIds.addAll(Arrays.asList(space.getManagers()));
                if (!allIds.contains(authenticatedIdentity.getRemoteId())) break;
                return true;
            }
            case USER: {
                return true;
            }
        }
        return false;
    }

    public static boolean canPostActivity(PortalContainer portalContainer, Identity authenticatedIdentity, Identity ownerIdentityStream) {
        Relationship relationship;
        Space space;
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        RelationshipManager relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        String posterID = authenticatedIdentity.getId();
        String ownerID = ownerIdentityStream.getId();
        if (ownerID.equals(posterID)) {
            return true;
        }
        return ownerIdentityStream.getProviderId().equals("space") ? spaceService.isMember(space = spaceService.getSpaceByPrettyName(ownerIdentityStream.getRemoteId()), authenticatedIdentity.getRemoteId()) || spaceService.isManager(space, authenticatedIdentity.getRemoteId()) : (relationship = relationshipManager.get(authenticatedIdentity, ownerIdentityStream)) != null && Relationship.Type.CONFIRMED.equals((Object)relationship.getStatus());
    }

    public static boolean canDeleteActivity(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingActivity) {
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        RelationshipManager relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        if (authenticatedIdentity.getId().equals(existingActivity.getUserId())) {
            return true;
        }
        switch (existingActivity.getActivityStream().getType()) {
            case SPACE: {
                String spaceName = existingActivity.getActivityStream().getPrettyId();
                Space space = spaceService.getSpaceByPrettyName(spaceName);
                ArrayList<String> allIds = new ArrayList<String>();
                allIds.addAll(Arrays.asList(space.getManagers()));
                if (!allIds.contains(authenticatedIdentity.getRemoteId())) break;
                return true;
            }
            case USER: {
                if (!authenticatedIdentity.getId().equals(existingActivity.getActivityStream().getId())) break;
                return true;
            }
        }
        return false;
    }

    public static boolean canCommentToActivity(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingActivity) {
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        RelationshipManager relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        if (authenticatedIdentity == null || existingActivity == null) {
            return false;
        }
        if (authenticatedIdentity.getId().equals(existingActivity.getUserId())) {
            return true;
        }
        switch (existingActivity.getActivityStream().getType()) {
            case SPACE: {
                String spaceName = existingActivity.getActivityStream().getPrettyId();
                Space space = spaceService.getSpaceByPrettyName(spaceName);
                ArrayList<String> allIds = new ArrayList<String>();
                allIds.addAll(Arrays.asList(space.getMembers()));
                allIds.addAll(Arrays.asList(space.getManagers()));
                if (!allIds.contains(authenticatedIdentity.getRemoteId())) break;
                return true;
            }
            case USER: {
                if (authenticatedIdentity.getId().equals(existingActivity.getActivityStream().getId())) {
                    return true;
                }
                String contactId = existingActivity.getActivityStream().getId();
                Relationship relationship = relationshipManager.get(authenticatedIdentity, new Identity(contactId));
                if (relationship == null || !Relationship.Type.CONFIRMED.equals((Object)relationship.getStatus())) break;
                return true;
            }
        }
        return false;
    }

    public static boolean canDeleteComment(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingComment) {
        return SecurityManager.canDeleteActivity(portalContainer, authenticatedIdentity, existingComment);
    }

    public static Identity getAuthenticatedUserIdentity() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null) {
            IdentityManager identityManager = Util.getIdentityManager();
            String authenticatedUserRemoteId = ConversationState.getCurrent().getIdentity().getUserId();
            return identityManager.getOrCreateIdentity("organization", authenticatedUserRemoteId, false);
        }
        return null;
    }

    public static boolean canAccessActivityStream(PortalContainer portalContainer, Identity authenticatedIdentity, Identity ownerStream) {
        if (ownerStream.getProviderId().equals("space")) {
            SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
            Space targetSpace = spaceService.getSpaceByPrettyName(ownerStream.getRemoteId());
            if (targetSpace == null) {
                LOG.warn((Object)("targetSpace is null with prettyName: " + ownerStream.getRemoteId()));
                return true;
            }
            return spaceService.isMember(targetSpace, authenticatedIdentity.getRemoteId()) || spaceService.isManager(targetSpace, authenticatedIdentity.getRemoteId());
        }
        return true;
    }
}

