/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.utils.Key;

public class DB2v7Delegate
extends StdJDBCDelegate {
    public DB2v7Delegate(Log logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    public DB2v7Delegate(Log log, String tablePrefix, String instanceId, Boolean useProperties) {
        super(log, tablePrefix, instanceId, useProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] selectTriggersForRecoveringJobs(Connection conn) throws SQLException, IOException, ClassNotFoundException {
        SQLException ignore22;
        Trigger[] triggerArray;
        PreparedStatement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
                ps.setString(1, this.instanceId);
                ps.setString(2, "1");
                rs = ps.executeQuery();
                long dumId = System.currentTimeMillis();
                ArrayList<SimpleTrigger> list = new ArrayList<SimpleTrigger>();
                while (rs.next()) {
                    String jobName = rs.getString("JOB_NAME");
                    String jobGroup = rs.getString("JOB_GROUP");
                    String trigName = rs.getString("TRIGGER_NAME");
                    String trigGroup = rs.getString("TRIGGER_GROUP");
                    long firedTime = rs.getLong("FIRED_TIME");
                    SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + this.instanceId + "_" + String.valueOf(dumId++), "RECOVERING_JOBS", new Date(firedTime));
                    rcvryTrig.setJobName(jobName);
                    rcvryTrig.setJobGroup(jobGroup);
                    rcvryTrig.setMisfireInstruction(1);
                    JobDataMap jd = this.selectTriggerJobDataMap(conn, trigName, trigGroup);
                    jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", trigName);
                    jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", trigGroup);
                    jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTime));
                    rcvryTrig.setJobDataMap(jd);
                    list.add(rcvryTrig);
                }
                Object[] oArr = list.toArray();
                Trigger[] tArr = new Trigger[oArr.length];
                System.arraycopy(oArr, 0, tArr, 0, oArr.length);
                triggerArray = tArr;
                Object var16_13 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    SQLException ignore22;
                    Object var16_14 = null;
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore22) {
                            // empty catch block
                        }
                    }
                    if (null == ps) break block13;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {}
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        return triggerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block6: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                ps.setString(3, job.getDescription());
                ps.setString(4, job.getJobClass().getName());
                ps.setString(5, DB2v7Delegate.toBooleanIntString(job.isDurable()));
                ps.setString(6, DB2v7Delegate.toBooleanIntString(job.isVolatile()));
                ps.setString(7, DB2v7Delegate.toBooleanIntString(job.isStateful()));
                ps.setString(8, DB2v7Delegate.toBooleanIntString(job.requestsRecovery()));
                ps.setObject(9, (Object)baos.toByteArray(), 2004);
                insertResult = ps.executeUpdate();
                Object var7_6 = null;
                if (null == ps) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) return insertResult;
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block6: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, job.getDescription());
                ps.setString(2, job.getJobClass().getName());
                ps.setString(3, DB2v7Delegate.toBooleanIntString(job.isDurable()));
                ps.setString(4, DB2v7Delegate.toBooleanIntString(job.isVolatile()));
                ps.setString(5, DB2v7Delegate.toBooleanIntString(job.isStateful()));
                ps.setString(6, DB2v7Delegate.toBooleanIntString(job.requestsRecovery()));
                ps.setObject(7, (Object)baos.toByteArray(), 2004);
                ps.setString(8, job.getName());
                ps.setString(9, job.getGroup());
                insertResult = ps.executeUpdate();
                Object var7_6 = null;
                if (null == ps) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteJobListeners(conn, job.getName(), job.getGroup());
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) return insertResult;
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block12: {
            ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                ps.setString(3, trigger.getJobName());
                ps.setString(4, trigger.getJobGroup());
                ps.setString(5, DB2v7Delegate.toBooleanIntString(trigger.isVolatile()));
                ps.setString(6, trigger.getDescription());
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(9, state);
                if (trigger instanceof SimpleTrigger) {
                    ps.setString(10, "SIMPLE");
                } else if (trigger instanceof CronTrigger) {
                    ps.setString(10, "CRON");
                } else {
                    ps.setString(10, "BLOB");
                }
                ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
                ps.setString(13, trigger.getCalendarName());
                ps.setInt(14, trigger.getMisfireInstruction());
                ps.setObject(15, (Object)baos.toByteArray(), 2004);
                insertResult = ps.executeUpdate();
                Object var13_11 = null;
                if (null == ps) break block12;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] trigListeners = trigger.getTriggerListenerNames();
        int i = 0;
        while (trigListeners != null) {
            if (i >= trigListeners.length) return insertResult;
            this.insertTriggerListener(conn, trigger, trigListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block13: {
            ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, trigger.getJobName());
                ps.setString(2, trigger.getJobGroup());
                ps.setString(3, DB2v7Delegate.toBooleanIntString(trigger.isVolatile()));
                ps.setString(4, trigger.getDescription());
                long nextFireTime = -1L;
                if (trigger.getNextFireTime() != null) {
                    nextFireTime = trigger.getNextFireTime().getTime();
                }
                ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(7, state);
                if (trigger instanceof SimpleTrigger) {
                    ps.setString(8, "SIMPLE");
                } else if (trigger instanceof CronTrigger) {
                    ps.setString(8, "CRON");
                } else {
                    ps.setString(8, "BLOB");
                }
                ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
                ps.setString(11, trigger.getCalendarName());
                ps.setInt(12, trigger.getMisfireInstruction());
                ps.setObject(13, (Object)baos.toByteArray(), 2004);
                ps.setString(14, trigger.getName());
                ps.setString(15, trigger.getGroup());
                insertResult = ps.executeUpdate();
                Object var15_12 = null;
                if (null == ps) break block13;
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
        String[] trigListeners = trigger.getTriggerListenerNames();
        int i = 0;
        while (trigListeners != null) {
            if (i >= trigListeners.length) return insertResult;
            this.insertTriggerListener(conn, trigger, trigListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail job) throws SQLException {
        int n;
        block7: {
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getFireInstanceId());
                ps.setString(2, trigger.getName());
                ps.setString(3, trigger.getGroup());
                ps.setString(4, DB2v7Delegate.toBooleanIntString(trigger.isVolatile()));
                ps.setString(5, this.instanceId);
                ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                ps.setString(7, state);
                if (job != null) {
                    ps.setString(8, trigger.getJobName());
                    ps.setString(9, trigger.getJobGroup());
                    ps.setString(10, DB2v7Delegate.toBooleanIntString(job.isStateful()));
                    ps.setString(11, DB2v7Delegate.toBooleanIntString(job.requestsRecovery()));
                } else {
                    ps.setString(8, null);
                    ps.setString(9, null);
                    ps.setString(10, "0");
                    ps.setString(11, "0");
                }
                n = ps.executeUpdate();
                Object var8_7 = null;
                if (null == ps) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_8 = null;
                    if (null == ps) break block8;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        block5: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setObject(1, (Object)baos.toByteArray(), 2004);
                ps.setString(2, job.getName());
                ps.setString(3, job.getGroup());
                n = ps.executeUpdate();
                Object var7_6 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_7 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        block5: {
            ByteArrayOutputStream baos = this.serializeObject(calendar);
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
                ps.setString(1, calendarName);
                ps.setObject(2, (Object)baos.toByteArray(), 2004);
                n = ps.executeUpdate();
                Object var8_7 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        block5: {
            ByteArrayOutputStream baos = this.serializeObject(calendar);
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
                ps.setString(1, calendarName);
                ps.setObject(2, (Object)baos.toByteArray(), 2004);
                n = ps.executeUpdate();
                Object var8_7 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
        int n;
        block5: {
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?"));
                ps.setString(1, "1");
                n = ps.executeUpdate();
                Object var5_4 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?"));
                ps.setString(1, "1");
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("TRIGGER_NAME");
                    String groupName = rs.getString("TRIGGER_GROUP");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var9_8 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    SQLException ignore22;
                    Object var9_9 = null;
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore22) {
                            // empty catch block
                        }
                    }
                    if (null == ps) break block13;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {}
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        return keyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectVolatileJobs(Connection conn) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?"));
                ps.setString(1, "1");
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("JOB_NAME");
                    String groupName = rs.getString("JOB_GROUP");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var9_8 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    SQLException ignore22;
                    Object var9_9 = null;
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore22) {
                            // empty catch block
                        }
                    }
                    if (null == ps) break block13;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {}
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        return keyArray;
    }

    private static String toBooleanIntString(boolean theBoolean) {
        if (String.valueOf(theBoolean).equals("true")) {
            return "1";
        }
        return "0";
    }
}

