/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FavoriteActionUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)FavoriteActionUpgradePlugin.class.getName());
    private static final String FAVORITE_ALIAS = "userPrivateFavorites";
    private static final String ADD_TO_FAVORITE_ACTION = "addToFavorite";
    private static final String NODE_TYPE_ADD_TO_FAVORITE_ACTION = "exo:addToFavoriteAction";
    private static final String FILE_NAME_ADD_TO_FAVORITE_ACTION = "AddToFavoriteScript.groovy";
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private static final String EXO_FAVORITEFOLDER = "exo:favoriteFolder";
    private static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    private ActionServiceContainer actionServiceContainer;
    private TemplateService templateService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private OrganizationService organizationService;
    private DMSConfiguration dmsConfiguration;
    private RepositoryService repoService;
    private ScriptService scriptService;
    private ConfigurationManager configurationManager;

    public FavoriteActionUpgradePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, ScriptService scriptService, ConfigurationManager configurationManager, ActionServiceContainer actionServiceContainer, TemplateService templateService, NodeHierarchyCreator nodeHierarchyCreator, OrganizationService organizationService, InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.organizationService = organizationService;
        this.actionServiceContainer = actionServiceContainer;
        this.templateService = templateService;
        this.repoService = repoService;
        this.dmsConfiguration = dmsConfiguration;
        this.scriptService = scriptService;
        this.configurationManager = configurationManager;
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = sessionProvider.getSession(this.dmsConfiguration.getConfig().getSystemWorkspace(), this.repoService.getCurrentRepository());
            String scriptPath = this.nodeHierarchyCreator.getJcrPath("ecmActionScripts") + "/" + FILE_NAME_ADD_TO_FAVORITE_ACTION;
            try {
                session.getItem(scriptPath);
            }
            catch (PathNotFoundException pne) {
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)this.configurationManager.getURL("classpath:/script/AddToFavoriteScript.groovy").openStream(), (Writer)writer);
                String scriptContent = writer.toString();
                this.scriptService.addScript("ecm-explorer/action/AddToFavoriteScript.groovy", scriptContent, sessionProvider);
            }
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            try {
                nodeTypeManager.getNodeType(NODE_TYPE_ADD_TO_FAVORITE_ACTION);
            }
            catch (NoSuchNodeTypeException e) {
                nodeTypeManager.registerNodeTypes(this.configurationManager.getURL("classpath:/conf/portal/AddToFavoriteAction_NodeType_Definition.xml").openStream(), 0, "text/xml");
            }
            ListAccess userListAccess = this.organizationService.getUserHandler().findAllUsers();
            List userList = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)userListAccess);
            Node favoriteNode = null;
            int count = 0;
            for (User user : userList) {
                String userName = user.getUserName();
                Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userName);
                String favoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
                try {
                    favoriteNode = userNode.getNode(favoritePath);
                }
                catch (PathNotFoundException pne) {
                    favoriteNode = this.createFavoriteFolder(userName);
                }
                if (favoriteNode == null || this.actionServiceContainer.getAction(favoriteNode, ADD_TO_FAVORITE_ACTION) == null) continue;
                this.actionServiceContainer.removeAction(favoriteNode, ADD_TO_FAVORITE_ACTION, this.repoService.getCurrentRepository().getConfiguration().getName());
                if (++count % 100 != 0 || !LOG.isInfoEnabled()) continue;
                StringBuilder infor = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append(": ").append(count).append(" users done!");
                LOG.info((Object)infor.toString());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("End " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(((Object)((Object)this)).getClass().getName() + " failed:"), (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private Node createFavoriteFolder(String userName) throws Exception {
        Node userFavoriteNode;
        block2: {
            userFavoriteNode = null;
            try {
                Node userNode = this.nodeHierarchyCreator.getUserNode(WCMCoreUtils.getSystemSessionProvider(), userName);
                String userFavoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
                userFavoriteNode = userNode.addNode(userFavoritePath, NT_UNSTRUCTURED);
                userFavoriteNode.addMixin(EXO_PRIVILEGEABLE);
                userFavoriteNode.addMixin(EXO_FAVORITEFOLDER);
                HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
                permissionsMap.put(userName, PermissionType.ALL);
                ((ExtendedNode)userFavoriteNode).setPermissions(permissionsMap);
                userNode.getSession().save();
            }
            catch (PathNotFoundException pne) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)("Private Folder of User " + userName + " not found"));
            }
        }
        return userFavoriteNode;
    }
}

