/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.CapturingReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;

public class CapturingReaderTest
extends TestCase {
    public final void testExpansion() throws Exception {
        String s = "The quick brown fox";
        CapturingReader cr = new CapturingReader(new StringReader(s), 0);
        for (int i = 0; i < s.length(); ++i) {
            CapturingReaderTest.assertEquals((int)s.charAt(i), (int)cr.read());
        }
        CapturingReaderTest.assertEquals((String)s, (String)((Object)cr.getCapture()).toString());
    }

    public final void testPastEnd() throws Exception {
        CapturingReader cr = new CapturingReader(new StringReader("ab"));
        CapturingReaderTest.assertEquals((int)97, (int)cr.read());
        CapturingReaderTest.assertEquals((int)98, (int)cr.read());
        CapturingReaderTest.assertEquals((int)-1, (int)cr.read());
        CapturingReaderTest.assertEquals((String)"ab", (String)((Object)cr.getCapture()).toString());
    }

    public final void testAutoClose() throws Exception {
        CapturingReader cr = new CapturingReader(new StringReader("abcdef"));
        CapturingReaderTest.assertEquals((int)97, (int)cr.read());
        CapturingReaderTest.assertEquals((int)98, (int)cr.read());
        CapturingReaderTest.assertEquals((String)"ab", (String)((Object)cr.getCapture()).toString());
        try {
            cr.read();
            CapturingReaderTest.fail((String)"getCapture() should have closed the reader");
        }
        catch (IOException e) {
            return;
        }
    }

    public final void testManualClose() throws Exception {
        CapturingReader cr = new CapturingReader(new StringReader("abcdef"));
        CapturingReaderTest.assertEquals((int)97, (int)cr.read());
        CapturingReaderTest.assertEquals((int)98, (int)cr.read());
        cr.close();
        try {
            cr.read();
            CapturingReaderTest.fail((String)"Reader should be closed");
        }
        catch (IOException e) {
            return;
        }
    }
}

