/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.builder;

import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBuilder<T>
implements PrivilegedAction<T> {
    private Class<T> factoryClass;
    private String defaultFactory;

    public AbstractBuilder(Class<T> factoryClass, String defaultFactory) {
        if (factoryClass == null) {
            throw new IllegalArgumentException("Null factory class");
        }
        if (defaultFactory == null) {
            throw new IllegalArgumentException("Null default factory");
        }
        this.factoryClass = factoryClass;
        this.defaultFactory = defaultFactory;
    }

    @Override
    public T run() {
        try {
            String className = System.getProperty(this.factoryClass.getName(), this.defaultFactory);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            Object object = clazz.newInstance();
            return this.factoryClass.cast(object);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error constructing " + this.factoryClass.getName(), t);
        }
    }
}

