/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.util.List;
import java.util.Map;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactImportExport;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.impl.ContactEventListener;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ContactService {
    public List<Contact> getPersonalContacts(String var1) throws Exception;

    public ContactPageList getPersonalContactsByAddressBook(String var1, String var2) throws Exception;

    public List<String> getEmailsByAddressBook(String var1, String var2) throws Exception;

    public Contact getContact(String var1, String var2) throws Exception;

    public void saveContact(String var1, Contact var2, boolean var3) throws Exception;

    public List<Contact> removeContacts(String var1, List<String> var2) throws Exception;

    public void moveContacts(String var1, List<Contact> var2, String var3) throws Exception;

    public ContactPageList getPersonalContactsByFilter(String var1, ContactFilter var2) throws Exception;

    public ContactPageList getSharedContactsByFilter(String var1, ContactFilter var2) throws Exception;

    public ContactPageList getPublicContactsByFilter(String var1, ContactFilter var2) throws Exception;

    public DataPageList searchContact(String var1, ContactFilter var2) throws Exception;

    public void removeSharedContact(String var1, String var2, String var3) throws Exception;

    public Map<String, String> searchEmails(String var1, ContactFilter var2) throws Exception;

    public List<String> searchEmailsByFilter(String var1, ContactFilter var2) throws Exception;

    public ContactPageList getPublicContactsByAddressBook(String var1) throws Exception;

    public Contact getPublicContact(String var1) throws Exception;

    public void addUserContactInAddressBook(String var1, String var2) throws Exception;

    public List<AddressBook> getGroups(String var1) throws Exception;

    public List<String> getPublicAddresses(String var1) throws Exception;

    public AddressBook getPersonalAddressBook(String var1, String var2) throws Exception;

    public AddressBook getPublicAddressBook(String var1, String var2) throws Exception;

    public void saveAddressBook(String var1, AddressBook var2, boolean var3) throws Exception;

    public AddressBook removeAddressBook(String var1, String var2) throws Exception;

    public void removeUserShareContact(String var1, String var2, String var3) throws Exception;

    public void shareContact(String var1, String[] var2, List<String> var3) throws Exception;

    public DataPageList getSharedContacts(String var1) throws Exception;

    public void shareAddressBook(String var1, String var2, List<String> var3) throws Exception;

    public void unshareAddressBook(String var1, String var2, String var3) throws Exception;

    public AddressBook getSharedAddressBook(String var1, String var2) throws Exception;

    public List<SharedAddressBook> getSharedAddressBooks(String var1) throws Exception;

    public void saveContactToSharedAddressBook(String var1, String var2, Contact var3, boolean var4) throws Exception;

    public ContactPageList getSharedContactsByAddressBook(String var1, SharedAddressBook var2) throws Exception;

    public Contact getSharedContact(String var1, String var2) throws Exception;

    public void saveSharedContact(String var1, Contact var2) throws Exception;

    public Contact getSharedContactAddressBook(String var1, String var2) throws Exception;

    public List<Tag> getTags(String var1) throws Exception;

    public Tag getTag(String var1, String var2) throws Exception;

    public DataPageList getContactPageListByTag(String var1, String var2) throws Exception;

    public void addTag(String var1, List<String> var2, List<Tag> var3) throws Exception;

    public void addTag(String var1, List<String> var2, String var3) throws Exception;

    public Tag removeTag(String var1, String var2) throws Exception;

    public void removeContactTag(String var1, List<String> var2, List<String> var3) throws Exception;

    public void updateTag(String var1, Tag var2) throws Exception;

    public void pasteAddressBook(String var1, String var2, String var3, String var4, String var5) throws Exception;

    public List<Contact> pasteContacts(String var1, String var2, String var3, Map<String, String> var4, boolean var5) throws Exception;

    public ContactImportExport getContactImportExports(String var1);

    public String[] getImportExportType() throws Exception;

    public void registerNewUser(User var1, boolean var2) throws Exception;

    public void updateProfile(UserProfile var1) throws Exception;

    public void saveAddress(String var1, String var2) throws Exception;

    public List<String> getPublicAddressBookIdsOfUser(String var1) throws Exception;

    public List<String> getAllsPublicAddressBookIds(String var1) throws Exception;

    public List<String> getAllEmailByPublicGroup(String var1, String var2) throws Exception;

    public List<String> getAllEmailBySharedGroup(String var1, String var2) throws Exception;

    public boolean haveEditPermissionOnContact(String var1, Contact var2) throws Exception;

    public void addListenerPlugin(ContactEventListener var1) throws Exception;

    public void savePublicAddressBook(AddressBook var1, boolean var2) throws Exception;
}

