/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ID3v1Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private String genre;
    private String trackNumber;
    boolean found = false;

    public ID3v1Handler(InputStream stream, ContentHandler handler) throws IOException, SAXException, TikaException {
        this(ID3v1Handler.getSuffix(stream, 128));
    }

    protected ID3v1Handler(byte[] tagData) throws IOException, SAXException, TikaException {
        if (tagData.length == 128 && tagData[0] == 84 && tagData[1] == 65 && tagData[2] == 71) {
            this.found = true;
            this.title = ID3v1Handler.getString(tagData, 3, 33);
            this.artist = ID3v1Handler.getString(tagData, 33, 63);
            this.album = ID3v1Handler.getString(tagData, 63, 93);
            this.year = ID3v1Handler.getString(tagData, 93, 97);
            this.comment = ID3v1Handler.getString(tagData, 97, 127);
            int genreID = tagData[127] & 0xFF;
            this.genre = GENRES[Math.min(genreID, GENRES.length - 1)];
            if (tagData[125] == 0 && tagData[126] != 0) {
                int trackNum = tagData[126] & 0xFF;
                this.trackNumber = Integer.toString(trackNum);
            }
        }
    }

    public boolean getTagsPresent() {
        return this.found;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getTrackNumber() {
        return this.trackNumber;
    }

    private static String getString(byte[] buffer, int start, int end) throws TikaException {
        for (int zero = start; zero < end && buffer[zero] != 0; ++zero) {
        }
        for (end = zero; start < end && buffer[end - 1] <= 32; --end) {
        }
        while (start < end && buffer[start] <= 32) {
            ++start;
        }
        try {
            return new String(buffer, start, end - start, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new TikaException("ISO-8859-1 encoding is not available", (Throwable)e);
        }
    }

    private static byte[] getSuffix(InputStream stream, int length) throws IOException {
        byte[] buffer = new byte[2 * length];
        int bytesInBuffer = 0;
        int n = stream.read(buffer);
        while (n != -1) {
            if ((bytesInBuffer += n) == buffer.length) {
                System.arraycopy(buffer, bytesInBuffer - length, buffer, 0, length);
                bytesInBuffer = length;
            }
            n = stream.read(buffer, bytesInBuffer, buffer.length - bytesInBuffer);
        }
        if (bytesInBuffer < length) {
            length = bytesInBuffer;
        }
        byte[] result = new byte[length];
        System.arraycopy(buffer, bytesInBuffer - length, result, 0, length);
        return result;
    }
}

