/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.EntityProvider;
import org.apache.commons.httpclient.methods.RequestEntity;

public class EntityProviderRequestEntity
implements RequestEntity {
    private final Abdera abdera;
    private final EntityProvider provider;
    private byte[] buf = null;
    private boolean use_chunked = true;
    private boolean auto_indent = false;
    private String encoding = "UTF-8";

    public EntityProviderRequestEntity(Abdera abdera, EntityProvider provider, boolean use_chunked) {
        this.abdera = abdera;
        this.use_chunked = use_chunked;
        this.provider = provider;
    }

    private void write(OutputStream out) {
        this.provider.writeTo(this.abdera.newStreamWriter().setOutputStream(out, this.encoding).setAutoIndent(this.auto_indent));
    }

    public long getContentLength() {
        if (this.use_chunked) {
            return -1L;
        }
        if (this.buf == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.write(out);
                this.buf = out.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.buf.length;
    }

    public String getContentType() {
        return this.provider.getContentType();
    }

    public boolean isRepeatable() {
        return this.provider.isRepeatable();
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (this.use_chunked) {
            this.write(out);
        } else {
            if (this.buf == null) {
                this.getContentLength();
            }
            out.write(this.buf);
            out.flush();
        }
    }

    public boolean isAutoIndent() {
        return this.auto_indent;
    }

    public void setAutoIndent(boolean auto_indent) {
        this.auto_indent = auto_indent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

