/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.content.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.command.query.ExecuteSelectorCommand;
import org.xcmis.search.content.command.query.ProcessQueryCommand;
import org.xcmis.search.content.interceptors.CommandInterceptor;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.query.QueryExecutionContext;
import org.xcmis.search.query.QueryExecutionExceptions;
import org.xcmis.search.query.Statistics;
import org.xcmis.search.query.plan.Optimizer;
import org.xcmis.search.query.plan.QueryExecutionPlan;
import org.xcmis.search.query.plan.QueryExecutionPlaner;
import org.xcmis.search.result.ScoredRow;

public class QueryProcessorInterceptor
extends CommandInterceptor {
    private final QueryExecutionPlaner planner;
    private final Optimizer optimizer;

    public QueryProcessorInterceptor(QueryExecutionPlaner planner, Optimizer optimizer) {
        this.planner = planner;
        this.optimizer = optimizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitProcessQueryCommand(InvocationContext ctx, ProcessQueryCommand command) throws Throwable {
        QueryExecutionExceptions executionExceptions = new QueryExecutionExceptions();
        try {
            List<ScoredRow> list = this.execute(ctx, new QueryExecutionContext(ctx.getSchema(), executionExceptions, command.getBindVariablesValues()), command.getQuery());
            return list;
        }
        finally {
            if (executionExceptions.hasProblems()) {
                throw executionExceptions.getTopException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScoredRow> execute(InvocationContext ctx, QueryExecutionContext context, Query query) {
        Validate.notNull((Object)context, (String)"The context argument may not be null");
        Validate.notNull((Object)query, (String)"The query argument may not be null");
        long start = System.nanoTime();
        QueryExecutionPlan executionPlan = this.planner.createPlan(context, query);
        long duration = System.nanoTime() - start;
        Statistics stats = new Statistics(duration);
        if (!context.getExecutionExceptions().hasProblems()) {
            start = System.nanoTime();
            QueryExecutionPlan optimizedPlan = this.optimizer.optimize(context, executionPlan);
            duration = System.nanoTime() - start;
            stats = stats.withOptimizationTime(duration);
            if (!context.getExecutionExceptions().hasProblems()) {
                try {
                    start = System.nanoTime();
                    List<ScoredRow> list = this.execute(ctx, context, query, stats, optimizedPlan);
                    return list;
                }
                finally {
                    duration = System.nanoTime() - start;
                    stats = stats.withOptimizationTime(duration);
                }
            }
        }
        return Collections.emptyList();
    }

    private List<ScoredRow> execute(InvocationContext ctx, QueryExecutionContext context, Query query, Statistics stats, QueryExecutionPlan queryPlan) {
        QueryExecuteableComponent component = this.createQueryExecuteableComponent(queryPlan);
        return component.executeComponent(ctx, context);
    }

    private QueryExecuteableComponent createQueryExecuteableComponent(QueryExecutionPlan queryExecutionPlan) {
        QueryExecutionPlan.LimitExecutionPlan limitPlan = null;
        QueryExecutionPlan.SortExecutionPlan sortPlan = null;
        QueryExecutionPlan.ProjectExecutionPlan projectPlan = null;
        ArrayList<QueryExecutionPlan.WhereExecutionPlan> constraintsPlan = new ArrayList<QueryExecutionPlan.WhereExecutionPlan>();
        QueryExecutionPlan nextPlan = queryExecutionPlan;
        do {
            switch (nextPlan.getType()) {
                case LIMIT: {
                    limitPlan = (QueryExecutionPlan.LimitExecutionPlan)nextPlan;
                    break;
                }
                case SORT: {
                    sortPlan = (QueryExecutionPlan.SortExecutionPlan)nextPlan;
                    break;
                }
                case PROJECT: {
                    projectPlan = (QueryExecutionPlan.ProjectExecutionPlan)nextPlan;
                    break;
                }
                case WHERE: {
                    constraintsPlan.add((QueryExecutionPlan.WhereExecutionPlan)nextPlan);
                    break;
                }
                case SELECTOR: {
                    return new SelectorExecuteableComponent(this, (QueryExecutionPlan.SelectorExecutionPlan)nextPlan, projectPlan, constraintsPlan, sortPlan, limitPlan);
                }
                case JOIN: {
                    QueryExecutionPlan.JoinExecutionPlan joinPlan = (QueryExecutionPlan.JoinExecutionPlan)nextPlan;
                    QueryExecuteableComponent left = this.createQueryExecuteableComponent(joinPlan.getLeftPlan());
                    QueryExecuteableComponent right = this.createQueryExecuteableComponent(joinPlan.getRightPlan());
                    return new JoinExecutionComponent(this, joinPlan, left, right, projectPlan, constraintsPlan, sortPlan, limitPlan);
                }
                default: {
                    throw new NotImplementedException("Execution for plan " + queryExecutionPlan.getType().toString() + " not implemented");
                }
            }
        } while ((nextPlan = nextPlan.next()) != null);
        return null;
    }

    private class JoinExecutionComponent
    extends QueryExecuteableComponent {
        private final QueryExecutionPlan.JoinExecutionPlan joinPlan;

        public JoinExecutionComponent(CommandInterceptor interceptor, QueryExecutionPlan.JoinExecutionPlan joinPlan, QueryExecuteableComponent left, QueryExecuteableComponent right, QueryExecutionPlan.ProjectExecutionPlan projectPlan, List<QueryExecutionPlan.WhereExecutionPlan> constraintsPlan, QueryExecutionPlan.SortExecutionPlan sortPlan, QueryExecutionPlan.LimitExecutionPlan limitPlan) {
            super(interceptor, projectPlan, constraintsPlan, sortPlan, limitPlan);
            this.joinPlan = joinPlan;
        }

        @Override
        public List<ScoredRow> executeComponent(InvocationContext ctx, QueryExecutionContext context) {
            throw new NotImplementedException("Method not implemented");
        }

        public QueryExecutionPlan.JoinExecutionPlan getJoinPlan() {
            return this.joinPlan;
        }
    }

    private class SelectorExecuteableComponent
    extends QueryExecuteableComponent {
        private final QueryExecutionPlan.SelectorExecutionPlan selectorExecutionPlan;

        public SelectorExecuteableComponent(CommandInterceptor interceptor, QueryExecutionPlan.SelectorExecutionPlan selectorExecutionPlan, QueryExecutionPlan.ProjectExecutionPlan projectPlan, List<QueryExecutionPlan.WhereExecutionPlan> constraintsPlan, QueryExecutionPlan.SortExecutionPlan sortPlan, QueryExecutionPlan.LimitExecutionPlan limitPlan) {
            super(interceptor, projectPlan, constraintsPlan, sortPlan, limitPlan);
            this.selectorExecutionPlan = selectorExecutionPlan;
        }

        public QueryExecutionPlan.SelectorExecutionPlan getSelectorExecutionPlan() {
            return this.selectorExecutionPlan;
        }

        @Override
        public List<ScoredRow> executeComponent(InvocationContext ctx, QueryExecutionContext context) {
            try {
                ExecuteSelectorCommand command = new ExecuteSelectorCommand(this.selectorExecutionPlan.getName(), this.selectorExecutionPlan.getAlias(), this.getConstraints(), this.getLimit(), this.getOrder(), context.getVariables());
                return (List)this.getInterceptor().invokeNextInterceptor(ctx, command);
            }
            catch (Throwable e) {
                context.getExecutionExceptions().addException(e);
                return null;
            }
        }
    }

    private abstract class QueryExecuteableComponent {
        private final QueryExecutionPlan.LimitExecutionPlan limitPlan;
        private final QueryExecutionPlan.SortExecutionPlan sortPlan;
        private final QueryExecutionPlan.ProjectExecutionPlan projectPlan;
        private final List<QueryExecutionPlan.WhereExecutionPlan> constraintsPlan;
        private final CommandInterceptor interceptor;

        public QueryExecuteableComponent(CommandInterceptor interceptor, QueryExecutionPlan.ProjectExecutionPlan projectPlan, List<QueryExecutionPlan.WhereExecutionPlan> constraintsPlan, QueryExecutionPlan.SortExecutionPlan sortPlan, QueryExecutionPlan.LimitExecutionPlan limitPlan) {
            this.interceptor = interceptor;
            this.projectPlan = projectPlan;
            this.constraintsPlan = constraintsPlan;
            this.sortPlan = sortPlan;
            this.limitPlan = limitPlan;
        }

        public CommandInterceptor getInterceptor() {
            return this.interceptor;
        }

        public QueryExecutionPlan.LimitExecutionPlan getLimitPlan() {
            return this.limitPlan;
        }

        public Limit getLimit() {
            return this.limitPlan == null ? Limit.NONE : this.limitPlan.getLimit();
        }

        public QueryExecutionPlan.SortExecutionPlan getSortPlan() {
            return this.sortPlan;
        }

        public List<Ordering> getOrder() {
            return this.sortPlan == null ? new ArrayList() : this.sortPlan.getOrderings();
        }

        public QueryExecutionPlan.ProjectExecutionPlan getProjectPlan() {
            return this.projectPlan;
        }

        public List<QueryExecutionPlan.WhereExecutionPlan> getConstraintsPlan() {
            return this.constraintsPlan;
        }

        public List<Constraint> getConstraints() {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>(this.constraintsPlan.size());
            for (QueryExecutionPlan.WhereExecutionPlan constrain : this.constraintsPlan) {
                constraints.add(constrain.getConstraint());
            }
            return constraints;
        }

        public abstract List<ScoredRow> executeComponent(InvocationContext var1, QueryExecutionContext var2);
    }
}

