/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAQServiceUtils {
    private static final String ANY = "*".intern();
    private static final String COLON = ":".intern();
    private static final String SLASH = "/".intern();

    public static boolean isGroupExpression(String expr) {
        return expr.indexOf(SLASH) >= 0 && expr.indexOf(COLON) < 0;
    }

    public static boolean isMembershipExpression(String expr) {
        return expr.indexOf(SLASH) >= 0 && expr.indexOf(COLON) >= 0;
    }

    private static ListAccess<User> getUserByGroup(UserHandler userHandler, String group) throws Exception {
        try {
            return userHandler.findUsersByGroupId(group);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> getUserByMembershipType(OrganizationService organizationService, String memberShip) throws Exception {
        List<String> users = FAQServiceUtils.getFromCache(new String[]{memberShip});
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        String[] array = memberShip.trim().split(COLON);
        UserHandler userHandler = organizationService.getUserHandler();
        if (array[0].length() > 1) {
            List<String> usersOfGroup = FAQServiceUtils.getUserByGroupId(userHandler, array[1]);
            MembershipHandler membershipHandler = organizationService.getMembershipHandler();
            for (String userName : usersOfGroup) {
                if (membershipHandler.findMembershipByUserGroupAndType(userName, array[1], array[0]) == null) continue;
                users.add(userName);
            }
        } else if (ANY.equals(array[0])) {
            users.addAll(FAQServiceUtils.getUserByGroupId(userHandler, array[1]));
        }
        FAQServiceUtils.storeInCache(new String[]{memberShip}, users);
        return users;
    }

    private static List<String> getUserByGroupId(UserHandler userHandler, String groupId) throws Exception {
        List<String> users = FAQServiceUtils.getFromCache(new String[]{groupId});
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        ListAccess<User> pageList = FAQServiceUtils.getUserByGroup(userHandler, groupId);
        if (pageList == null) {
            return users;
        }
        User[] userArray = (User[])pageList.load(0, pageList.getSize());
        for (int i = 0; i < pageList.getSize(); ++i) {
            users.add(userArray[i].getUserName());
        }
        FAQServiceUtils.storeInCache(new String[]{groupId}, users);
        return users;
    }

    public static List<String> getUserPermission(String[] userGroupMembership) throws Exception {
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership.length == 1 && userGroupMembership[0].equals(" ")) {
            return new ArrayList<String>();
        }
        List<String> list = FAQServiceUtils.getFromCache(userGroupMembership);
        if (list != null) {
            return list;
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        HashSet<String> users = new HashSet<String>();
        for (int j = 0; j < userGroupMembership.length; ++j) {
            String str = userGroupMembership[j].trim();
            if (FAQServiceUtils.isMembershipExpression(str)) {
                users.addAll(FAQServiceUtils.getUserByMembershipType(organizationService, str));
                continue;
            }
            if (FAQServiceUtils.isGroupExpression(str)) {
                users.addAll(FAQServiceUtils.getUserByGroupId(organizationService.getUserHandler(), str));
                continue;
            }
            users.add(str);
        }
        FAQServiceUtils.storeInCache(userGroupMembership, new ArrayList<String>(users));
        return new ArrayList<String>(users);
    }

    private static void storeInCache(String[] userGroupMembership, List<String> users) throws Exception {
        ExoCache<Serializable, List<String>> cache = FAQServiceUtils.getCache();
        Serializable cacheKey = FAQServiceUtils.getCacheKey(userGroupMembership);
        cache.put(cacheKey, users);
    }

    private static List<String> getFromCache(String[] userGroupMembership) throws Exception {
        if (userGroupMembership == null || userGroupMembership.length == 0 || userGroupMembership.length == 1 && userGroupMembership[0].length() == 0) {
            return null;
        }
        ExoCache<Serializable, List<String>> cache = FAQServiceUtils.getCache();
        Serializable cacheKey = FAQServiceUtils.getCacheKey(userGroupMembership);
        return (List)cache.get(cacheKey);
    }

    private static Serializable getCacheKey(String[] userGroupMembership) {
        StringBuilder sb = new StringBuilder();
        for (String item : userGroupMembership) {
            sb.append("#").append(item);
        }
        return sb.toString();
    }

    private static ExoCache<Serializable, List<String>> getCache() throws Exception {
        CacheService cacheService = (CacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CacheService.class);
        return cacheService.getCacheInstance("org.exoplatform.faq.PermissionsUsers");
    }

    @Deprecated
    public static List<String> getAllGroupAndMembershipOfUser(String userId) throws Exception {
        return UserHelper.getAllGroupAndMembershipOfUser((String)userId);
    }

    public static void reparePermissions(Node node, String owner) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(owner, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
    }

    public static SessionManager getSessionManager() {
        KSDataLocation location = (KSDataLocation)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(KSDataLocation.class);
        return location.getSessionManager();
    }
}

