/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.filter.authz;

import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.CollectionUtils;
import org.jsecurity.web.filter.authz.AuthorizationFilter;

public class RolesAuthorizationFilter
extends AuthorizationFilter {
    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        Subject subject = this.getSubject(request, response);
        String[] rolesArray = (String[])mappedValue;
        if (rolesArray == null || rolesArray.length == 0) {
            return true;
        }
        Set<String> roles = CollectionUtils.asSet(rolesArray);
        return subject.hasAllRoles(roles);
    }
}

