/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.ancillary.jsdoc.HtmlRenderer;
import com.google.caja.ancillary.jsdoc.Jsdoc;
import com.google.caja.ancillary.jsdoc.JsdocException;
import com.google.caja.ancillary.linter.Linter;
import com.google.caja.ancillary.opt.JsOptimizer;
import com.google.caja.ancillary.servlet.CajaWebToolsMessageType;
import com.google.caja.ancillary.servlet.CajaWebToolsServlet;
import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.HtmlReducer;
import com.google.caja.ancillary.servlet.Job;
import com.google.caja.ancillary.servlet.LintPage;
import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.Resources;
import com.google.caja.ancillary.servlet.UserAgentDb;
import com.google.caja.ancillary.servlet.ZipFileSystem;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HTML;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Punctuation;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Statement;
import com.google.caja.plugin.CssPropertyPartType;
import com.google.caja.plugin.CssRewriter;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.plugin.stages.HtmlEmbeddedContentFinder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssMinimalPrinter;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Multimap;
import com.google.caja.util.Multimaps;
import com.google.caja.util.Name;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Processor {
    private final Request req;
    private final MessageQueue mq;
    private static final Set<MessageTypeInt> IGNORED = Sets.immutableSet(PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, PluginMessageType.UNSAFE_CSS_PROPERTY, PluginMessageType.UNSAFE_TAG, PluginMessageType.CSS_ATTRIBUTE_TYPE_NOT_ALLOWED_IN_SELECTOR, PluginMessageType.CSS_ATTRIBUTE_NAME_NOT_ALLOWED_IN_SELECTOR, PluginMessageType.CSS_DASHMATCH_ATTRIBUTE_OPERATOR_NOT_ALLOWED, PluginMessageType.IMPORTS_NOT_ALLOWED_HERE, PluginMessageType.FONT_FACE_NOT_ALLOWED);

    Processor(Request req, MessageQueue mq) {
        this.req = req;
        this.mq = mq;
    }

    List<Job> process(List<Job> inputJobs) throws IOException {
        List<Job> jobs = Lists.newArrayList();
        for (Job job : inputJobs) {
            jobs.addAll(this.extractJobs(job));
        }
        if (this.req.lint) {
            this.lint(jobs);
        }
        if (this.req.opt) {
            this.optimize(jobs);
        }
        if (this.req.minify || this.req.opt) {
            this.reincorporateExtracted(jobs);
        }
        List<Job> output = Lists.newArrayList();
        switch (this.req.verb) {
            case DOC: {
                try {
                    output.add(this.doc(jobs, this.req, this.mq));
                }
                catch (JsdocException ex) {
                    ex.toMessageQueue(this.mq);
                }
                break;
            }
            case LINT: {
                output.add(Job.html(LintPage.render(this.reduce(jobs), this.req, this.mq), null));
                break;
            }
            default: {
                for (Job job : jobs) {
                    if (job.origin != null) continue;
                    output.add(job);
                }
            }
        }
        Processor.removeCajolerSpecificMessages(this.mq);
        return output;
    }

    Content reduce(List<Job> jobs) {
        ContentType otype = this.req.otype;
        if (otype == null) {
            ContentType commonType = null;
            for (Job job : jobs) {
                if (commonType == null) {
                    commonType = job.t;
                    continue;
                }
                if (commonType == job.t) continue;
                commonType = null;
                break;
            }
            ContentType contentType = otype = commonType != null ? commonType : ContentType.HTML;
        }
        if (otype != ContentType.XML && otype != ContentType.HTML) {
            for (Job job : jobs) {
                if (job.t == otype) continue;
                this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.INCOMPATIBLE_OUTPUT_TYPE, MessagePart.Factory.valueOf(job.t.name()), MessagePart.Factory.valueOf(otype.name()));
                otype = ContentType.HTML;
                break;
            }
        }
        if (!otype.isText) {
            if (jobs.size() != 1) {
                throw new AssertionError();
            }
            return new Content((byte[])jobs.get((int)0).root, otype);
        }
        StringBuilder outBuf = new StringBuilder();
        RenderContext out = this.makeRenderContext(outBuf, otype);
        switch (otype) {
            case XML: 
            case HTML: {
                HtmlQuasiBuilder b = HtmlQuasiBuilder.getBuilder(DomParser.makeDocument(null, null));
                DocumentFragment f = b.getDocument().createDocumentFragment();
                for (Job job : jobs) {
                    Node toAdd;
                    switch (job.t) {
                        case XML: 
                        case HTML: {
                            toAdd = f.getOwnerDocument().importNode((DocumentFragment)job.root, true);
                            break;
                        }
                        case JS: {
                            StringBuilder sb = new StringBuilder();
                            RenderContext renderContext = this.makeRenderContext(sb, ContentType.JS).withEmbeddable(true);
                            ((Block)job.root).renderBody(renderContext);
                            renderContext.getOut().noMoreTokens();
                            toAdd = b.substV("<script>@js</script>", "js", sb.toString());
                            break;
                        }
                        case CSS: {
                            StringBuilder sb = new StringBuilder();
                            RenderContext renderContext = this.makeRenderContext(sb, ContentType.CSS).withEmbeddable(true);
                            ((CssTree.StyleSheet)job.root).render(renderContext);
                            renderContext.getOut().noMoreTokens();
                            toAdd = b.substV("<style>", "css", sb.toString());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)job.t.name());
                        }
                    }
                    if (toAdd instanceof DocumentFragment) {
                        for (Node node : Nodes.childrenOf(toAdd)) {
                            f.appendChild(node);
                        }
                        continue;
                    }
                    f.appendChild(toAdd);
                }
                Nodes.render((Node)f, out);
                if (otype != ContentType.HTML || !this.req.minify) break;
                out.getOut().noMoreTokens();
                String html = outBuf.toString();
                outBuf.setLength(0);
                try {
                    HtmlReducer.reduce(html, outBuf);
                }
                catch (ParseException ex) {
                    outBuf.setLength(0);
                    outBuf.append(html);
                }
                break;
            }
            case JS: {
                List<? extends Statement> stmts = Lists.newArrayList();
                for (Job job : jobs) {
                    stmts.addAll(((Block)job.root).children());
                }
                new Block(FilePosition.UNKNOWN, stmts).renderBody(out);
                break;
            }
            case JSON: {
                for (Job job : jobs) {
                    ((Expression)job.root).render(out);
                }
                break;
            }
            case CSS: {
                for (Job job : jobs) {
                    ((CssTree.StyleSheet)job.root).render(out);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)otype.name());
            }
        }
        out.getOut().noMoreTokens();
        return new Content(outBuf.toString(), otype);
    }

    Job parse(CharProducer cp, ContentType contentType, Node src, URI baseUri) throws ParseException {
        FilePosition inputRange = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
        InputSource is = inputRange.source();
        switch (contentType) {
            case XML: 
            case HTML: {
                DomParser p;
                HtmlLexer lexer = new HtmlLexer(cp.clone());
                if (contentType == ContentType.HTML) {
                    Token firstTag = null;
                    while (lexer.hasNext()) {
                        Token t = lexer.next();
                        if (t.type != HtmlTokenType.TAGBEGIN) continue;
                        firstTag = t;
                        break;
                    }
                    p = new DomParser(new HtmlLexer(cp), false, is, this.mq);
                    if (firstTag != null && Strings.equalsIgnoreCase(firstTag.text, "<html")) {
                        Element el = p.parseDocument();
                        DocumentFragment f = el.getOwnerDocument().createDocumentFragment();
                        f.appendChild(el);
                        return Job.html(f, baseUri);
                    }
                } else {
                    lexer.setTreatedAsXml(contentType == ContentType.XML);
                    TokenQueue<HtmlTokenType> tq = new TokenQueue<HtmlTokenType>(lexer, is, DomParser.SKIP_COMMENTS);
                    tq.setInputRange(inputRange);
                    p = new DomParser(tq, contentType == ContentType.XML, this.mq);
                }
                return Job.html(p.parseFragment(), baseUri);
            }
            case JS: {
                JsLexer lexer = new JsLexer(cp);
                JsTokenQueue tq = new JsTokenQueue(lexer, is);
                if (tq.isEmpty()) {
                    return Job.js(new Block(inputRange, Collections.emptyList()), src, baseUri);
                }
                tq.setInputRange(inputRange);
                Block program = new Parser(tq, this.mq, false).parse();
                tq.expectEmpty();
                return Job.js(program, src, baseUri);
            }
            case JSON: {
                JsLexer lexer = new JsLexer(cp);
                JsTokenQueue tq = new JsTokenQueue(lexer, is);
                if (!tq.lookaheadToken(Punctuation.LCURLY)) {
                    tq.expectToken(Punctuation.LCURLY);
                }
                tq.setInputRange(inputRange);
                Expression e = new Parser(tq, this.mq, false).parseExpressionPart(true);
                tq.expectEmpty();
                return Job.json((ObjectConstructor)e, baseUri);
            }
            case CSS: {
                Job job;
                TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, this.mq, false);
                tq.setInputRange(inputRange);
                CssParser p = new CssParser(tq, this.mq, MessageLevel.WARNING);
                if (src instanceof Attr) {
                    CssTree.DeclarationGroup dg = p.parseDeclarationGroup();
                    job = Job.css(dg, (Attr)src, baseUri);
                } else {
                    CssTree.StyleSheet ss = p.parseStyleSheet();
                    job = Job.css(ss, (Element)src, baseUri);
                }
                tq.expectEmpty();
                return job;
            }
        }
        throw new AssertionError((Object)contentType.name());
    }

    RenderContext makeRenderContext(StringBuilder out, ContentType ot) {
        TokenConsumer tc;
        Concatenator cat = new Concatenator(out);
        switch (ot) {
            case XML: 
            case HTML: {
                tc = cat;
                break;
            }
            case CSS: {
                if (this.req.minify) {
                    tc = new CssMinimalPrinter(cat);
                    break;
                }
                tc = new CssPrettyPrinter(cat);
                break;
            }
            case JS: 
            case JSON: {
                if (this.req.minify) {
                    tc = new JsMinimalPrinter(cat);
                    break;
                }
                tc = new JsPrettyPrinter(cat);
                break;
            }
            default: {
                throw new AssertionError((Object)ot.name());
            }
        }
        RenderContext rc = new RenderContext(tc);
        rc = rc.withMarkupRenderMode(ot == ContentType.XML ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
        rc = rc.withAsciiOnly(this.req.asciiOnly);
        rc = rc.withJson(ot == ContentType.JSON);
        rc = rc.withRawObjKeys(this.req.minify);
        return rc;
    }

    private List<Job> extractJobs(Job job) {
        List<Job> all = Lists.newArrayList(job);
        if (job.t == ContentType.XML || job.t == ContentType.HTML) {
            this.extractJobs((Node)job.root, job.baseUri, all);
        }
        return all;
    }

    private void extractJobs(Node node, URI baseUri, List<Job> out) {
        HtmlEmbeddedContentFinder f = new HtmlEmbeddedContentFinder(this.req.htmlSchema, this.req.baseUri, this.mq, this.req.mc);
        block6: for (EmbeddedContent c : f.findEmbeddedContent(node)) {
            ParseTreeNode t;
            if (c.getType() == null || c.getContentLocation() != null) continue;
            Node src = c.getSource();
            try {
                t = c.parse(UriFetcher.NULL_NETWORK, this.mq);
            }
            catch (ParseException ex) {
                ex.toMessageQueue(this.mq);
                continue;
            }
            switch (c.getType()) {
                case JS: {
                    if (src instanceof Element) {
                        out.add(Job.js((Block)t, (Element)src, baseUri));
                        continue block6;
                    }
                    out.add(Job.js((Block)t, (Attr)src, baseUri));
                    continue block6;
                }
                case CSS: {
                    if (src instanceof Element) {
                        out.add(Job.css((CssTree.StyleSheet)t, (Element)src, baseUri));
                        continue block6;
                    }
                    out.add(Job.css((CssTree.DeclarationGroup)t, (Attr)src, baseUri));
                    continue block6;
                }
            }
            throw new SomethingWidgyHappenedError();
        }
    }

    private void lint(List<Job> jobs) {
        List<Block> jsJobs = Lists.newArrayList();
        for (Job job : jobs) {
            switch (job.t) {
                case XML: 
                case HTML: {
                    this.lintMarkup((DocumentFragment)job.root);
                    break;
                }
                case CSS: {
                    this.lintCss((CssTree)job.root);
                    break;
                }
                case JS: {
                    jsJobs.add((Block)job.root);
                    break;
                }
                case JSON: {
                    break;
                }
                case ZIP: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.lintJs(jsJobs);
    }

    private void lintMarkup(Node node) {
        if (node instanceof Element) {
            Element el = (Element)node;
            ElKey elKey = ElKey.forElement(el);
            HTML.Element elInfo = this.req.htmlSchema.lookupElement(elKey);
            if (elInfo == null) {
                this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.UNKNOWN_ELEMENT, Nodes.getFilePositionFor(el), elKey);
            }
            for (Attr attr : Nodes.attributesOf(el)) {
                FilePosition aPos;
                AttribKey aKey = AttribKey.forAttribute(elKey, attr);
                HTML.Attribute aInfo = this.req.htmlSchema.lookupAttribute(aKey);
                if (aInfo == null) {
                    aPos = Nodes.getFilePositionFor(attr);
                    this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.UNKNOWN_ATTRIB, aPos, aKey, elKey);
                    continue;
                }
                if (aInfo.getValueCriterion().accept(attr.getValue())) continue;
                aPos = Nodes.getFilePositionForValue(attr);
                this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.BAD_ATTRIB_VALUE, aPos, aKey, MessagePart.Factory.valueOf(attr.getValue()));
            }
        }
        for (Node node2 : Nodes.childrenOf(node)) {
            this.lintMarkup(node2);
        }
    }

    private void lintCss(CssTree t) {
        CssValidator v = new CssValidator(this.req.cssSchema, this.req.htmlSchema, this.mq);
        v.validateCss(AncestorChain.instance(t));
    }

    private void lintJs(List<Block> programs) {
        if (programs.isEmpty()) {
            return;
        }
        List<Linter.LintJob> lintJobs = Lists.newArrayList();
        for (Block program : programs) {
            lintJobs.add(Linter.makeLintJob(program, this.mq));
        }
        Linter.lint(lintJobs, Linter.BROWSER_ENVIRONMENT, this.mq);
    }

    private void optimize(List<Job> jobs) {
        ListIterator<Job> jobIt = jobs.listIterator();
        block5: while (jobIt.hasNext()) {
            Job job = jobIt.next();
            switch (job.t) {
                case JS: {
                    job = this.optimizeJs(job);
                    break;
                }
                case HTML: {
                    job = this.optimizeHtml(job);
                    break;
                }
                case CSS: {
                    job = this.optimizeCss(job);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            jobIt.set(job);
        }
    }

    private Job optimizeJs(Job job) {
        ObjectConstructor envJson;
        JsOptimizer opt = new JsOptimizer(this.mq);
        opt.addInput((Block)job.root);
        ObjectConstructor objectConstructor = envJson = this.req.userAgent != null ? UserAgentDb.lookupEnvJson(this.req.userAgent) : null;
        if (envJson == null) {
            envJson = new ObjectConstructor(FilePosition.UNKNOWN);
        }
        opt.setEnvJson(envJson);
        opt.setRename(true);
        Statement optimized = opt.optimize();
        if (!(optimized instanceof Block)) {
            optimized = new Block(optimized.getFilePosition(), Collections.singletonList(optimized));
        }
        return Job.js((Block)optimized, job.origin, job.baseUri);
    }

    private Job optimizeHtml(Job job) {
        DocumentFragment f = (DocumentFragment)job.root;
        this.optimizeHtml(f);
        return job;
    }

    private Job optimizeCss(Job job) {
        final CssValidator v = new CssValidator(this.req.cssSchema, this.req.htmlSchema, DevNullMessageQueue.singleton());
        CssTree t = (CssTree)job.root;
        v.validateCss(AncestorChain.instance(t));
        t.acceptPostOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                CssTree.HashLiteral hash;
                String color;
                if (ac.node instanceof CssTree.RuleSet || ac.node instanceof CssTree.DeclarationGroup) {
                    Processor.this.optimizeCssDeclarations(ac.cast(CssTree.class), v);
                } else if (ac.node instanceof CssTree.IdentLiteral) {
                    CssTree.IdentLiteral id;
                    CssTree.HashLiteral hash2;
                    Name part = ac.parent.node.getAttributes().get(CssValidator.CSS_PROPERTY_PART);
                    if (part == null) {
                        return true;
                    }
                    String partS = part.getCanonicalForm();
                    if (("color".equals(partS) || partS.endsWith("::color")) && (hash2 = CssRewriter.colorHash((id = (CssTree.IdentLiteral)ac.cast(CssTree.IdentLiteral.class).node).getFilePosition(), Name.css(id.getValue()))) != null && hash2.getValue().length() < id.getValue().length()) {
                        hash2.getAttributes().putAll(id.getAttributes());
                        ((CssTree)ac.parent.node).replaceChild(hash2, id);
                    }
                } else if (ac.node instanceof CssTree.HashLiteral && ac.parent.node.getAttributes().get(CssValidator.CSS_PROPERTY_PART_TYPE) == CssPropertyPartType.COLOR && (color = (hash = (CssTree.HashLiteral)ac.cast(CssTree.HashLiteral.class).node).getValue()).length() == 7) {
                    int hex = Integer.valueOf(color.substring(1), 16);
                    CssTree.HashLiteral shortHash = CssRewriter.colorHash(hash.getFilePosition(), hex);
                    if (shortHash.getValue().length() < hash.getValue().length()) {
                        shortHash.getAttributes().putAll(hash.getAttributes());
                        ((CssTree)ac.parent.node).replaceChild(shortHash, hash);
                    }
                }
                return true;
            }
        }, null);
        return job;
    }

    private static Name propertyPrefix(Name propertyName) {
        String canon = propertyName.getCanonicalForm();
        int dash = canon.lastIndexOf(45);
        if (dash < 0) {
            return null;
        }
        return Name.css(canon.substring(0, dash));
    }

    private void optimizeCssDeclarations(AncestorChain<? extends CssTree> cont, CssValidator v) {
        CssTree.PropertyDeclaration pd;
        List<CssTree.Declaration> decls = Lists.newArrayList();
        for (CssTree cssTree : ((CssTree)cont.node).children()) {
            if (!(cssTree instanceof CssTree.Declaration)) continue;
            decls.add((CssTree.Declaration)cssTree);
        }
        Multimap<Name, Name> propertyPrefixes = Multimaps.newListHashMultimap();
        Iterator iterator = decls.iterator();
        while (iterator.hasNext()) {
            CssTree.Declaration d = (CssTree.Declaration)iterator.next();
            if (d instanceof CssTree.EmptyDeclaration) {
                ((CssTree)cont.node).removeChild(d);
                iterator.remove();
                continue;
            }
            if (d instanceof CssTree.PropertyDeclaration) {
                Name name;
                pd = (CssTree.PropertyDeclaration)d;
                Name n = name = pd.getProperty().getPropertyName();
                while (n != null) {
                    propertyPrefixes.put(n, name);
                    n = Processor.propertyPrefix(n);
                }
                continue;
            }
            if (!(d instanceof CssTree.UserAgentHack)) continue;
            for (CssTree cssTree : d.children()) {
                Name propName;
                CssTree.PropertyDeclaration pd2 = (CssTree.PropertyDeclaration)cssTree;
                Name n = propName = pd2.getProperty().getPropertyName();
                while (n != null) {
                    propertyPrefixes.put(n, propName);
                    n = Processor.propertyPrefix(n);
                }
            }
        }
        for (CssTree.Declaration d : decls) {
            CssSchema.CssPropertyInfo si;
            CssTree.Property property;
            Name pName;
            CssSchema.CssPropertyInfo i;
            if (!(d instanceof CssTree.PropertyDeclaration) || (i = this.req.cssSchema.getCssProperty(pName = (property = (pd = (CssTree.PropertyDeclaration)d).getProperty()).getPropertyName())) == null) continue;
            Name shortName = pName;
            List<String> pExprTypes = null;
            CssTree.Expr shortened = null;
            Name prefix = shortName;
            while ((prefix = Processor.propertyPrefix(prefix)) != null && propertyPrefixes.get(prefix).size() == 1 && (si = this.req.cssSchema.getCssProperty(prefix)) != null) {
                CssTree.Expr e = (CssTree.Expr)pd.getExpr().clone();
                Processor.clearAttributes(e);
                if (!v.applySignature(prefix, e, si.sig)) break;
                if (pExprTypes == null) {
                    pExprTypes = Processor.cssExprParts(pd.getExpr());
                }
                if (!Processor.cssExprPartsConsistent(Processor.cssExprParts(e), pExprTypes, pName.getCanonicalForm())) break;
                shortName = prefix;
                shortened = e;
            }
            if (shortName == pName) continue;
            pd.replaceChild(shortened, pd.getExpr());
            pd.replaceChild(new CssTree.Property(property.getFilePosition(), shortName), property);
        }
    }

    private static void clearAttributes(CssTree t) {
        t.getAttributes().remove(CssValidator.CSS_PROPERTY_PART);
        t.getAttributes().remove(CssValidator.CSS_PROPERTY_PART_TYPE);
        for (CssTree cssTree : t.children()) {
            Processor.clearAttributes(cssTree);
        }
    }

    private static List<String> cssExprParts(CssTree t) {
        final List out = Lists.newArrayList();
        t.acceptPostOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                Name part = ac.node.getAttributes().get(CssValidator.CSS_PROPERTY_PART);
                if (part != null) {
                    out.add(part.getCanonicalForm());
                }
                return true;
            }
        }, null);
        return Collections.unmodifiableList(out);
    }

    private static boolean cssExprPartsConsistent(List<? extends String> a, List<? extends String> b, String toIgnore) {
        int n;
        if (toIgnore.startsWith("background-")) {
            toIgnore = "background";
        }
        if ((n = a.size()) != b.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String sa = a.get(i);
            String sb = b.get(i);
            if (sa == null) {
                return sb == null;
            }
            if (sb == null) {
                return false;
            }
            if (Processor.withoutCssPartPrefix(sa, toIgnore).equals(Processor.withoutCssPartPrefix(sb, toIgnore))) continue;
            return false;
        }
        return true;
    }

    private static String withoutCssPartPrefix(String part, String prefix) {
        int n = part.length();
        int pn = prefix.length();
        int i = 0;
        while (i < n && part.regionMatches(i, prefix, 0, pn)) {
            int e = i + pn;
            if (e != n) {
                int dc = part.indexOf("::", e);
                char ch = part.charAt(e);
                if (ch != '-' && e != dc) break;
                i = dc < 0 ? n : dc + 2;
                continue;
            }
            i = e;
        }
        return part.substring(i);
    }

    /*
     * WARNING - void declaration
     */
    private void optimizeHtml(Node n) {
        if (n instanceof Element) {
            Element el = (Element)n;
            ElKey elKey = ElKey.forElement(el);
            List<Attr> toRemove = Lists.newArrayList();
            for (Attr attr : Nodes.attributesOf(el)) {
                AttribKey aKey = AttribKey.forAttribute(elKey, attr);
                HTML.Attribute aInfo = this.req.htmlSchema.lookupAttribute(aKey);
                if (aInfo == null || !attr.getValue().equals(aInfo.getDefaultValue())) continue;
                toRemove.add(attr);
            }
            for (Attr attr : toRemove) {
                el.removeAttributeNode(attr);
            }
            HTML.Element elInfo = this.req.htmlSchema.lookupElement(elKey);
            if (elInfo != null && !elInfo.canContainText()) {
                void var6_10;
                Node node = el.getFirstChild();
                while (var6_10 != null) {
                    Node next = var6_10.getNextSibling();
                    if (var6_10 instanceof Text && "".equals(var6_10.getNodeValue().trim())) {
                        el.removeChild((Node)var6_10);
                    }
                    Node node2 = next;
                }
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            this.optimizeHtml(c);
        }
    }

    private Job doc(List<Job> jobs, Request req, MessageQueue mq) throws IOException, JsdocException {
        Jsdoc jsdoc = new Jsdoc(req.mc, mq);
        for (Job job : jobs) {
            if (job.t != ContentType.JS || job.origin instanceof Attr) continue;
            Block program = (Block)job.root;
            jsdoc.addSource(program);
        }
        try {
            jsdoc.addInitFile("/js/jqueryjs/runtest/env.js", "" + Resources.read(CajaWebToolsServlet.class, "/js/jqueryjs/runtest/env.js"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ObjectConstructor json = jsdoc.extract();
        if (req.otype == ContentType.JSON) {
            return Job.json(json, null);
        }
        ZipFileSystem fs = new ZipFileSystem("/jsdoc");
        StringBuilder jsonSb = new StringBuilder();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(jsonSb))).withJson(true);
        json.render(rc);
        rc.getOut().noMoreTokens();
        HtmlRenderer.buildHtml("" + jsonSb, fs, new File("/jsdoc"), req.srcMap.values(), req.mc);
        return fs.toZip();
    }

    private void reincorporateExtracted(List<Job> jobs) {
        Iterator<Job> jobsIt = jobs.iterator();
        while (jobsIt.hasNext()) {
            HTML.Attribute aInfo;
            Node origin;
            Job job = jobsIt.next();
            if (job.origin == null) continue;
            StringBuilder sb = new StringBuilder();
            RenderContext rc = this.makeRenderContext(sb, job.t).withEmbeddable(true);
            if (job.root instanceof Block) {
                ((Block)job.root).renderBody(rc);
            } else {
                ((ParseTreeNode)job.root).render(rc);
            }
            rc.getOut().noMoreTokens();
            String rendered = sb.toString();
            if (job.origin instanceof Element) {
                origin = (Element)job.origin;
                while (origin.getFirstChild() != null) {
                    origin.removeChild(origin.getFirstChild());
                }
                origin.appendChild(origin.getOwnerDocument().createTextNode(rendered));
                jobsIt.remove();
                continue;
            }
            if (!(job.origin instanceof Attr)) continue;
            origin = (Attr)job.origin;
            if (job.t == ContentType.JS && (aInfo = this.req.htmlSchema.lookupAttribute(AttribKey.forAttribute(ElKey.forElement(origin.getOwnerElement()), (Attr)origin))) != null && aInfo.getType() == HTML.Attribute.Type.URI) {
                rendered = "javascript:" + UriUtil.encode(rendered);
            }
            origin.setNodeValue(rendered);
            jobsIt.remove();
        }
    }

    private static void removeCajolerSpecificMessages(MessageQueue mq) {
        Iterator<Message> i = mq.getMessages().iterator();
        while (i.hasNext()) {
            if (!IGNORED.contains(i.next().getMessageType())) continue;
            i.remove();
        }
    }
}

