/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.TimeoutException;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.AckCollector;
import org.jgroups.util.Util;

public class AckCollectorTest
extends TestCase {
    List l = new ArrayList(5);
    AckCollector ac;
    private List new_list = new ArrayList(3);

    public AckCollectorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.l.add("one");
        this.l.add("two");
        this.l.add("three");
        this.l.add("four");
        this.l.add("five");
        this.ac = new AckCollector(this.l);
        this.new_list.add("six");
        this.new_list.add("seven");
        this.new_list.add("eight");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.l.clear();
        this.new_list.clear();
    }

    public void testConstructor() {
        System.out.println("AckCollector is " + this.ac);
        AckCollectorTest.assertEquals((int)5, (int)this.ac.size());
    }

    public void testWaitForAllAcksNoTimeout() {
        new Thread(){

            @Override
            public void run() {
                AckCollectorTest.this.ac.ack("one");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("two");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("three");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("four");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("five");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
            }
        }.start();
        this.ac.waitForAllAcks();
        AckCollectorTest.assertEquals((int)0, (int)this.ac.size());
    }

    public void testWaitForAllAcksWithTimeoutException() {
        try {
            this.ac.waitForAllAcks(200L);
            AckCollectorTest.fail((String)"we should get a timeout exception here");
        }
        catch (TimeoutException e) {
            System.out.println("received timeout exception, as expected");
        }
    }

    public void testWaitForAllAcksWithTimeout() {
        new Thread(){

            @Override
            public void run() {
                AckCollectorTest.this.ac.ack("one");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("two");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("three");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("four");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("five");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
            }
        }.start();
        try {
            this.ac.waitForAllAcks(1000L);
            AckCollectorTest.assertTrue((String)"we should not get a timeout exception here", (boolean)true);
        }
        catch (TimeoutException e) {
            AckCollectorTest.fail((String)"we should not get a timeout exception here");
        }
        AckCollectorTest.assertEquals((int)0, (int)this.ac.size());
    }

    public void testWaitForAllAcksWithTimeoutException2() {
        new Thread(){

            @Override
            public void run() {
                AckCollectorTest.this.ac.ack("one");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("two");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("three");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("four");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("five");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
            }
        }.start();
        try {
            this.ac.waitForAllAcks(300L);
            AckCollectorTest.fail((String)"we should get a timeout exception here");
        }
        catch (TimeoutException e) {
            AckCollectorTest.assertTrue((String)"we should get a timeout exception here", (boolean)true);
        }
    }

    public void testReset() {
        new Thread(){

            @Override
            public void run() {
                Util.sleep(500L);
                System.out.println("resetting AckCollector");
                AckCollectorTest.this.ac.reset(AckCollectorTest.this.new_list);
                System.out.println("reset AckCollector: " + AckCollectorTest.this.ac);
            }
        }.start();
        System.out.println("initial AckCollector: " + this.ac);
        try {
            this.ac.waitForAllAcks(1000L);
            AckCollectorTest.fail((String)"needs to throw TimeoutException");
        }
        catch (TimeoutException e) {
            AckCollectorTest.assertTrue((String)"expected TimeoutException", (e != null ? 1 : 0) != 0);
        }
        System.out.println("new AckCollector: " + this.ac);
    }

    public void testReset2() throws TimeoutException {
        new Thread(){

            @Override
            public void run() {
                Util.sleep(500L);
                System.out.println("resetting AckCollector");
                AckCollectorTest.this.ac.reset(AckCollectorTest.this.new_list);
                System.out.println("reset AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("six");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("seven");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
                Util.sleep(100L);
                AckCollectorTest.this.ac.ack("eight");
                System.out.println("AckCollector: " + AckCollectorTest.this.ac);
            }
        }.start();
        System.out.println("initial AckCollector: " + this.ac);
        this.ac.waitForAllAcks(2000L);
        System.out.println("new AckCollector: " + this.ac);
    }

    public void testNullList() throws TimeoutException {
        AckCollector coll = new AckCollector();
        coll.waitForAllAcks(1000L);
    }

    public void testOneList() throws TimeoutException, UnknownHostException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        tmp.add(addr);
        AckCollector coll = new AckCollector(tmp);
        coll.ack(addr);
        coll.waitForAllAcks(1000L);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{AckCollectorTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

