/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxiedFilterChain
implements FilterChain {
    private static final Log log = LogFactory.getLog(ProxiedFilterChain.class);
    private FilterChain orig;
    private List<Filter> filters;
    private int index = 0;

    public ProxiedFilterChain(FilterChain orig, List<Filter> filters) {
        this.orig = orig;
        this.filters = filters;
        this.index = 0;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.filters == null || this.filters.size() == this.index) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Invoking original filter chain.");
            }
            this.orig.doFilter(request, response);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invoking wrapped filter at index [" + this.index + "]"));
            }
            this.filters.get(this.index++).doFilter(request, response, (FilterChain)this);
        }
    }
}

