/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.CssRuleRewriter;
import com.google.caja.plugin.templates.JsConcatenator;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SafeCssMaker {
    private final List<CssTree.StyleSheet> validatedStylesheets;
    private final Document doc;

    SafeCssMaker(List<CssTree.StyleSheet> validatedStylesheets, Document doc) {
        this.validatedStylesheets = validatedStylesheets;
        this.doc = doc;
    }

    Pair<Statement, Element> make() {
        if (this.validatedStylesheets.isEmpty()) {
            return Pair.pair(null, null);
        }
        List<Expression> cssParts = Lists.newArrayList();
        StringBuilder css = new StringBuilder();
        FilePosition staticPos = null;
        FilePosition dynamicPos = null;
        for (CssTree.StyleSheet ss : this.validatedStylesheets) {
            ArrayConstructor ac = CssRuleRewriter.cssToJs(ss);
            List<? extends Expression> children = ac.children();
            if (children.isEmpty()) continue;
            FilePosition acPos = ac.getFilePosition();
            Expression child0 = children.get(0);
            if (children.size() == 1 && child0 instanceof StringLiteral) {
                css.append('\n').append(((StringLiteral)child0).getUnquotedValue());
                staticPos = staticPos == null ? acPos : FilePosition.span(staticPos, acPos);
                continue;
            }
            int n = cssParts.size();
            if (n == 0) {
                cssParts.addAll(children);
            } else {
                JsConcatenator cat = new JsConcatenator();
                cat.append((Expression)cssParts.get(n - 1));
                cat.append(FilePosition.startOf(child0.getFilePosition()), "\n");
                cat.append(child0);
                cssParts.set(n - 1, cat.toExpression(false));
                cssParts.addAll(children.subList(1, children.size()));
            }
            dynamicPos = dynamicPos == null ? acPos : FilePosition.span(dynamicPos, acPos);
        }
        ExpressionStmt dynamicCss = null;
        Element staticCss = null;
        if (!cssParts.isEmpty()) {
            dynamicCss = new ExpressionStmt(dynamicPos, (Expression)QuasiBuilder.substV("IMPORTS___.emitCss___(@cssParts./*@synthetic*/join(IMPORTS___.getIdClass___()))", "cssParts", new ArrayConstructor(dynamicPos, cssParts)));
        }
        if (css.length() != 0) {
            String nsUri = "http://www.w3.org/1999/xhtml";
            Element style = this.doc.createElementNS(nsUri, "style");
            style.setAttributeNS(nsUri, "type", "text/css");
            style.appendChild(this.doc.createTextNode(css.toString()));
            Nodes.setFilePositionFor(style, dynamicPos);
            staticCss = style;
        }
        return Pair.pair(dynamicCss, staticCss);
    }
}

