/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Maps;
import com.google.caja.util.TestUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrigSourceRendererTestCase
extends TestCase {
    protected void runTest(String goldenFile, String rewrittenFile, String ... originalSourceFiles) throws Exception {
        MessageContext mc = new MessageContext();
        Map<InputSource, String> originalSrcs = Maps.newHashMap();
        for (String originalSourceFile : originalSourceFiles) {
            URI resourceUri = TestUtil.getResource(((Object)((Object)this)).getClass(), originalSourceFile);
            if (resourceUri == null) {
                throw new IOException(originalSourceFile);
            }
            InputSource is = new InputSource(resourceUri);
            originalSrcs.put(is, TestUtil.readResource(((Object)((Object)this)).getClass(), originalSourceFile));
        }
        for (InputSource is : originalSrcs.keySet()) {
            mc.addInputSource(is);
        }
        StringBuilder actual = new StringBuilder();
        RenderContext rc = new RenderContext(new Concatenator(actual));
        TokenConsumer r = this.createRenderer(originalSrcs, mc, rc);
        for (String line : TestUtil.readResource(((Object)((Object)this)).getClass(), rewrittenFile).split("\n")) {
            if (line.startsWith("#")) {
                if ("<null>".equals(line = line.substring(1).trim())) {
                    r.mark(null);
                    continue;
                }
                r.mark(this.toFilePosition(line, originalSrcs));
                continue;
            }
            r.consume(line);
        }
        r.noMoreTokens();
        OrigSourceRendererTestCase.assertEquals((String)TestUtil.readResource(((Object)((Object)this)).getClass(), goldenFile).replace("@", "\ufffd"), (String)actual.toString());
    }

    protected abstract TokenConsumer createRenderer(Map<InputSource, ? extends CharSequence> var1, MessageContext var2, RenderContext var3);

    private FilePosition toFilePosition(String testInputLine, Map<InputSource, String> originalSrcs) {
        Matcher m = Pattern.compile("(.*):(\\d+)\\+(\\d+)-(?:(\\d+)\\+)?(\\d+)$").matcher(testInputLine);
        if (!m.matches()) {
            throw new SomethingWidgyHappenedError("Format of file position has changed");
        }
        String basename = m.group(1);
        int sln = Integer.parseInt(m.group(2));
        int slc = Integer.parseInt(m.group(3));
        String g4 = m.group(4);
        int eln = g4 != null ? Integer.parseInt(g4) : sln;
        int elc = Integer.parseInt(m.group(5));
        InputSource src = null;
        for (InputSource candidate : originalSrcs.keySet()) {
            if (!candidate.getUri().getPath().endsWith(basename)) continue;
            src = candidate;
        }
        if (src == null) {
            throw new SomethingWidgyHappenedError("No sources specified");
        }
        return FilePosition.fromLinePositions(src, sln, slc, eln, elc);
    }
}

