/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.BaseObjectModel;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.method.DefaultMethodInvoker;
import org.exoplatform.services.rest.impl.method.MethodInvokerFactory;
import org.exoplatform.services.rest.impl.method.MethodParameterImpl;
import org.exoplatform.services.rest.impl.method.OptionsRequestMethodInvoker;
import org.exoplatform.services.rest.impl.method.ParameterHelper;
import org.exoplatform.services.rest.impl.resource.OptionsRequestResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.impl.resource.ResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.SubResourceLocatorDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.SubResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorMap;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceDescriptorImpl
extends BaseObjectModel
implements AbstractResourceDescriptor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.AbstractResourceDescriptorImpl");
    private final PathValue path;
    private final UriPattern uriPattern;
    private final SubResourceMethodMap subResourceMethods;
    private final SubResourceLocatorMap subResourceLocators;
    private final ResourceMethodMap<ResourceMethodDescriptor> resourceMethods;
    private final MethodInvokerFactory invokerFactory;

    public AbstractResourceDescriptorImpl(Class<?> resourceClass, ComponentLifecycleScope scope) {
        this(resourceClass.getAnnotation(Path.class), resourceClass, scope, null);
    }

    public AbstractResourceDescriptorImpl(Class<?> resourceClass, MethodInvokerFactory invokerFactory) {
        this(resourceClass.getAnnotation(Path.class), resourceClass, ComponentLifecycleScope.PER_REQUEST, invokerFactory);
    }

    public AbstractResourceDescriptorImpl(Object resource, MethodInvokerFactory invokerFactory) {
        this(resource.getClass().getAnnotation(Path.class), resource.getClass(), ComponentLifecycleScope.SINGLETON, invokerFactory);
    }

    public AbstractResourceDescriptorImpl(Class<?> resourceClass) {
        this(resourceClass.getAnnotation(Path.class), resourceClass, ComponentLifecycleScope.PER_REQUEST, null);
    }

    public AbstractResourceDescriptorImpl(Object resource) {
        this(resource.getClass().getAnnotation(Path.class), resource.getClass(), ComponentLifecycleScope.SINGLETON, null);
    }

    private AbstractResourceDescriptorImpl(Path path, Class<?> resourceClass, ComponentLifecycleScope scope, MethodInvokerFactory invokerFactory) {
        super(resourceClass, scope);
        if (path != null) {
            this.path = new PathValue(path.value());
            this.uriPattern = new UriPattern(path.value());
        } else {
            this.path = null;
            this.uriPattern = null;
        }
        this.invokerFactory = invokerFactory;
        this.resourceMethods = new ResourceMethodMap();
        this.subResourceMethods = new SubResourceMethodMap();
        this.subResourceLocators = new SubResourceLocatorMap();
        this.processMethods();
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitAbstractResourceDescriptor(this);
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public ResourceMethodMap<ResourceMethodDescriptor> getResourceMethods() {
        return this.resourceMethods;
    }

    @Override
    public SubResourceLocatorMap getSubResourceLocators() {
        return this.subResourceLocators;
    }

    @Override
    public SubResourceMethodMap getSubResourceMethods() {
        return this.subResourceMethods;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    @Override
    public boolean isRootResource() {
        return this.path != null;
    }

    protected void processMethods() {
        Method[] methods;
        final Class<?> resourceClass = this.getObjectClass();
        for (Method method : methods = (Method[])SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return resourceClass.getDeclaredMethods();
            }
        })) {
            for (Annotation a : method.getAnnotations()) {
                Class<? extends Annotation> ac = a.annotationType();
                if (Modifier.isPublic(method.getModifiers()) || ac != CookieParam.class && ac != Consumes.class && ac != Context.class && ac != DefaultValue.class && ac != Encoded.class && ac != FormParam.class && ac != HeaderParam.class && ac != MatrixParam.class && ac != Path.class && ac != PathParam.class && ac != Produces.class && ac != QueryParam.class && ac.getAnnotation(HttpMethod.class) == null) continue;
                LOG.warn((Object)("Non-public method at resource " + this.toString() + " annotated with JAX-RS annotation: " + a));
            }
        }
        for (Method method : resourceClass.getMethods()) {
            Path subPath = this.getMethodAnnotation(method, resourceClass, Path.class, false);
            HttpMethod httpMethod = this.getMethodAnnotation(method, resourceClass, HttpMethod.class, true);
            if (subPath == null && httpMethod == null) continue;
            List<MethodParameter> params = this.createMethodParametersList(resourceClass, method);
            if (httpMethod != null) {
                ResourceMethodDescriptor exist;
                Produces p = this.getMethodAnnotation(method, resourceClass, Produces.class, false);
                if (p == null) {
                    p = resourceClass.getAnnotation(Produces.class);
                }
                List<MediaType> produces = MediaTypeHelper.createProducesList(p);
                Consumes c = this.getMethodAnnotation(method, resourceClass, Consumes.class, false);
                if (c == null) {
                    c = resourceClass.getAnnotation(Consumes.class);
                }
                List<MediaType> consumes = MediaTypeHelper.createConsumesList(c);
                if (subPath == null) {
                    ResourceMethodDescriptorImpl res = new ResourceMethodDescriptorImpl(method, httpMethod.value(), params, this, consumes, produces, this.getMethodInvoker());
                    exist = this.findMethodResourceMediaType(this.resourceMethods.getList(httpMethod.value()), res.consumes(), res.produces());
                    if (exist == null) {
                        this.resourceMethods.add(httpMethod.value(), res);
                        continue;
                    }
                    String msg = "Two resource method " + res + " and " + exist + " with the same HTTP method, consumes and produces found.";
                    throw new RuntimeException(msg);
                }
                SubResourceMethodDescriptorImpl subRes = new SubResourceMethodDescriptorImpl(new PathValue(subPath.value()), method, httpMethod.value(), params, this, consumes, produces, this.getMethodInvoker());
                exist = null;
                ResourceMethodMap<SubResourceMethodDescriptor> rmm = this.subResourceMethods.getMethodMap(subRes.getUriPattern());
                List<SubResourceMethodDescriptor> l = rmm.getList(httpMethod.value());
                exist = (SubResourceMethodDescriptor)this.findMethodResourceMediaType(l, subRes.consumes(), subRes.produces());
                if (exist == null) {
                    rmm.add(httpMethod.value(), subRes);
                    continue;
                }
                String msg = "Two sub-resource method " + subRes + " and " + exist + " with the same HTTP method, path, consumes and produces found.";
                throw new RuntimeException(msg);
            }
            if (subPath == null) continue;
            SubResourceLocatorDescriptorImpl loc = new SubResourceLocatorDescriptorImpl(new PathValue(subPath.value()), method, params, this, this.getMethodInvoker());
            if (!this.subResourceLocators.containsKey(loc.getUriPattern())) {
                this.subResourceLocators.put(loc.getUriPattern(), loc);
                continue;
            }
            String msg = "Two sub-resource locators " + loc + " and " + this.subResourceLocators.get(loc.getUriPattern()) + " with the same path found.";
            throw new RuntimeException(msg);
        }
        this.resolveHeadRequest();
        this.resolveOptionsRequest();
        this.resourceMethods.sort();
        this.subResourceMethods.sort();
    }

    protected List<MethodParameter> createMethodParametersList(Class<?> resourceClass, Method method) {
        Class<?>[] parameterClasses = method.getParameterTypes();
        if (parameterClasses.length == 0) {
            return Collections.emptyList();
        }
        Type[] parameterGenTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        ArrayList<MethodParameter> params = new ArrayList<MethodParameter>(parameterClasses.length);
        for (int i = 0; i < parameterClasses.length; ++i) {
            String defaultValue = null;
            Annotation annotation = null;
            boolean encoded = false;
            List<String> allowedAnnotation = ParameterHelper.RESOURCE_METHOD_PARAMETER_ANNOTATIONS;
            for (Annotation a : annotations[i]) {
                Class<? extends Annotation> ac = a.annotationType();
                if (allowedAnnotation.contains(ac.getName())) {
                    if (annotation == null) {
                        annotation = a;
                        continue;
                    }
                    String msg = "JAX-RS annotations on one of method parameters of resource " + this.toString() + ", method " + method.getName() + " are equivocality. " + "Annotations: " + annotation + " and " + a + " can't be applied to one parameter.";
                    throw new RuntimeException(msg);
                }
                if (ac == Encoded.class) {
                    encoded = true;
                    continue;
                }
                if (ac == DefaultValue.class) {
                    defaultValue = ((DefaultValue)a).value();
                    continue;
                }
                LOG.warn((Object)("Method parameter of resource " + this.toString() + ", method " + method.getName() + " contains unknown or not valid JAX-RS annotation " + ((Object)a).toString() + ". It will be ignored."));
            }
            encoded = encoded || resourceClass.getAnnotation(Encoded.class) != null;
            MethodParameterImpl mp = new MethodParameterImpl(annotation, annotations[i], parameterClasses[i], parameterGenTypes[i], defaultValue, encoded);
            params.add(mp);
        }
        return params;
    }

    protected void resolveHeadRequest() {
        List getRes = (List)this.resourceMethods.get("GET");
        if (getRes == null || getRes.size() == 0) {
            return;
        }
        List<ResourceMethodDescriptor> headRes = this.resourceMethods.getList("HEAD");
        for (ResourceMethodDescriptor rmd : getRes) {
            if (this.findMethodResourceMediaType(headRes, rmd.consumes(), rmd.produces()) != null) continue;
            headRes.add(new ResourceMethodDescriptorImpl(rmd.getMethod(), "HEAD", rmd.getMethodParameters(), this, rmd.consumes(), rmd.produces(), rmd.getMethodInvoker()));
        }
        for (ResourceMethodMap rmm : this.subResourceMethods.values()) {
            List getSubres = (List)rmm.get("GET");
            if (getSubres == null || getSubres.size() == 0) continue;
            List headSubres = rmm.getList("HEAD");
            for (SubResourceMethodDescriptor srmd : getSubres) {
                if (this.findMethodResourceMediaType(headSubres, srmd.consumes(), srmd.produces()) != null) continue;
                headSubres.add(new SubResourceMethodDescriptorImpl(srmd.getPathValue(), srmd.getMethod(), "HEAD", srmd.getMethodParameters(), this, srmd.consumes(), srmd.produces(), this.getMethodInvoker()));
            }
        }
    }

    protected void resolveOptionsRequest() {
        List<ResourceMethodDescriptor> o = this.resourceMethods.getList("OPTIONS");
        if (o.size() == 0) {
            List<MethodParameter> mps = Collections.emptyList();
            List<MediaType> consumes = MediaTypeHelper.DEFAULT_TYPE_LIST;
            ArrayList<MediaType> produces = new ArrayList<MediaType>(1);
            produces.add(MediaTypeHelper.WADL_TYPE);
            o.add(new OptionsRequestResourceMethodDescriptorImpl(null, "OPTIONS", mps, this, consumes, produces, new OptionsRequestMethodInvoker()));
        }
    }

    protected <T extends Annotation> T getMetaAnnotation(Method m, Class<T> annotation) {
        for (Annotation a : m.getAnnotations()) {
            T endPoint = null;
            T t = a.annotationType().getAnnotation(annotation);
            endPoint = t;
            if (t == null) continue;
            return endPoint;
        }
        return null;
    }

    protected <T extends Annotation> T getMethodAnnotation(Method method, Class<?> resourceClass, Class<T> annotationClass, boolean metaAnnotation) {
        T annotation = null;
        annotation = metaAnnotation ? (T)this.getMetaAnnotation(method, annotationClass) : (T)method.getAnnotation(annotationClass);
        if (annotation == null) {
            Method inhMethod;
            block10: {
                inhMethod = null;
                Class<?> superclass = resourceClass.getSuperclass();
                if (superclass != null) {
                    try {
                        inhMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException e) {
                        if (!LOG.isTraceEnabled()) break block10;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
            if (inhMethod == null) {
                for (Class<?> intf : resourceClass.getInterfaces()) {
                    try {
                        Method tmp = intf.getMethod(method.getName(), method.getParameterTypes());
                        if (inhMethod != null) {
                            String msg = "JAX-RS annotation on method " + inhMethod.getName() + " of resource " + this.toString() + " is equivocality.";
                            throw new RuntimeException(msg);
                        }
                        inhMethod = tmp;
                    }
                    catch (NoSuchMethodException exc) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)("An exception occurred: " + exc.getMessage()));
                    }
                }
            }
            if (inhMethod != null) {
                annotation = metaAnnotation ? (T)this.getMetaAnnotation(inhMethod, annotationClass) : (T)inhMethod.getAnnotation(annotationClass);
            }
        }
        return annotation;
    }

    protected <T extends ResourceMethodDescriptor> ResourceMethodDescriptor findMethodResourceMediaType(List<T> rmds, List<MediaType> consumes, List<MediaType> produces) {
        ResourceMethodDescriptor matched;
        block6: {
            boolean eq;
            matched = null;
            Iterator<T> i$ = rmds.iterator();
            if (!i$.hasNext()) break block6;
            ResourceMethodDescriptor rmd = (ResourceMethodDescriptor)i$.next();
            if (rmd.consumes().size() != consumes.size()) {
                return null;
            }
            if (rmd.produces().size() != produces.size()) {
                return null;
            }
            for (MediaType c1 : rmd.consumes()) {
                eq = false;
                for (MediaType c2 : consumes) {
                    if (!c1.equals((Object)c2)) continue;
                    eq = true;
                    break;
                }
                if (eq) continue;
                return null;
            }
            for (MediaType p1 : rmd.produces()) {
                eq = false;
                for (MediaType p2 : produces) {
                    if (!p1.equals((Object)p2)) continue;
                    eq = true;
                    break;
                }
                if (eq) continue;
                return null;
            }
            matched = rmd;
        }
        return matched;
    }

    protected MethodInvoker getMethodInvoker() {
        if (this.invokerFactory != null) {
            return this.invokerFactory.getMethodInvoker();
        }
        return new DefaultMethodInvoker();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ AbstractResourceDescriptorImpl: ");
        sb.append("path: " + this.getPathValue()).append("; isRootResource: " + this.isRootResource()).append("; class: " + this.getObjectClass()).append(" ]");
        return sb.toString();
    }
}

