/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.feedmash.consumer;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.extras.feedmash.AbstractFeedmashJob;
import org.exoplatform.social.extras.feedmash.Application;
import org.quartz.JobDataMap;

public class JiraFeedConsumer
extends AbstractFeedmashJob {
    private static final Log LOG = ExoLogger.getLogger(JiraFeedConsumer.class);
    private String jiraLogo = "http://www.getzephyr.com/images/LOGO_JIRA.png";
    private String baseUrl;
    private String project;

    protected boolean accept(SyndEntryImpl entry) {
        return !this.alreadyChecked(entry.getUpdatedDate());
    }

    protected void handle(SyndEntryImpl entry) {
        try {
            LOG.debug((Object)("republishing jira activity on : " + this.targetActivityStream + " stream, entry uri: " + entry.getLink()));
            Identity jira = this.getJiraIdentity();
            Identity space = this.getIdentity(this.targetActivityStream);
            if (space == null) {
                this.saveState(this.feedLastCheck, null);
                return;
            }
            this.saveState(this.feedLastCheck, entry.getPublishedDate());
            String message = entry.getTitle();
            this.publishActivity(message, jira, space);
        }
        catch (Exception e) {
            LOG.error((Object)("failed to republish jira activity: " + e.getMessage()), (Throwable)e);
        }
    }

    public void beforeJobExecute(JobDataMap dataMap) {
        this.baseUrl = this.getStringParam(dataMap, "baseURL", null);
        this.project = this.getStringParam(dataMap, "project", null);
        if (this.feedUrl == null) {
            this.feedUrl = this.baseUrl + "/plugins/servlet/streams?key=" + this.project;
        }
        this.feedLastCheck = "lastChecked." + this.feedUrl + "." + this.targetActivityStream;
    }

    private Identity getJiraIdentity() throws Exception {
        Application jiraApp = this.jiraApp();
        return this.getAppIdentity(jiraApp);
    }

    private Application jiraApp() {
        Application application = new Application();
        application.setId("jira-" + this.project);
        application.setName("JIRA (" + this.project + ")");
        String url = this.baseUrl + "/browse/" + this.project;
        application.setUrl(url);
        application.setIcon(this.jiraLogo);
        return application;
    }
}

