/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.actions;

import java.util.Hashtable;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.actions.GoToRAction;
import org.icepdf.core.pobjects.actions.LaunchAction;
import org.icepdf.core.pobjects.actions.URIAction;
import org.icepdf.core.util.Library;

public class Action
extends Dictionary {
    public static final Name ACTION_TYPE = new Name("Action");
    public static final Name ACTION_TYPE_KEY = new Name("S");
    public static final Name NEXT_KEY = new Name("Next");
    public static final Name ACTION_TYPE_GOTO = new Name("GoTo");
    public static final Name ACTION_TYPE_GOTO_REMOTE = new Name("GoToR");
    public static final Name ACTION_TYPE_LAUNCH = new Name("Launch");
    public static final Name ACTION_TYPE_URI = new Name("URI");
    private String type = this.getObject(ACTION_TYPE_KEY).toString();

    public Action(Library l, Hashtable h) {
        super(l, h);
    }

    public static Action buildAction(Library library, Hashtable hashTable) {
        Name actionType = (Name)hashTable.get(ACTION_TYPE_KEY);
        if (actionType != null) {
            if (actionType.equals(ACTION_TYPE_GOTO)) {
                return new GoToAction(library, hashTable);
            }
            if (actionType.equals(ACTION_TYPE_GOTO_REMOTE)) {
                return new GoToRAction(library, hashTable);
            }
            if (actionType.equals(ACTION_TYPE_LAUNCH)) {
                return new LaunchAction(library, hashTable);
            }
            if (actionType.equals(ACTION_TYPE_URI)) {
                return new URIAction(library, hashTable);
            }
        }
        return new Action(library, hashTable);
    }

    public String getType() {
        return this.type;
    }

    public boolean similar(Action obj) {
        if (this.getPObjectReference() != null && obj.getPObjectReference() != null) {
            return this.getPObjectReference().equals(obj.getPObjectReference());
        }
        return this.getType().equals(obj.getType());
    }
}

