/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.source;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.Source;

public class Selector
extends Source {
    private static final long serialVersionUID = 1474532281798814862L;
    private final SelectorName alias;
    private final SelectorName name;
    private final int hcode;

    public Selector(SelectorName name) {
        this(name, null);
    }

    public Selector(SelectorName name, SelectorName alias) {
        Validate.notNull((Object)name, (String)"The name argument may not be null");
        this.name = name;
        this.alias = alias;
        this.hcode = new HashCodeBuilder().append((Object)name).append((Object)alias).toHashCode();
    }

    @Override
    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public SelectorName getAlias() {
        return this.alias;
    }

    public SelectorName getAliasOrName() {
        return this.alias != null ? this.alias : this.name;
    }

    public SelectorName getName() {
        return this.name;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Selector rhs = (Selector)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append((Object)this.alias, (Object)rhs.alias).isEquals();
    }

    public int hashCode() {
        return this.hcode;
    }

    public String toString() {
        return Visitors.readable(this);
    }
}

