/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.ContentUIActivity;

public class ContentUIActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log log = ExoLogger.getLogger(ContentUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        ContentUIActivity contentActivity = (ContentUIActivity)uiActivity;
        if (activity.getTemplateParams() != null) {
            contentActivity.setUIActivityData(activity.getTemplateParams());
        }
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageRepo = null;
        Node contentNode = null;
        try {
            manageRepo = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            for (String ws : manageRepo.getWorkspaceNames()) {
                try {
                    contentNode = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(contentActivity.getNodeUUID());
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        catch (RepositoryException re) {
            log.error((Object)"Can not get the repository. ", (Throwable)re);
        }
        contentActivity.setContentNode(contentNode);
    }
}

