/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.SerializablePageList;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.account.UIUserSelector;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/organization/account/UIUserSelector.gtmpl", events={@EventConfig(listeners={UIUserSelector.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.SearchGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.FindGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIUserSelect
extends UIUserSelector {
    private String permisionType;
    private String spaceGroupId = null;

    public void processRender(WebuiRequestContext context) throws Exception {
        String keyword = (String)this.getUIStringInput("QuickSearch").getValue();
        if (CommonUtils.isEmpty(keyword) && !CommonUtils.isEmpty(this.spaceGroupId) && this.uiIterator_ != null) {
            OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            ListAccess listAccess = service.getUserHandler().findUsersByGroupId(this.spaceGroupId);
            List<Object> results = Arrays.asList(listAccess.load(0, listAccess.getSize()));
            this.uiIterator_.setPageList((PageList)new SerializablePageList((ListAccess)new ListAccessImpl(User.class, results), 10));
        }
        super.processRender(context);
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public void setSpaceGroupId(String spaceGroupId) {
        this.spaceGroupId = spaceGroupId;
    }

    public String getPermisionType() {
        return this.permisionType;
    }

    public void setPermisionType(String permisionType) {
        this.permisionType = permisionType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiForm = (UIUserSelect)((Object)event.getSource());
            String keyword = (String)uiForm.getUIStringInput("QuickSearch").getValue();
            String filter = (String)uiForm.getUIFormSelectBox("filter").getValue();
            String groupId = uiForm.getSpaceGroupId();
            uiForm.search(keyword, filter, groupId);
            if (filter == null || filter.trim().length() == 0) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

