/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.analyzer;

import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class UnescapeHTMLFilter
extends TokenFilter {
    public UnescapeHTMLFilter(TokenStream input) {
        super(input);
    }

    public final Token next() throws IOException {
        Token nextToken = this.input.next();
        if (nextToken != null) {
            String tokenText = nextToken.termText();
            String brTokenText = tokenText.replaceAll("<br", "");
            tokenText = StringEscapeUtils.unescapeHtml((String)brTokenText);
            if ((tokenText = tokenText.replaceAll("\\<.*?>", "")).equals("") || tokenText.trim().equals("")) {
                return new Token("", 0, 0, nextToken.type());
            }
            return new Token(tokenText.trim(), nextToken.startOffset(), nextToken.startOffset() + tokenText.length(), nextToken.type());
        }
        return null;
    }
}

