/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.social.webui.UIAvatarUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.social.webui.space.UISpaceMember;
import org.exoplatform.social.webui.space.UISpacePermission;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceInfo.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.PROCESS), @EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UISpaceInfo
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UISpaceInfo.class);
    private static final String SPACE_ID = "id";
    private static final String SPACE_DISPLAY_NAME = "displayName";
    private static final String SPACE_DESCRIPTION = "description";
    private SpaceService spaceService = null;
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";
    private static final String HTML_ATTRIBUTE_TITLE = "title";

    public UISpaceInfo() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        UIFormStringInput spaceId = new UIFormStringInput(SPACE_ID, SPACE_ID, null);
        spaceId.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceInfo.label.SpaceId"));
        this.addUIFormInput((UIFormInput)((UIFormStringInput)spaceId.setRendered(false)));
        UIFormStringInput spaceDisplayNameInput = new UIFormStringInput(SPACE_DISPLAY_NAME, SPACE_DISPLAY_NAME, null);
        this.addUIFormInput((UIFormInput)spaceDisplayNameInput.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\d]+[\\s]?)+$", "UISpaceInfo.msg.name-invalid"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(SPACE_DESCRIPTION, SPACE_DESCRIPTION, null).addValidator(StringLengthValidator.class, new Object[]{0, 255}));
        UIFormStringInput tag = new UIFormStringInput("tag", "tag", null);
        tag.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceInfo.label.tag"));
        this.addUIFormInput((UIFormInput)((UIFormStringInput)tag.setRendered(false)));
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    protected void setCurrentSpace(Space space) throws Exception {
        UITabPane uiTabPane = (UITabPane)this.getAncestorOfType(UITabPane.class);
        uiTabPane.setSelectedTab(1);
        UISpaceInfo uiSpaceInfo = (UISpaceInfo)uiTabPane.getChild(UISpaceInfo.class);
        uiSpaceInfo.setValue(space);
        UISpaceMember uiSpaceMember = (UISpaceMember)uiTabPane.getChild(UISpaceMember.class);
        uiSpaceMember.setValue(space.getId());
        uiSpaceMember.setSpaceURL(space.getUrl());
        UISpaceApplication uiSpaceApplication = (UISpaceApplication)uiTabPane.getChild(UISpaceApplication.class);
        uiSpaceApplication.setValue(space);
        UISpacePermission uiSpacePermission = (UISpacePermission)uiTabPane.getChild(UISpacePermission.class);
        uiSpacePermission.setValue(space);
    }

    public void setValue(Space space) throws Exception {
        this.invokeGetBindingBean(space);
        UIFormTextAreaInput descriptionInput = this.getUIFormTextAreaInput(SPACE_DESCRIPTION);
        descriptionInput.setValue((Object)StringEscapeUtils.unescapeHtml((String)((String)descriptionInput.getValue()).trim()));
        this.getUIStringInput("tag").setValue((Object)space.getTag());
    }

    public void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent, Space space) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        space.setAvatarAttachment(uiAvatarUploadContent.getAvatarAttachment());
        spaceService.updateSpace(space);
        spaceService.updateSpaceAvatar(space);
    }

    protected String getImageSource() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String id = (String)this.getUIStringInput(SPACE_ID).getValue();
        Space space = spaceService.getSpaceById(id);
        return space.getAvatarUrl();
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public OrganizationService getOrganizationService() {
        return (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    }

    public DataStorage getDataSource() {
        return (DataStorage)this.getApplicationComponent(DataStorage.class);
    }

    private UserNode renamePageNode(String newNodeLabel, Space space) {
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
        try {
            UserNode parentNode = SpaceUtils.getParentNode().getParent().getParent();
            if (parentNode == null) {
                parentNode = SpaceUtils.getParentNode().getParent();
            }
            if (parentNode == null || parentNode.getChild(SpaceUtils.cleanString((String)space.getPrettyName())) == null) {
                return null;
            }
            UserNode renamedNode = parentNode.getChild(SpaceUtils.cleanString((String)space.getPrettyName()));
            renamedNode.setLabel(newNodeLabel);
            String newNodeName = SpaceUtils.cleanString((String)newNodeLabel);
            if (parentNode.getChild(newNodeName) != null) {
                newNodeName = newNodeName + "_" + System.currentTimeMillis();
            }
            renamedNode.setName(newNodeName);
            Page page = configService.getPage(renamedNode.getPageRef());
            if (page != null) {
                page.setTitle(newNodeLabel);
                dataService.save(page);
            }
            SpaceUtils.getUserPortal().saveNode(parentNode, null);
            SpaceUtils.changeSpaceUrlPreference((UserNode)renamedNode, (Space)space, (String)newNodeLabel);
            for (UserNode childNode : renamedNode.getChildren()) {
                SpaceUtils.changeSpaceUrlPreference((UserNode)childNode, (Space)space, (String)newNodeLabel);
            }
            return renamedNode;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeAvatarActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceInfo.getChild(UIPopupWindow.class);
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)uiSpaceInfo.createUIComponent(UIAvatarUploader.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiAvatarUploader);
            uiPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            boolean nameChanged;
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            SpaceService spaceService = uiSpaceInfo.getSpaceService();
            UIPortal uiPortal = Util.getUIPortal();
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String id = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_ID).getValue();
            String name = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).getValue();
            Space space = spaceService.getSpaceById(id);
            String oldDisplayName = space.getDisplayName();
            if (space == null) {
                portalRequestContext.getResponse().sendRedirect(Utils.getURI("all-spaces"));
                return;
            }
            UserNode selectedNode = uiPortal.getSelectedUserNode();
            UserNode renamedNode = null;
            boolean bl = nameChanged = !space.getDisplayName().equals(name);
            if (nameChanged) {
                String cleanedString = SpaceUtils.cleanString((String)name);
                space.setUrl(cleanedString);
                if (spaceService.getSpaceByUrl(cleanedString) != null) {
                    uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.current-name-exist", null, 2));
                    return;
                }
                renamedNode = uiSpaceInfo.renamePageNode(name, space);
                if (renamedNode == null) {
                    return;
                }
            }
            uiSpaceInfo.invokeSetBindingBean(space);
            String description = space.getDescription();
            space.setDescription(StringUtils.isEmpty((String)description) ? " " : StringEscapeUtils.escapeHtml((String)description));
            if (nameChanged) {
                space.setDisplayName(oldDisplayName);
                spaceService.renameSpace(space, name);
            } else {
                spaceService.updateSpace(space);
            }
            if (nameChanged) {
                if (renamedNode != null) {
                    selectedNode = renamedNode;
                    PortalRequestContext prContext = Util.getPortalRequestContext();
                    ((NodeURL)prContext.createURL(NodeURL.TYPE)).setNode(selectedNode);
                    portalRequestContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.update-success", null, 2));
            }
        }
    }
}

