/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

public class FilterChainImpl<T extends PortletFilter>
implements FilterChain {
    private List<T> filters;
    private Class<T> phase;
    private int index;

    public FilterChainImpl(List<T> filters, Class<T> phase) {
        this.filters = filters;
        this.phase = phase;
        this.index = 0;
    }

    public void doFilter(PortletRequest req, PortletResponse resp) throws IOException, PortletException {
        if (req instanceof ActionRequest && resp instanceof ActionResponse) {
            this.doFilter((ActionRequest)req, (ActionResponse)resp);
        } else if (req instanceof EventRequest && resp instanceof EventResponse) {
            this.doFilter((EventRequest)req, (EventResponse)resp);
        } else if (req instanceof RenderRequest && resp instanceof RenderResponse) {
            this.doFilter((RenderRequest)req, (RenderResponse)resp);
        } else if (req instanceof ResourceRequest && resp instanceof ResourceResponse) {
            this.doFilter((ResourceRequest)req, (ResourceResponse)resp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ActionRequest req, ActionResponse resp) throws IOException, PortletException {
        if (!ActionFilter.class.isAssignableFrom(this.phase)) {
            throw new IllegalStateException();
        }
        if (this.index >= this.filters.size()) {
            throw new IllegalStateException();
        }
        int currentIndex = this.index++;
        try {
            PortletFilter filter = (PortletFilter)this.filters.get(currentIndex);
            ActionFilter actionFilter = (ActionFilter)ActionFilter.class.cast(filter);
            actionFilter.doFilter(req, resp, (FilterChain)this);
        }
        finally {
            --this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(EventRequest req, EventResponse resp) throws IOException, PortletException {
        if (!EventFilter.class.isAssignableFrom(this.phase)) {
            throw new IllegalStateException();
        }
        if (this.index >= this.filters.size()) {
            throw new IllegalStateException();
        }
        int currentIndex = this.index++;
        try {
            PortletFilter filter = (PortletFilter)this.filters.get(currentIndex);
            EventFilter eventFilter = (EventFilter)EventFilter.class.cast(filter);
            eventFilter.doFilter(req, resp, (FilterChain)this);
        }
        finally {
            --this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(RenderRequest req, RenderResponse resp) throws IOException, PortletException {
        if (!RenderFilter.class.isAssignableFrom(this.phase)) {
            throw new IllegalStateException();
        }
        if (this.index >= this.filters.size()) {
            throw new IllegalStateException();
        }
        int currentIndex = this.index++;
        try {
            PortletFilter filter = (PortletFilter)this.filters.get(currentIndex);
            RenderFilter renderFilter = (RenderFilter)RenderFilter.class.cast(filter);
            renderFilter.doFilter(req, resp, (FilterChain)this);
        }
        finally {
            --this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ResourceRequest req, ResourceResponse resp) throws IOException, PortletException {
        if (!ResourceFilter.class.isAssignableFrom(this.phase)) {
            throw new IllegalStateException();
        }
        if (this.index >= this.filters.size()) {
            throw new IllegalStateException();
        }
        int currentIndex = this.index++;
        try {
            PortletFilter filter = (PortletFilter)this.filters.get(currentIndex);
            ResourceFilter resourceFilter = (ResourceFilter)ResourceFilter.class.cast(filter);
            resourceFilter.doFilter(req, resp, (FilterChain)this);
        }
        finally {
            --this.index;
        }
    }
}

