/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.xcmis.spi.utils.Logger;

public class CaseInsensitiveRangeQuery
extends RangeQuery {
    private static final long serialVersionUID = 3351256558561558491L;
    private static final Logger log = Logger.getLogger(CaseInsensitiveRangeQuery.class);

    public CaseInsensitiveRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        super(CaseInsensitiveRangeQuery.modifyLowerTerm(lowerTerm), CaseInsensitiveRangeQuery.modifyUpperTerm(upperTerm), inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery(true);
        TermEnum enumerator = reader.terms(this.getLowerTerm());
        try {
            Term term;
            String testField = this.getField();
            String lowerTerm = this.getLowerTerm().text().toLowerCase();
            while ((term = enumerator.term()) != null && term.field() == testField) {
                block11: {
                    block12: {
                        String termText = term.text().toLowerCase();
                        int lowerCompareResult = termText.compareTo(lowerTerm);
                        if (lowerCompareResult <= 0 && (!this.isInclusive() || lowerCompareResult != 0)) break block11;
                        if (this.getUpperTerm() == null) break block12;
                        if (this.getUpperTerm().text().compareTo(term.text()) < 0) {
                            break;
                        }
                        int upperCompareResult = this.getUpperTerm().text().compareTo(termText);
                        if (upperCompareResult < 0 || !this.isInclusive() && upperCompareResult == 0) break block11;
                    }
                    TermQuery tq = new TermQuery(term);
                    tq.setBoost(this.getBoost());
                    query.add((Query)tq, BooleanClause.Occur.SHOULD);
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
        if (log.isDebugEnabled()) {
            log.debug(query.toString());
        }
        return query;
    }

    private static Term modifyLowerTerm(Term lowerTerm) {
        if (lowerTerm != null) {
            return new Term(lowerTerm.field(), lowerTerm.text().toUpperCase());
        }
        return lowerTerm;
    }

    private static Term modifyUpperTerm(Term upperTerm) {
        if (upperTerm != null) {
            return new Term(upperTerm.field(), upperTerm.text().toLowerCase());
        }
        return upperTerm;
    }
}

