/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.logging;

import com.arjuna.common.internal.util.logging.commonPropertyManager;

public class Environment {
    public static final String LOGGER_FACTORY_PROPERTY = "com.hp.mwlabs.common.utils.logging.factory";
    public static final String LOGGER_FACTORY_DEFAULT = "com.hp.mwlabs.common.util.logging.log4j.ArjLoggerFactory";
    public static final String LOGGER_FACTORY_CSF = "com.hp.mwlabs.common.util.logging.csf.ArjChannelFactory";
    public static final String LOGGER_FACTORY_LOG4J = "com.hp.mwlabs.common.util.logging.log4j.ArjLoggerFactory";
    public static final String LOGGER_FACTORY_SIMPLE = "com.hp.mwlabs.common.util.logging.simpleLog.ArjSimpleLoggerFactory";
    public static final String LOGGING_PROPERTIES_NAMESPACE = "com.arjuna.logging";
    public static final String LOGGING_LANGUAGE_PROPERTY = "com.arjuna.logging.language";
    public static final String LOGGING_LANGUAGE_DEFAULT = "en";
    public static final String LOGGING_COUNTRY_PROPERTY = "com.arjuna.logging.country";
    public static final String LOGGING_COUNTRY_DEFAULT = "US";
    public static final String LOGGER_OUTPUT_PROPERTY = "com.arjuna.logging.output";
    public static final String LOGGER_OUTPUT_DEFAULT = "console";
    public static final String LOG_DIRECTORY_PROPERTY = "com.arjuna.logging.log.dir";
    public static final String LOG_DIRECTORY_DEFAULT = ".";
    public static final String LOG_FILE_PROPERTY = "com.arjuna.logging.log.file";
    public static final String LOG_FILE_DEFAULT = "loggingFile";
    public static final String LOG_DISABLED_PROPERTY = "com.arjuna.logging.log.disabled";
    public static final String LOG_DISABLED_DEFAULT = "NO";
    public static final String FINER_DEBUG_SUFFIX = ".FinerDebug";
    public static final String FINER_DEBUG_DEFAULT = "NO";
    public static final String DEBUG_CLASS_SUFFIX = ".dClass";
    public static final String DEBUG_CLASS_DEFAULT = "com.hp.mw.common.util.logging.DebugLevel";
    public static final String FACILITY_CLASS_SUFFIX = ".fClass";
    public static final String FACILITY_CLASS_DEFAULT = "com.hp.mw.common.util.logging.FacilityCode";
    public static final String VISIBILITY_CLASS_SUFFIX = ".vClass";
    public static final String VISIBILITY_CLASS_DEFAULT = "com.hp.mw.common.util.logging.VisibilityLevel";
    public static final String DEBUG_VALUE_SUFFIX = ".debugValue";
    public static final String FACILITY_VALUE_SUFFIX = ".facilValue";
    public static final String VISIBILITY_VALUE_SUFFIX = ".visibValue";
    public static final String LOGGER_LEVEL_PROPERTY = "com.arjuna.logging.log.level";
    public static final String LOGGER_LEVEL_DEFAULT = "DEBUG";
    public static final String YES_VALUE = "YES";

    public static final String getLogLevel() {
        return commonPropertyManager.propertyManager.getProperty(LOGGER_LEVEL_PROPERTY, LOGGER_LEVEL_DEFAULT);
    }

    public static final String getDebugValue(String key) {
        return commonPropertyManager.propertyManager.getProperty(key + DEBUG_VALUE_SUFFIX);
    }

    public static final String getFacilityValue(String key) {
        return commonPropertyManager.propertyManager.getProperty(key + FACILITY_VALUE_SUFFIX);
    }

    public static final String getVisibilityValue(String key) {
        return commonPropertyManager.propertyManager.getProperty(key + VISIBILITY_VALUE_SUFFIX);
    }

    public static final String getDebugClass(String key) {
        return commonPropertyManager.propertyManager.getProperty(key + DEBUG_CLASS_SUFFIX, DEBUG_CLASS_DEFAULT);
    }

    public static final String getFacilityClass(String key) {
        return commonPropertyManager.propertyManager.getProperty(key + FACILITY_CLASS_SUFFIX, FACILITY_CLASS_DEFAULT);
    }

    public static final String getVisibilityClass(String key) {
        return commonPropertyManager.propertyManager.getProperty(key + VISIBILITY_CLASS_SUFFIX, VISIBILITY_CLASS_DEFAULT);
    }

    public static final boolean isFinerDebug(String key) {
        return Environment.getYesNoProperty(commonPropertyManager.propertyManager.getProperty(key + FINER_DEBUG_SUFFIX, "NO"));
    }

    public static final boolean isLogDisabled() {
        return Environment.getYesNoProperty(commonPropertyManager.propertyManager.getProperty(LOG_DISABLED_PROPERTY, "NO"));
    }

    public static final String getLoggerOutput() {
        return commonPropertyManager.propertyManager.getProperty(LOGGER_OUTPUT_PROPERTY, LOGGER_OUTPUT_DEFAULT);
    }

    public static final String getLoggingDirectory() {
        return commonPropertyManager.propertyManager.getProperty(LOG_DIRECTORY_PROPERTY, LOG_DIRECTORY_DEFAULT);
    }

    public static final String getLoggingFile() {
        return commonPropertyManager.propertyManager.getProperty(LOG_FILE_PROPERTY, LOG_FILE_DEFAULT);
    }

    public static final boolean getYesNoProperty(String property) {
        return property.equalsIgnoreCase(YES_VALUE);
    }

    public static final String getLoggingLanguage() {
        return commonPropertyManager.propertyManager.getProperty(LOGGING_LANGUAGE_PROPERTY, LOGGING_LANGUAGE_DEFAULT);
    }

    public static final String getLoggingCountry() {
        return commonPropertyManager.propertyManager.getProperty(LOGGING_COUNTRY_PROPERTY, LOGGING_COUNTRY_DEFAULT);
    }
}

