/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.rest.ext.management.ResourceKey;
import org.exoplatform.services.rest.ext.management.RestResource;
import org.exoplatform.services.rest.ext.management.ValueWrapper;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="management")
public class RestManagementProvider
implements ResourceContainer,
ManagementProvider {
    private final ExoContainerContext context;
    private final Map<ResourceKey, RestResource> resourceMap = new HashMap<ResourceKey, RestResource>();

    public RestManagementProvider(ExoContainerContext context) {
        this.context = context;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Object list() {
        ArrayList<String> list = new ArrayList<String>();
        for (RestResource mr : this.resourceMap.values()) {
            list.add(mr.getName());
        }
        return ValueWrapper.wrap(list);
    }

    @RolesAllowed(value={"administrators"})
    @Path(value="{resource}")
    public Object dispatch(@PathParam(value="resource") String resourceName) {
        return this.resourceMap.get(new ResourceKey(resourceName));
    }

    public Object manage(ManagedResource managedResource) {
        Object resource = managedResource.getResource();
        RESTEndpoint annotation = resource.getClass().getAnnotation(RESTEndpoint.class);
        if (annotation != null) {
            String name = annotation.path();
            ResourceKey key = new ResourceKey(name);
            this.resourceMap.put(key, new RestResource(name, managedResource));
            return key;
        }
        return null;
    }

    public void unmanage(Object key) {
        this.resourceMap.remove(key);
    }
}

