/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.source.join;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.join.JoinCondition;

public class EquiJoinCondition
extends JoinCondition {
    private static final long serialVersionUID = 5357188353322766280L;
    private final SelectorName selector1Name;
    private final String property1Name;
    private final SelectorName selector2Name;
    private final String property2Name;
    private final int hcode;

    public EquiJoinCondition(Column column1, Column column2) {
        this(column1.getSelectorName(), column1.getPropertyName(), column2.getSelectorName(), column2.getPropertyName());
    }

    public EquiJoinCondition(SelectorName selector1Name, String property1Name, SelectorName selector2Name, String property2Name) {
        Validate.notNull((Object)selector1Name, (String)"The selector1Name argument may not be null");
        Validate.notNull((Object)property1Name, (String)"The property1Name argument may not be null");
        Validate.notNull((Object)selector2Name, (String)"The selector2Name argument may not be null");
        Validate.notNull((Object)property2Name, (String)"The property2Name argument may not be null");
        this.selector1Name = selector1Name;
        this.property1Name = property1Name;
        this.selector2Name = selector2Name;
        this.property2Name = property2Name;
        this.hcode = new HashCodeBuilder().append((Object)selector1Name).append((Object)property1Name).append((Object)selector2Name).append((Object)property2Name).toHashCode();
    }

    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EquiJoinCondition rhs = (EquiJoinCondition)obj;
        return new EqualsBuilder().append((Object)this.selector1Name, (Object)rhs.selector1Name).append((Object)this.property1Name, (Object)rhs.property1Name).append((Object)this.selector2Name, (Object)rhs.selector2Name).append((Object)this.property2Name, (Object)rhs.property2Name).isEquals();
    }

    public final String getProperty1Name() {
        return this.property1Name;
    }

    public final String getProperty2Name() {
        return this.property2Name;
    }

    public final SelectorName getSelector1Name() {
        return this.selector1Name;
    }

    public final SelectorName getSelector2Name() {
        return this.selector2Name;
    }

    public int hashCode() {
        return this.hcode;
    }

    public String toString() {
        return Visitors.readable(this);
    }
}

