/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveChildActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiPage.isModifiable()) {
                uiPage.removeChildById(id);
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                DataStorage dataService = (DataStorage)uiPage.getApplicationComponent(DataStorage.class);
                dataService.save(page);
                pcontext.setFullRender(false);
                pcontext.setResponseComplete(true);
                pcontext.getWriter().write("OK");
            } else {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPage.msg.EditPermission.null", null));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteGadgetActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            WebuiRequestContext pContext = event.getRequestContext();
            String id = pContext.getRequestParameter("objectId");
            UIPage uiPage = (UIPage)((Object)event.getSource());
            ArrayList uiWidgets = new ArrayList();
            uiPage.findComponentOfType(uiWidgets, UIGadget.class);
            for (UIGadget uiWidget : uiWidgets) {
                if (!uiWidget.getId().equals(id)) continue;
                uiPage.getChildren().remove((Object)uiWidget);
                String userName = pContext.getRemoteUser();
                if (userName == null || userName.trim().length() > 0) {
                    // empty if block
                }
                if (!uiPage.isModifiable()) break;
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                DataStorage dataService = (DataStorage)uiPage.getApplicationComponent(DataStorage.class);
                dataService.save(page);
                break;
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.setFullRender(false);
            pcontext.setResponseComplete(true);
            pcontext.getWriter().write("OK");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePageNodeActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            PageNavigation targetedNav;
            String targetedUri;
            UIPortal showedUIPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)showedUIPortal.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            pcontext.setFullRender(true);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            PageNavigation currentNav = showedUIPortal.getSelectedNavigation();
            String currentUri = showedUIPortal.getSelectedNode().getUri();
            if (currentUri.startsWith("/")) {
                currentUri = currentUri.substring(1);
            }
            if (showedUIPortal.getSelectedPath() == null) {
                List<PageNode> currentSelectedPath = this.findPath(currentNav, currentUri.split("/"));
                showedUIPortal.setSelectedPath(currentSelectedPath);
            }
            if ((targetedUri = ((PageNodeEvent)event).getTargetNodeUri()).startsWith("/")) {
                targetedUri = targetedUri.substring(1);
            }
            if ((targetedNav = this.getTargetedNav(uiPortalApp, targetedUri)) == null) {
                return;
            }
            String formerNavType = currentNav.getOwnerType();
            String formerNavId = currentNav.getOwnerId();
            String newNavType = targetedNav.getOwnerType();
            String newNavId = targetedNav.getOwnerId();
            String[] targetPath = targetedUri.split("/");
            PageNode targetPageNode = this.getTargetedNode(targetedNav, targetPath);
            List<PageNode> targetedPathNodes = this.findPath(targetedNav, targetPath);
            if (formerNavType.equals(newNavType) && formerNavId.equals(newNavId)) {
                if (!currentUri.equals(targetedUri)) {
                    showedUIPortal.setSelectedNode(targetPageNode);
                    showedUIPortal.setSelectedPath(targetedPathNodes);
                }
            } else {
                uiWorkingWS.setRenderedChild("UIViewWS");
                uiPortalApp.setModeState(0);
                showedUIPortal = uiPortalApp.getCachedUIPortal(newNavType, newNavId);
                if (showedUIPortal != null) {
                    showedUIPortal.setSelectedNode(targetPageNode);
                    showedUIPortal.setSelectedPath(targetedPathNodes);
                    uiPortalApp.setShowedUIPortal(showedUIPortal);
                    DataStorage storageService = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
                    PortalConfig associatedPortalConfig = storageService.getPortalConfig(newNavType, newNavId);
                    UserPortalConfig userPortalConfig = uiPortalApp.getUserPortalConfig();
                    userPortalConfig.setPortal(associatedPortalConfig);
                    userPortalConfig.updateSelectedNavigation(newNavType, newNavId);
                } else {
                    showedUIPortal = this.buildUIPortal(targetedNav, uiPortalApp, uiPortalApp.getUserPortalConfig());
                    if (showedUIPortal == null) {
                        return;
                    }
                    showedUIPortal.setSelectedNode(targetPageNode);
                    showedUIPortal.setSelectedPath(targetedPathNodes);
                    uiPortalApp.setShowedUIPortal(showedUIPortal);
                    uiPortalApp.putCachedUIPortal(showedUIPortal);
                }
            }
            showedUIPortal.refreshUIPage();
        }

        private PageNavigation getTargetedNav(UIPortalApplication uiPortalApp, String targetedUri) {
            List allNavs = uiPortalApp.getUserPortalConfig().getNavigations();
            if (targetedUri.length() == 0) {
                return uiPortalApp.getNavigations().get(0);
            }
            String[] pathNodes = targetedUri.split("/");
            return this.getBestMatchNavigation(allNavs, pathNodes);
        }

        private PageNavigation getBestMatchNavigation(List<PageNavigation> listNav, String[] pathNodes) {
            int temporalMaximalMatching = 0;
            PageNavigation temporalBestNavigation = listNav.get(0);
            for (PageNavigation nav : listNav) {
                int currentNumberOfMatching = this.countNumberOfMatchedPathNodes(nav, pathNodes);
                if (currentNumberOfMatching == pathNodes.length) {
                    return nav;
                }
                if (currentNumberOfMatching <= temporalMaximalMatching) continue;
                temporalMaximalMatching = currentNumberOfMatching;
                temporalBestNavigation = nav;
            }
            return temporalBestNavigation;
        }

        private int countNumberOfMatchedPathNodes(PageNavigation nav, String[] pathNodes) {
            if (pathNodes.length == 0) {
                return 0;
            }
            PageNode currentNode = nav.getNode(pathNodes[0]);
            int numberOfMatch = currentNode != null ? 1 : 0;
            for (int i = 1; i < pathNodes.length && currentNode != null; currentNode = currentNode.getChild(pathNodes[i]), ++i) {
            }
            return numberOfMatch;
        }

        private PageNode getTargetedNode(PageNavigation targetedNav, String[] pathNodes) {
            if (pathNodes.length == 0) {
                return this.getDefaultNode(targetedNav);
            }
            PageNode currentNode = targetedNav.getNode(pathNodes[0]);
            if (currentNode == null) {
                return this.getDefaultNode(targetedNav);
            }
            PageNode tempNode = null;
            for (int i = 1; i < pathNodes.length && (tempNode = currentNode.getChild(pathNodes[i])) != null; ++i) {
                currentNode = tempNode;
            }
            return currentNode;
        }

        private PageNode getDefaultNode(PageNavigation nav) {
            PageNode defaultNode;
            block5: {
                defaultNode = null;
                try {
                    if (nav != null && nav.getNodes().size() > 0) {
                        PortalRequestContext context = Util.getPortalRequestContext();
                        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
                        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
                        for (PageNode pageNode : nav.getNodes()) {
                            Page page = userPortalConfigService.getPage(pageNode.getPageReference(), context.getRemoteUser());
                            if (page == null) continue;
                            defaultNode = pageNode;
                            break block5;
                        }
                        break block5;
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (defaultNode != null && !"notfound".equals(defaultNode.getName())) {
                return defaultNode;
            }
            return null;
        }

        private List<PageNode> findPath(PageNavigation nav, String[] pathNodes) {
            ArrayList<PageNode> nodes = new ArrayList<PageNode>(4);
            if (pathNodes.length == 0) {
                nodes.add(this.getDefaultNode(nav));
                return nodes;
            }
            PageNode startNode = nav.getNode(pathNodes[0]);
            if (startNode == null) {
                nodes.add(this.getDefaultNode(nav));
                return nodes;
            }
            nodes.add(startNode);
            for (int i = 1; i < pathNodes.length && (startNode = startNode.getChild(pathNodes[i])) != null; ++i) {
                nodes.add(startNode);
            }
            return nodes;
        }

        private UIPortal buildUIPortal(PageNavigation newPageNav, UIPortalApplication uiPortalApp, UserPortalConfig userPortalConfig) throws Exception {
            DataStorage storage = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
            if (storage == null) {
                return null;
            }
            PortalConfig portalConfig = storage.getPortalConfig(newPageNav.getOwnerType(), newPageNav.getOwnerId());
            Container layout = portalConfig.getPortalLayout();
            if (layout != null) {
                userPortalConfig.setPortal(portalConfig);
            }
            UIPortal uiPortal = (UIPortal)uiPortalApp.createUIComponent(UIPortal.class, null, null);
            userPortalConfig.setSelectedNavigation(newPageNav);
            PortalDataMapper.toUIPortal(uiPortal, userPortalConfig);
            return uiPortal;
        }
    }
}

