/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class SplittedFileInputStream
extends InputStream {
    private CountingInputStream in;
    private long currentFileSize;
    private File mainFile;
    private int nextIndex = 0;

    protected SplittedFileInputStream(File file) throws FileNotFoundException {
        this.in = new CountingInputStream(new FileInputStream(file));
        this.currentFileSize = file.length();
        this.mainFile = file;
    }

    private boolean checkNextFile() throws IOException {
        File file = new File(this.mainFile.getAbsolutePath() + "." + this.nextIndex++);
        if (file.exists()) {
            this.in.close();
            this.in = new CountingInputStream(new FileInputStream(file));
            this.currentFileSize = file.length();
            return true;
        }
        return false;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1 && this.checkNextFile()) {
            return this.read();
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isCurrentEOF() && this.checkNextFile()) {
            return this.read(byArray, n, n2);
        }
        return this.in.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        if (this.isCurrentEOF() && this.checkNextFile()) {
            return this.skip(l);
        }
        return this.in.skip(l);
    }

    public int available() throws IOException {
        if (this.isCurrentEOF() && this.checkNextFile()) {
            return this.available();
        }
        return this.in.available();
    }

    private boolean isCurrentEOF() {
        return this.in.getCount() >= this.currentFileSize;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

