/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.discovery;

import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.ide.discovery.EntryPoint;
import org.exoplatform.ide.discovery.EntryPointList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/services/discovery")
public class RepositoryDiscoveryService
implements ResourceContainer {
    private String WEBDAV_CONTEXT = "jcr";
    private static final CacheControl noCache = new CacheControl();
    private RepositoryService repositoryService;

    public RepositoryDiscoveryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/entrypoints/")
    public Response getEntryPoints(@Context UriInfo uriInfo) {
        ArrayList<String> entryPoints = new ArrayList<String>();
        for (RepositoryEntry repositoryEntry : this.repositoryService.getConfig().getRepositoryConfigurations()) {
            String repositoryName = repositoryEntry.getName();
            for (WorkspaceEntry workspaceEntry : repositoryEntry.getWorkspaceEntries()) {
                String workspaceName = workspaceEntry.getName();
                String href = uriInfo.getBaseUri().toASCIIString() + "/" + this.WEBDAV_CONTEXT + "/" + repositoryName + "/" + workspaceName + "/";
                entryPoints.add(href);
            }
        }
        EntryPointList entryPointList = new EntryPointList();
        for (int i = 0; i < entryPoints.size(); ++i) {
            entryPointList.getEntryPoints().add(new EntryPoint("jcr-webdav", (String)entryPoints.get(i)));
        }
        return Response.ok((Object)entryPointList).cacheControl(noCache).build();
    }

    static {
        noCache.setNoCache(true);
        noCache.setNoStore(true);
    }
}

