/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ACLWriter;

public class PersistedNodeDataWriter {
    public void write(ObjectWriter out, PersistedNodeData nodeData) throws IOException {
        out.writeInt(9);
        out.writeString(nodeData.getQPath().getAsString());
        out.writeString(nodeData.getIdentifier());
        if (nodeData.getParentIdentifier() != null) {
            out.writeByte((byte)1);
            out.writeString(nodeData.getParentIdentifier());
        } else {
            out.writeByte((byte)0);
        }
        out.writeInt(nodeData.getPersistedVersion());
        out.writeInt(nodeData.getOrderNumber());
        out.writeString(nodeData.getPrimaryTypeName().getAsString());
        InternalQName[] mixinNames = nodeData.getMixinTypeNames();
        if (mixinNames != null) {
            out.writeByte((byte)1);
            out.writeInt(mixinNames.length);
            for (int i = 0; i < mixinNames.length; ++i) {
                out.writeString(mixinNames[i].getAsString());
            }
        } else {
            out.writeByte((byte)0);
        }
        ACLWriter wr = new ACLWriter();
        AccessControlList acl = nodeData.getACL();
        if (acl != null) {
            out.writeByte((byte)1);
            wr.write(out, acl);
        } else {
            out.writeByte((byte)0);
        }
    }
}

