/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.IdentityListAccess;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/profile/UIDisplayProfileList.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={AcceptContactActionListener.class}), @EventConfig(listeners={DenyContactActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDisplayProfileList
extends UIContainer {
    private static final String INVITATION_REVOKED_INFO = "UIDisplayProfileList.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIDisplayProfileList.label.InvitationEstablishedInfo";
    private final Integer PEOPLE_PER_PAGE = 10;
    private final String ITERATOR_ID = "UIIteratorPeople";
    private IdentityManager identityManager_ = null;
    UIProfileUserSearch uiProfileUserSearchPeople = null;
    private UIPageIterator iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPeople");
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public UIDisplayProfileList() throws Exception {
        this.uiProfileUserSearchPeople = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.uiProfileUserSearchPeople.setAllUserContactName(this.loadAllUserNames());
        this.addChild((UIComponent)this.uiProfileUserSearchPeople);
    }

    public List<Identity> getList() throws Exception {
        int currentPage = this.iterator.getCurrentPage();
        List<Identity> peopleList = this.getProfiles();
        LazyPageList pageList = new LazyPageList((ListAccess)new IdentityListAccess(peopleList), this.PEOPLE_PER_PAGE.intValue());
        this.iterator.setPageList((PageList)pageList);
        int pageCount = this.iterator.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iterator.setCurrentPage(currentPage - 1);
        }
        return this.iterator.getCurrentPageData();
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentViewerUserName());
    }

    public Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    public String getPath() {
        String nodePath = Util.getPortalRequestContext().getNodePath();
        String uriPath = Util.getPortalRequestContext().getRequestURI();
        return uriPath.replaceAll(nodePath, "");
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentUserName());
    }

    public String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager_ == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.identityManager_ = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager_;
    }

    private List<Identity> getProfiles() throws Exception {
        List<Identity> matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return this.loadAllProfiles();
        }
        Iterator<Identity> itr = matchIdentities.iterator();
        while (itr.hasNext()) {
            Identity id = itr.next();
            if (id.getId() != this.getCurrentIdentity().getId()) continue;
            itr.remove();
        }
        return matchIdentities;
    }

    private String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private List<Identity> loadAllProfiles() throws Exception {
        IdentityManager im = this.getIdentityManager();
        List ids = im.getIdentities("organization");
        Iterator itr = ids.iterator();
        while (itr.hasNext()) {
            Identity id = (Identity)itr.next();
            if (id.getId() != this.getCurrentIdentity().getId()) continue;
            itr.remove();
        }
        return ids;
    }

    private List<String> loadAllUserNames() throws Exception {
        ArrayList<String> allUserContactName = new ArrayList<String>();
        List<Identity> allIds = this.loadAllProfiles();
        for (Identity identity : allIds) {
            allUserContactName.add(identity.getProfile().getFullName());
        }
        return allUserContactName;
    }

    private RelationshipManager getRelationshipManager() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList uiMyRelation = (UIDisplayProfileList)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyContactActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList portlet = (UIDisplayProfileList)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = portlet.getCurrentUserName();
            IdentityManager im = portlet.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(userId);
            RelationshipManager rm = portlet.getRelationshipManager();
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship.Type relationStatus = portlet.getContactStatus(requestedIdentity);
            if (relationStatus == Relationship.Type.ALIEN) {
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            if (rel != null) {
                rm.remove(rel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptContactActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList portlet = (UIDisplayProfileList)((Object)event.getSource());
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            String userId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = portlet.getCurrentUserName();
            IdentityManager im = portlet.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(userId);
            RelationshipManager rm = portlet.getRelationshipManager();
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            Relationship.Type relationStatus = portlet.getContactStatus(requestedIdentity);
            if (relationStatus == Relationship.Type.ALIEN) {
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            rm.confirm(rel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddContactActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList portlet = (UIDisplayProfileList)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = portlet.getCurrentUserName();
            IdentityManager im = portlet.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(userId);
            RelationshipManager rm = portlet.getRelationshipManager();
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship.Type relationStatus = portlet.getContactStatus(requestedIdentity);
            if (relationStatus != Relationship.Type.ALIEN) {
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_ESTABLISHED_INFO, null, 2));
                return;
            }
            if (rel == null) {
                rel = rm.invite(currIdentity, requestedIdentity);
            } else {
                rm.confirm(rel);
            }
        }
    }
}

