/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceApplicationList.gtmpl", events={@EventConfig(listeners={SelectCategoryActionListener.class}), @EventConfig(listeners={InstallApplicationActionListener.class})})
public class UISpaceApplicationList
extends UIContainer
implements UIPopupComponent {
    private Map<ApplicationCategory, List<Application>> appStore;
    private ApplicationCategory selectedCategory;
    private Space space;

    public ApplicationCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public ApplicationCategory getDefaultSelectedCategory() {
        if (this.appStore.keySet().size() > 0) {
            return this.appStore.keySet().iterator().next();
        }
        return null;
    }

    public void setSelectedCategory(String categoryName) {
        for (ApplicationCategory category : this.appStore.keySet()) {
            if (!category.getName().equals(categoryName)) continue;
            this.selectedCategory = category;
        }
    }

    public void setSpace(Space space) throws Exception {
        this.space = space;
        this.appStore = new LinkedHashMap<ApplicationCategory, List<Application>>();
        Map gotAppStore = SpaceUtils.getAppStore((Space)space);
        for (Map.Entry entrySet : gotAppStore.entrySet()) {
            ApplicationCategory appCategory = (ApplicationCategory)entrySet.getKey();
            List appList = (List)entrySet.getValue();
            if (appList.size() <= 0) continue;
            this.appStore.put(appCategory, appList);
        }
    }

    public Space getSpace() {
        return this.space;
    }

    public Map<ApplicationCategory, List<Application>> getAppStore() {
        return this.appStore;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstallApplicationActionListener
    extends EventListener<UISpaceApplicationList> {
        public void execute(Event<UISpaceApplicationList> event) throws Exception {
            String appId = event.getRequestContext().getRequestParameter("objectId");
            UISpaceApplicationList uiSpaceAppList = (UISpaceApplicationList)((Object)event.getSource());
            SpaceService spaceService = (SpaceService)uiSpaceAppList.getApplicationComponent(SpaceService.class);
            spaceService.installApplication(uiSpaceAppList.space, appId);
            spaceService.activateApplication(uiSpaceAppList.space, appId);
            UISpaceApplication uiSpaceApp = (UISpaceApplication)uiSpaceAppList.getAncestorOfType(UISpaceApplication.class);
            uiSpaceApp.setValue(uiSpaceAppList.space);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectCategoryActionListener
    extends EventListener<UISpaceApplicationList> {
        public void execute(Event<UISpaceApplicationList> event) throws Exception {
            String selectedCategory = event.getRequestContext().getRequestParameter("objectId");
            UISpaceApplicationList uiSpaceAppList = (UISpaceApplicationList)((Object)event.getSource());
            uiSpaceAppList.setSelectedCategory(selectedCategory);
        }
    }
}

