/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.QueryElement;

public class Limit
implements QueryElement {
    public static final Limit NONE = new Limit(Integer.MAX_VALUE, 0);
    private static final long serialVersionUID = 1L;
    private final int offset;
    private final int rowLimit;
    private final int hcode;

    public Limit(int rowLimit) {
        this(rowLimit, 0);
    }

    public Limit(int rowLimit, int offset) {
        this.rowLimit = rowLimit;
        this.offset = offset;
        this.hcode = new HashCodeBuilder().append(rowLimit).append(offset).toHashCode();
    }

    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Limit rhs = (Limit)obj;
        return new EqualsBuilder().append(this.rowLimit, rhs.rowLimit).append(this.offset, rhs.offset).isEquals();
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getRowLimit() {
        return this.rowLimit;
    }

    public int hashCode() {
        return this.hcode;
    }

    public final boolean hasRowLimited() {
        return this.rowLimit != Integer.MAX_VALUE;
    }

    public final boolean isOffset() {
        return this.offset > 0;
    }

    public final boolean isUnlimited() {
        return this.rowLimit == Integer.MAX_VALUE && this.offset == 0;
    }

    public Limit withOffset(int offset) {
        return new Limit(this.rowLimit, offset);
    }

    public Limit withRowLimit(int rowLimit) {
        return new Limit(rowLimit, this.offset);
    }

    public String toString() {
        return Visitors.readable(this);
    }
}

