/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.action;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.admin.action.UIActionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveActionListener.class})})
public class UIActionTypeForm
extends UIForm {
    public static final String FIELD_ACTIONTYPE = "actionType";
    public static final String FIELD_EXECUTEACTION = "executeAction";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ISMOVE = "isMove";
    public static final String FIELD_VARIABLES = "variables";
    public UIFormMultiValueInputSet uiFormMultiValue = null;

    public UIActionTypeForm() throws Exception {
        ArrayList actionOptions = new ArrayList();
        UIFormSelectBox actionType = new UIFormSelectBox(FIELD_ACTIONTYPE, FIELD_ACTIONTYPE, actionOptions);
        actionType.setOnChange("ChangeType");
        this.addUIFormInput((UIFormInput)actionType);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ISMOVE, FIELD_ISMOVE, null));
        UIFormSelectBox actionExecutables = new UIFormSelectBox(FIELD_EXECUTEACTION, FIELD_EXECUTEACTION, new ArrayList());
        this.addUIFormInput((UIFormInput)actionExecutables);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private List<SelectItemOption<String>> getActionTypesValues() throws Exception {
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        List actionsTypes = (List)actionServiceContainer.getActionPluginNames();
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ArrayList lstOpt = new ArrayList();
        for (int i = 0; i < actionsTypes.size(); ++i) {
            if (lstOpt.contains(actionsTypes.get(i))) continue;
            options.add((SelectItemOption<String>)new SelectItemOption((String)actionsTypes.get(i), actionsTypes.get(i)));
            lstOpt.add(actionsTypes.get(i));
        }
        return options;
    }

    private void initMultiValuesField() throws Exception {
        if (this.uiFormMultiValue != null) {
            this.removeChildById(FIELD_VARIABLES);
        }
        this.uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        this.uiFormMultiValue.setId(FIELD_VARIABLES);
        this.uiFormMultiValue.setName(FIELD_VARIABLES);
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        this.uiFormMultiValue.setValue(list);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
    }

    private List<SelectItemOption<String>> getExecutableOptions(String actionTypeName) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        ActionPlugin actionPlugin = actionServiceContainer.getActionPluginForActionType(actionTypeName);
        List executables = (List)actionPlugin.getActionExecutables(repository);
        for (String actionExec : executables) {
            options.add((SelectItemOption<String>)new SelectItemOption(actionExec, (Object)actionExec));
        }
        return options;
    }

    public void refresh() throws Exception {
        this.reset();
        List<SelectItemOption<String>> actionOptions = this.getActionTypesValues();
        String actionTypeName = (String)actionOptions.get(0).getValue();
        this.getUIFormSelectBox(FIELD_ACTIONTYPE).setOptions(actionOptions);
        this.getUIFormSelectBox(FIELD_ACTIONTYPE).setValue(actionTypeName);
        this.getUIStringInput(FIELD_NAME).setValue((Object)"");
        this.getUIFormCheckBoxInput(FIELD_ISMOVE).setChecked(false);
        List<SelectItemOption<String>> executableOptions = this.getExecutableOptions(actionTypeName);
        this.getUIFormSelectBox(FIELD_EXECUTEACTION).setOptions(executableOptions);
        this.initMultiValuesField();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            uiForm.reset();
            UIActionManager uiActionManager = (UIActionManager)uiForm.getAncestorOfType(UIActionManager.class);
            uiActionManager.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            PortletRequestContext context = (PortletRequestContext)event.getRequestContext();
            PortletPreferences preferences = context.getRequest().getPreferences();
            String repository = preferences.getValue(Utils.REPOSITORY, "");
            UIActionManager uiActionManager = (UIActionManager)uiForm.getAncestorOfType(UIActionManager.class);
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)uiForm.getApplicationComponent(ActionServiceContainer.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String selectValue = (String)uiForm.getUIFormSelectBox(UIActionTypeForm.FIELD_ACTIONTYPE).getValue();
            String actionName = (String)uiForm.getUIStringInput(UIActionTypeForm.FIELD_NAME).getValue();
            Object[] args = new Object[]{actionName};
            String[] arrFilterChar = new String[]{"&", "$", "^", "(", ")", "@", "]", "[", "*", "%", "!", "+"};
            String[] arrActionNames = actionName.split(":");
            for (String filterChar : arrFilterChar) {
                if (actionName.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UIActionTypeForm.msg.fileName-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!actionName.startsWith("exo:")) {
                uiApp.addMessage(new ApplicationMessage("UIActionTypeForm.msg.action-name-invalid", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            ArrayList<String> variables = new ArrayList<String>();
            List values = uiForm.uiFormMultiValue.getValue();
            if (values != null && values.size() > 0) {
                for (Object value : values) {
                    variables.add((String)value);
                }
            }
            for (NodeType nodeType : actionServiceContainer.getCreatedActionTypes(repository)) {
                if (!actionName.equals(nodeType.getName())) continue;
                uiApp.addMessage(new ApplicationMessage("UIActionTypeForm.msg.action-exist", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                boolean isMove = uiForm.getUIFormCheckBoxInput(UIActionTypeForm.FIELD_ISMOVE).isChecked();
                String execute = (String)uiForm.getUIFormSelectBox(UIActionTypeForm.FIELD_EXECUTEACTION).getValue();
                actionServiceContainer.createActionType(actionName, selectValue, execute, variables, isMove, repository);
                uiActionManager.refresh();
                uiForm.refresh();
                uiActionManager.removeChild(UIPopupWindow.class);
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIActionTypeForm.msg.action-type-create-error", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTypeActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiForm = (UIActionTypeForm)((Object)event.getSource());
            String actionTypeName = (String)uiForm.getUIFormSelectBox(UIActionTypeForm.FIELD_ACTIONTYPE).getValue();
            uiForm.getUIFormSelectBox(UIActionTypeForm.FIELD_EXECUTEACTION).setOptions(uiForm.getExecutableOptions(actionTypeName));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

