/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.lucene.index.IndexException;

public class IndexInfo {
    private final Log log = ExoLogger.getLogger(IndexInfo.class);
    private int counter = 0;
    private boolean dirty = false;
    private List<String> indexes = new ArrayList<String>();
    private Set<String> names = new HashSet<String>();
    private final String name;

    public IndexInfo(String fileName) {
        this.name = fileName;
    }

    public boolean exists(File dir) {
        return new File(dir, this.name).exists();
    }

    public String getFileName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File dir) throws IndexException {
        try {
            FileInputStream in = new FileInputStream(new File(dir, this.name));
            try {
                DataInputStream di = new DataInputStream(in);
                this.counter = di.readInt();
                for (int i = di.readInt(); i > 0; --i) {
                    String indexName = di.readUTF();
                    this.indexes.add(indexName);
                    this.names.add(indexName);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (FileNotFoundException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File dir) throws IOException {
        if (!this.dirty) {
            return;
        }
        File nu = new File(dir, this.name + ".new");
        FileOutputStream out = new FileOutputStream(nu);
        try {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(this.counter);
            dataOut.writeInt(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                dataOut.writeUTF(this.getName(i));
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        File old = new File(dir, this.name);
        if (old.exists() && !old.delete()) {
            throw new IOException("Unable to delete file: " + old.getAbsolutePath());
        }
        if (!nu.renameTo(old)) {
            throw new IOException("Unable to rename file: " + nu.getAbsolutePath());
        }
        this.dirty = false;
    }

    public String getName(int i) {
        return this.indexes.get(i);
    }

    public int size() {
        return this.indexes.size();
    }

    public void addName(String indexName) {
        if (this.names.contains(indexName)) {
            throw new IllegalArgumentException("already contains: " + indexName);
        }
        this.indexes.add(indexName);
        this.names.add(indexName);
        this.dirty = true;
    }

    public void removeName(String indexName) {
        this.indexes.remove(indexName);
        this.names.remove(indexName);
        this.dirty = true;
    }

    public void removeName(int i) {
        String indexName = this.indexes.remove(i);
        this.names.remove(indexName);
        this.dirty = true;
    }

    public boolean contains(String indexName) {
        return this.names.contains(indexName);
    }

    public String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }
}

