/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.CompressedChangesBuffer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedJBossCache
implements Cache<Serializable, Object> {
    private final Cache<Serializable, Object> parentCache;
    private final ThreadLocal<CompressedChangesBuffer> changesList = new ThreadLocal();
    private ThreadLocal<Boolean> local = new ThreadLocal();
    private final boolean useExpiration;
    private final long expirationTimeOut;
    protected static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.BufferedJBossCache");

    public BufferedJBossCache(Cache<Serializable, Object> parentCache, boolean useExpiration, long expirationTimeOut) {
        this.parentCache = parentCache;
        this.useExpiration = useExpiration;
        this.expirationTimeOut = expirationTimeOut;
    }

    public void beginTransaction() {
        this.changesList.set(new CompressedChangesBuffer());
        this.local.set(false);
    }

    public boolean isTransactionActive() {
        return this.changesList.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        try {
            List<ChangesContainer> containers = changesContainer.getSortedList();
            for (ChangesContainer cacheChange : containers) {
                cacheChange.apply();
            }
            Object var6_5 = null;
            this.changesList.set(null);
            changesContainer = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.changesList.set(null);
            changesContainer = null;
            throw throwable;
        }
    }

    private CompressedChangesBuffer getChangesBufferSafe() {
        CompressedChangesBuffer changesContainer = this.changesList.get();
        if (changesContainer == null) {
            throw new IllegalStateException("changesContainer should not be empty");
        }
        return changesContainer;
    }

    public void rollbackTransaction() {
        this.changesList.set(null);
    }

    public void setLocal(boolean local) {
        if (local && this.changesList.get() == null) {
            this.beginTransaction();
        }
        if (local || this.local.get().booleanValue()) {
            // empty if block
        }
        this.local.set(local);
    }

    public int getNumberOfNodes() {
        return ((CacheSPI)this.parentCache).getNumberOfNodes();
    }

    public void addCacheListener(Object listener) {
        this.parentCache.addCacheListener(listener);
    }

    public void addInterceptor(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.parentCache.addInterceptor(i, afterInterceptor);
    }

    public void addInterceptor(CommandInterceptor i, int position) {
        this.parentCache.addInterceptor(i, position);
    }

    public void clearData(Fqn fqn) {
        this.parentCache.clearData(fqn);
    }

    public void clearData(String fqn) {
        this.parentCache.clearData(fqn);
    }

    public void create() throws CacheException {
        this.parentCache.create();
    }

    public void destroy() {
        this.parentCache.destroy();
    }

    public void endBatch(boolean successful) {
        this.parentCache.endBatch(successful);
    }

    public void evict(Fqn fqn, boolean recursive) {
        this.parentCache.evict(fqn, recursive);
    }

    public void evict(Fqn fqn) {
        this.parentCache.evict(fqn);
    }

    public Object get(Fqn fqn, Serializable key) {
        return this.parentCache.get(fqn, (Object)key);
    }

    public Object getFromBuffer(Fqn fqn, Serializable key) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object objectFromBuffer = this.getObjectFromChangesContainer(changesContainer, fqn, key);
        if (objectFromBuffer != null) {
            return objectFromBuffer;
        }
        return this.parentCache.get(fqn, (Object)key);
    }

    public Object get(String fqn, Serializable key) {
        return this.parentCache.get(fqn, (Object)key);
    }

    public Set<Object> getCacheListeners() {
        return this.parentCache.getCacheListeners();
    }

    public CacheStatus getCacheStatus() {
        return this.parentCache.getCacheStatus();
    }

    public Set<Object> getChildrenNames(Fqn fqn) {
        return this.parentCache.getChildrenNames(fqn);
    }

    public Set<String> getChildrenNames(String fqn) {
        return this.parentCache.getChildrenNames(fqn);
    }

    public Configuration getConfiguration() {
        return this.parentCache.getConfiguration();
    }

    public Map<Serializable, Object> getData(Fqn fqn) {
        return this.parentCache.getData(fqn);
    }

    public InvocationContext getInvocationContext() {
        return this.parentCache.getInvocationContext();
    }

    public Set<Serializable> getKeys(Fqn fqn) {
        return this.parentCache.getKeys(fqn);
    }

    public Set<Serializable> getKeys(String fqn) {
        return this.parentCache.getKeys(fqn);
    }

    public Address getLocalAddress() {
        return this.parentCache.getLocalAddress();
    }

    public List<Address> getMembers() {
        return this.parentCache.getMembers();
    }

    public Node<Serializable, Object> getNode(Fqn fqn) {
        return this.parentCache.getNode(fqn);
    }

    public Node<Serializable, Object> getNode(String fqn) {
        return this.parentCache.getNode(fqn);
    }

    public Region getRegion(Fqn fqn, boolean createIfAbsent) {
        return this.parentCache.getRegion(fqn, createIfAbsent);
    }

    public Node<Serializable, Object> getRoot() {
        return this.parentCache.getRoot();
    }

    public String getVersion() {
        return this.parentCache.getVersion();
    }

    public boolean isLeaf(Fqn fqn) {
        return this.parentCache.isLeaf(fqn);
    }

    public boolean isLeaf(String fqn) {
        return this.parentCache.isLeaf(fqn);
    }

    public void move(Fqn nodeToMove, Fqn newParent) throws NodeNotExistsException {
        this.parentCache.move(nodeToMove, newParent);
    }

    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.parentCache.move(nodeToMove, newParent);
    }

    public void put(Fqn fqn, Map<? extends Serializable, ? extends Object> data) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectContainer(fqn, data, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public Object put(Fqn fqn, Serializable key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutKeyValueContainer(fqn, key, value, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
        return this.parentCache.get(fqn, (Object)key);
    }

    public Object putInBuffer(Fqn fqn, Serializable key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object prevObject = this.getObjectFromChangesContainer(changesContainer, fqn, key);
        changesContainer.add(new PutKeyValueContainer(fqn, key, value, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
        if (prevObject != null) {
            return prevObject;
        }
        return this.parentCache.get(fqn, (Object)key);
    }

    private Object getObjectFromChangesContainer(CompressedChangesBuffer changesContainer, Fqn fqn, Serializable key) {
        List<ChangesContainer> changes = changesContainer.getSortedList();
        Object object = null;
        for (ChangesContainer change : changes) {
            PutKeyValueContainer cont;
            if (!change.getChangesType().equals((Object)ChangesType.PUT_KEY) || !change.getFqn().equals((Object)fqn) || !(cont = (PutKeyValueContainer)change).key.equals(key)) continue;
            object = ((PutKeyValueContainer)change).value;
        }
        return object;
    }

    public void put(String fqn, Map<? extends Serializable, ? extends Object> data) {
        throw new UnsupportedOperationException("Unexpected method call use put(Fqn fqn, Map<? extends Serializable, ? extends Object> data)");
    }

    public Object put(String fqn, Serializable key, Object value) {
        throw new UnsupportedOperationException("Unexpected method call use put(Fqn fqn, Serializable key, Object value)");
    }

    public void putForExternalRead(Fqn fqn, Serializable key, Object value) {
        throw new UnsupportedOperationException("Unexpected method call ");
    }

    public Object remove(Fqn fqn, Serializable key) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveKeyContainer(fqn, key, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
        return this.parentCache.get(fqn, (Object)key);
    }

    public Object remove(String fqn, Serializable key) {
        throw new UnsupportedOperationException("Unexpected method call. Use remove(Fqn fqn, Serializable key)");
    }

    public void removeCacheListener(Object listener) {
        this.parentCache.removeCacheListener(listener);
    }

    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.parentCache.removeInterceptor(interceptorType);
    }

    public void removeInterceptor(int position) {
        this.parentCache.removeInterceptor(position);
    }

    public boolean removeNode(Fqn fqn) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveNodeContainer(fqn, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
        return true;
    }

    public boolean removeNode(String fqn) {
        throw new UnsupportedOperationException("Unexpected method call. Use remove removeNode(Fqn fqn)");
    }

    public boolean removeRegion(Fqn fqn) {
        return this.parentCache.removeRegion(fqn);
    }

    public void setInvocationContext(InvocationContext ctx) {
        this.parentCache.setInvocationContext(ctx);
    }

    public void start() throws CacheException {
        this.parentCache.start();
    }

    public void startBatch() {
        this.parentCache.startBatch();
    }

    public void stop() {
        this.parentCache.stop();
    }

    public TransactionManager getTransactionManager() {
        return ((CacheSPI)this.parentCache).getTransactionManager();
    }

    public void addToList(Fqn fqn, String key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new AddToListContainer(fqn, (Serializable)((Object)key), value, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public void removeFromList(Fqn fqn, String key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveFromListContainer(fqn, (Serializable)((Object)key), value, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveNodeContainer
    extends ChangesContainer {
        public RemoveNodeContainer(Fqn fqn, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE, cache, historicalIndex, local, useExpiration, timeOut);
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.removeNode(this.fqn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveKeyContainer
    extends ChangesContainer {
        private final Serializable key;

        public RemoveKeyContainer(Fqn fqn, Serializable key, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.remove(this.fqn, (Object)this.key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveFromListContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public RemoveFromListContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            this.setCacheLocalMode();
            Object existingObject = this.cache.get(this.getFqn(), (Object)this.key);
            if (existingObject instanceof Set) {
                HashSet newSet = new HashSet((Set)existingObject);
                newSet.remove(this.value);
                if (this.useExpiration) {
                    this.putExpiration(this.fqn);
                }
                this.setCacheLocalMode();
                this.cache.put(this.fqn, (Object)this.key, newSet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddToListContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public AddToListContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            Object existingObject = this.cache.get(this.getFqn(), (Object)this.key);
            HashSet<Object> newSet = new HashSet<Object>();
            if (existingObject instanceof Set || existingObject == null) {
                if (existingObject instanceof Set) {
                    newSet.addAll((Set)existingObject);
                }
                newSet.add(this.value);
                if (this.useExpiration) {
                    this.putExpiration(this.fqn);
                }
                this.setCacheLocalMode();
                this.cache.put(this.fqn, (Object)this.key, newSet);
            } else {
                LOG.error((Object)("Unexpected object found by FQN:" + this.getFqn() + " and key:" + this.key + ". Expected Set, but found:" + existingObject.getClass().getName()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutKeyValueContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public PutKeyValueContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            if (this.useExpiration) {
                this.putExpiration(this.fqn);
            }
            this.setCacheLocalMode();
            this.cache.put(this.fqn, (Object)this.key, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutObjectContainer
    extends ChangesContainer {
        private final Map<? extends Serializable, ? extends Object> data;

        public PutObjectContainer(Fqn fqn, Map<? extends Serializable, ? extends Object> data, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT, cache, historicalIndex, local, useExpiration, timeOut);
            this.data = data;
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.put(this.fqn, this.data);
            if (this.useExpiration) {
                this.putExpiration(this.fqn);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ChangesContainer
    implements Comparable<ChangesContainer> {
        protected final Fqn fqn;
        protected final ChangesType changesType;
        protected final Cache<Serializable, Object> cache;
        protected final int historicalIndex;
        protected final boolean localMode;
        protected final boolean useExpiration;
        protected final long timeOut;

        public ChangesContainer(Fqn fqn, ChangesType changesType, Cache<Serializable, Object> cache, int historicalIndex, boolean localMode, boolean useExpiration, long timeOut) {
            this.fqn = fqn;
            this.changesType = changesType;
            this.cache = cache;
            this.historicalIndex = historicalIndex;
            this.localMode = localMode;
            this.useExpiration = useExpiration;
            this.timeOut = timeOut;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public int getHistoricalIndex() {
            return this.historicalIndex;
        }

        public ChangesType getChangesType() {
            return this.changesType;
        }

        public String toString() {
            return this.fqn + " type=" + (Object)((Object)this.changesType) + " historyIndex=" + this.historicalIndex;
        }

        @Override
        public int compareTo(ChangesContainer o) {
            int result = this.fqn.compareTo(o.getFqn());
            return result == 0 ? this.historicalIndex - o.getHistoricalIndex() : result;
        }

        protected void setCacheLocalMode() {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(this.localMode);
        }

        public final void putExpiration(Fqn efqn) {
            this.setCacheLocalMode();
            this.cache.put(efqn, (Object)"expiration", (Object)new Long(System.currentTimeMillis() + this.timeOut));
        }

        public abstract void apply();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangesType {
        REMOVE,
        REMOVE_KEY,
        PUT,
        PUT_KEY,
        PUT_TO_LIST;

    }
}

