/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFile;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class TreeFileIOChannel
extends FileIOChannel {
    private static Semaphore mkdirsLock = new Semaphore(1);

    TreeFileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueDataResourceHolder resources) {
        super(rootDir, cleaner, storageId, resources);
    }

    protected String makeFilePath(String propertyId, int orderNumber) {
        return this.buildPath(propertyId) + File.separator + propertyId + orderNumber;
    }

    protected File getFile(String propertyId, int orderNumber) throws IOException {
        TreeFile tfile = new TreeFile(this.rootDir.getAbsolutePath() + this.makeFilePath(propertyId, orderNumber), this.cleaner, this.rootDir);
        TreeFileIOChannel.mkdirs(tfile.getParentFile());
        return tfile;
    }

    protected File[] getFiles(String propertyId) throws IOException {
        File dir = new File(this.rootDir.getAbsolutePath() + this.buildPath(propertyId));
        String[] fileNames = dir.list();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new TreeFile(dir.getAbsolutePath() + File.separator + fileNames[i], this.cleaner, this.rootDir);
        }
        return files;
    }

    protected String buildPath(String fileName) {
        return this.buildPathX8(fileName);
    }

    protected String buildPathX(String fileName) {
        char[] chs = fileName.toCharArray();
        String path = "";
        for (char ch : chs) {
            path = path + File.separator + ch;
        }
        return path;
    }

    protected String buildPathX8(String fileName) {
        int xLength = 8;
        char[] chs = fileName.toCharArray();
        String path = "";
        for (int i = 0; i < 8; ++i) {
            path = path + File.separator + chs[i];
        }
        path = path + fileName.substring(8);
        return path;
    }

    protected String buildPathXX2X4(String fileName) {
        int xxLength = 4;
        int xLength = 8;
        boolean xxBlock = true;
        char[] chs = fileName.toCharArray();
        String path = "";
        for (int xxi = 0; xxi < 4; ++xxi) {
            char ch = chs[xxi];
            path = path + (xxBlock ? File.separator + ch : Character.valueOf(ch));
            xxBlock = !xxBlock;
        }
        for (int xi = 4; xi < 8; ++xi) {
            path = path + File.separator + chs[xi];
        }
        path = path + fileName.substring(8);
        return path;
    }

    protected String buildPathXX(String fileName) {
        char[] chs = fileName.toCharArray();
        String path = "";
        boolean block = true;
        for (char ch : chs) {
            path = path + (block ? File.separator + ch : Character.valueOf(ch));
            block = !block;
        }
        return path;
    }

    protected String buildPathXX8(String fileName) {
        int xxLength = 16;
        char[] chs = fileName.toCharArray();
        String path = "";
        boolean block = true;
        for (int i = 0; i < 16; ++i) {
            char ch = chs[i];
            path = path + (block ? File.separator + ch : Character.valueOf(ch));
            block = !block;
        }
        path = path + fileName.substring(16);
        return path;
    }

    private static boolean mkdirs(File dir) {
        try {
            mkdirsLock.acquire();
            boolean bl = dir.mkdirs();
            Object var3_3 = null;
            mkdirsLock.release();
            return bl;
        }
        catch (InterruptedException e) {
            try {
                throw new IllegalStateException("mkdirs error on " + dir.getAbsolutePath() + " due to " + e, e);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                mkdirsLock.release();
                throw throwable;
            }
        }
    }
}

