/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.JCRPageList;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPageListQuery
extends JCRPageList {
    private String username_;
    private NodeIterator iter_ = null;
    private String value_;
    private long pageReturn = 0L;
    private Session session_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPageListQuery(String username, String value, long pageSize) throws Exception {
        super(pageSize);
        this.username_ = username;
        this.value_ = value;
        Session session = this.getJCRSession(username);
        if (session != null) {
            try {
                this.setAvailablePage(((QueryResultImpl)this.createXPathQuery(session, username, this.value_).execute()).getTotalSize());
            }
            finally {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        Session session = this.getJCRSession(username);
        long totalPage = 0L;
        try {
            QueryImpl queryImpl = this.createXPathQuery(session, username, this.value_);
            if (page > 1L) {
                long position = (page - 1L) * pageSize;
                if (this.pageReturn == page) {
                    queryImpl.setOffset(position - 1L);
                } else {
                    queryImpl.setOffset(position);
                }
            }
            queryImpl.setLimit(pageSize);
            QueryResult result = queryImpl.execute();
            this.iter_ = result.getNodes();
            totalPage = ((QueryResultImpl)result).getTotalSize();
        }
        finally {
            session.logout();
        }
        this.setAvailablePage(totalPage);
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType(Utils.EXO_CALENDAR_EVENT)) {
                CalendarEvent calendarEvent = this.getEvent(currentNode);
                this.currentListPage_.add(calendarEvent);
            }
            ++i;
        }
        this.iter_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalendarEvent getEvent(Node eventNode) throws Exception {
        int i;
        Value[] values;
        CalendarEvent event = new CalendarEvent();
        if (eventNode.getPath().contains(this.getPublicServiceHome())) {
            event.setCalType("2");
        } else if (eventNode.getPath().contains(this.getPrivateServiceHome())) {
            event.setCalType("0");
        } else {
            event.setCalType("1");
        }
        if (eventNode.hasProperty(Utils.EXO_ID)) {
            event.setId(eventNode.getProperty(Utils.EXO_ID).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_CALENDAR_ID)) {
            event.setCalendarId(eventNode.getProperty(Utils.EXO_CALENDAR_ID).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_SUMMARY)) {
            event.setSummary(eventNode.getProperty(Utils.EXO_SUMMARY).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_CATEGORYID)) {
            event.setEventCategoryId(eventNode.getProperty(Utils.EXO_EVENT_CATEGORYID).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_CATEGORY_NAME)) {
            event.setEventCategoryName(eventNode.getProperty(Utils.EXO_EVENT_CATEGORY_NAME).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_LOCATION)) {
            event.setLocation(eventNode.getProperty(Utils.EXO_LOCATION).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_TASK_DELEGATOR)) {
            event.setTaskDelegator(eventNode.getProperty(Utils.EXO_TASK_DELEGATOR).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_REPEAT)) {
            event.setRepeatType(eventNode.getProperty(Utils.EXO_REPEAT).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_DESCRIPTION)) {
            event.setDescription(eventNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_FROM_DATE_TIME)) {
            event.setFromDateTime(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
        }
        if (eventNode.hasProperty(Utils.EXO_TO_DATE_TIME)) {
            event.setToDateTime(eventNode.getProperty(Utils.EXO_TO_DATE_TIME).getDate().getTime());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_TYPE)) {
            event.setEventType(eventNode.getProperty(Utils.EXO_EVENT_TYPE).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_PRIORITY)) {
            event.setPriority(eventNode.getProperty(Utils.EXO_PRIORITY).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_IS_PRIVATE)) {
            event.setPrivate(eventNode.getProperty(Utils.EXO_IS_PRIVATE).getBoolean());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_STATE)) {
            event.setEventState(eventNode.getProperty(Utils.EXO_EVENT_STATE).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_SEND_OPTION)) {
            event.setSendOption(eventNode.getProperty(Utils.EXO_SEND_OPTION).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_MESSAGE)) {
            event.setMessage(eventNode.getProperty(Utils.EXO_MESSAGE).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_DATE_MODIFIED)) {
            event.setLastUpdatedTime(eventNode.getProperty(Utils.EXO_DATE_MODIFIED).getDate().getTime());
        }
        try {
            event.setReminders(this.getReminders(eventNode));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        event.setAttachment(this.getAttachments(eventNode));
        if (eventNode.hasProperty(Utils.EXO_INVITATION)) {
            values = eventNode.getProperty(Utils.EXO_INVITATION).getValues();
            if (values.length == 1) {
                event.setInvitation(new String[]{values[0].getString()});
            } else {
                String[] invites = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    invites[i] = values[i].getString();
                }
                event.setInvitation(invites);
            }
        }
        if (eventNode.hasProperty(Utils.EXO_PARTICIPANT)) {
            values = eventNode.getProperty(Utils.EXO_PARTICIPANT).getValues();
            if (values.length == 1) {
                event.setParticipant(new String[]{values[0].getString()});
            } else {
                String[] participant = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    participant[i] = values[i].getString();
                }
                event.setParticipant(participant);
            }
        }
        if (eventNode.hasProperty(Utils.EXO_PARTICIPANT_STATUS)) {
            values = eventNode.getProperty(Utils.EXO_PARTICIPANT_STATUS).getValues();
            if (values.length == 1) {
                event.setParticipantStatus(new String[]{values[0].getString()});
            } else {
                String[] participantStatus = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    participantStatus[i] = values[i].getString();
                }
                event.setParticipantStatus(participantStatus);
            }
        }
        return event;
    }

    public List<Attachment> getAttachments(Node eventNode) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (eventNode.hasNode(Utils.ATTACHMENT_NODE)) {
            Node attachHome = eventNode.getNode(Utils.ATTACHMENT_NODE);
            NodeIterator iter = attachHome.getNodes();
            while (iter.hasNext()) {
                Node contentNode;
                Node attchmentNode = iter.nextNode();
                if (!attchmentNode.isNodeType(Utils.EXO_EVEN_TATTACHMENT)) continue;
                Attachment attachment = new Attachment();
                attachment.setId(attchmentNode.getPath());
                if (attchmentNode.hasProperty(Utils.EXO_FILE_NAME)) {
                    attachment.setName(attchmentNode.getProperty(Utils.EXO_FILE_NAME).getString());
                }
                if ((contentNode = attchmentNode.getNode(Utils.JCR_CONTENT)) != null) {
                    if (contentNode.hasProperty(Utils.JCR_LASTMODIFIED)) {
                        attachment.setLastModified(contentNode.getProperty(Utils.JCR_LASTMODIFIED).getDate());
                    }
                    if (contentNode.hasProperty(Utils.JCR_MIMETYPE)) {
                        attachment.setMimeType(contentNode.getProperty(Utils.JCR_MIMETYPE).getString());
                    }
                    if (contentNode.hasProperty(Utils.JCR_DATA)) {
                        InputStream inputStream = contentNode.getProperty(Utils.JCR_DATA).getStream();
                        attachment.setSize(inputStream.available());
                        attachment.setInputStream(inputStream);
                    }
                }
                attachment.setWorkspace(attchmentNode.getSession().getWorkspace().getName());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    private Node getReminderFolder(Date fromDate) throws Exception {
        return null;
    }

    private List<Reminder> getReminders(Node eventNode) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CalendarEvent> getAll() throws Exception {
        Session session = this.getJCRSession(this.username_);
        try {
            QueryImpl queryImpl = this.createXPathQuery(session, this.username_, this.value_);
            QueryResult result = queryImpl.execute();
            this.iter_ = result.getNodes();
        }
        finally {
            session.logout();
        }
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        while (this.iter_.hasNext()) {
            Node eventNode = this.iter_.nextNode();
            events.add(this.getEvent(eventNode));
        }
        return events;
    }

    private String getPublicServiceHome() throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        Node publicApp = nodeHierarchyCreator.getPublicApplicationNode(provider);
        if (publicApp != null && publicApp.hasNode(Utils.CALENDAR_APP)) {
            return publicApp.getNode(Utils.CALENDAR_APP).getPath();
        }
        return null;
    }

    private String getPrivateServiceHome() throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        Node privateApp = nodeHierarchyCreator.getUserApplicationNode(provider, this.username_);
        if (privateApp != null && privateApp.hasNode(Utils.CALENDAR_APP)) {
            return privateApp.getNode(Utils.CALENDAR_APP).getPath();
        }
        return null;
    }

    public void setSession(Session s) {
        this.session_ = s;
    }

    private Session getJCRSession(String username) throws Exception {
        try {
            RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            String defaultWS = repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
            return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
        }
        catch (NullPointerException e) {
            return this.session_;
        }
    }

    private QueryImpl createXPathQuery(Session session, String username, String xpath) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (QueryImpl)queryManager.createQuery(xpath, "xpath");
    }
}

