/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryControl;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/UIRepositorySelectForm.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={OnchangeActionListener.class})})
public class UIRepositorySelectForm
extends UIForm {
    public static final String FIELD_SELECTREPO = "selectRepo";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIRepositorySelectForm");

    public UIRepositorySelectForm() {
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_SELECTREPO, FIELD_SELECTREPO, null));
    }

    protected void setOptionValue(List<SelectItemOption<String>> list) {
        this.getUIFormSelectBox(FIELD_SELECTREPO).setOptions(list);
    }

    protected void setActionEvent() {
        this.getUIFormSelectBox(FIELD_SELECTREPO).setOnChange("Onchange");
    }

    protected String getSelectedValue() {
        return (String)this.getUIFormSelectBox(FIELD_SELECTREPO).getValue();
    }

    protected void setSelectedValue(String value) {
        this.getUIFormSelectBox(FIELD_SELECTREPO).setValue(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnchangeActionListener
    extends EventListener<UIRepositorySelectForm> {
        public void execute(Event<UIRepositorySelectForm> event) throws Exception {
            UIRepositorySelectForm uiForm = (UIRepositorySelectForm)((Object)event.getSource());
            RepositoryService rservice = (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class);
            UIRepositoryControl uiControl = (UIRepositoryControl)uiForm.getAncestorOfType(UIRepositoryControl.class);
            PortletRequestContext requestContext = (PortletRequestContext)event.getRequestContext();
            PortletRequest portletRequest = requestContext.getRequest();
            PortletPreferences portletPref = portletRequest.getPreferences();
            String oldRepository = portletPref.getValue(Utils.REPOSITORY, "");
            String selectRepo = uiForm.getSelectedValue();
            portletPref.setValue(Utils.REPOSITORY, selectRepo);
            portletPref.store();
            uiForm.setOptionValue(uiControl.getRepoItem(true, (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class)));
            uiForm.setSelectedValue(selectRepo);
            rservice.setCurrentRepositoryName(selectRepo);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            try {
                ((UIECMAdminPortlet)uiForm.getAncestorOfType(UIECMAdminPortlet.class)).initChilds();
            }
            catch (AccessDeniedException ade) {
                uiApp.addMessage(new ApplicationMessage("UIRepositorySelectForm.msg-accessdenied", new Object[]{selectRepo}));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                portletPref.setValue(Utils.REPOSITORY, oldRepository);
                portletPref.store();
                uiForm.setOptionValue(uiControl.getRepoItem(true, (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class)));
                uiForm.setSelectedValue(oldRepository);
                rservice.setCurrentRepositoryName(oldRepository);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                uiApp.addMessage(new ApplicationMessage("UIRepositorySelectForm.msg-editError", new Object[]{selectRepo}));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                portletPref.setValue(Utils.REPOSITORY, oldRepository);
                portletPref.store();
                uiForm.setOptionValue(uiControl.getRepoItem(true, (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class)));
                uiForm.setSelectedValue(oldRepository);
                rservice.setCurrentRepositoryName(oldRepository);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiControl.getAncestorOfType(UIECMAdminPortlet.class));
        }
    }
}

