/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.pop3.POP3Store;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPTransport;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.jcr.Node;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import javax.mail.util.ByteArrayDataSource;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.mail.connection.impl.ImapConnector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.AccountData;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.CheckMailJob;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Info;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.MailUpdateStorageEventListener;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.ServerConfiguration;
import org.exoplatform.mail.service.SpamFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.service.impl.DispositionNotification;
import org.exoplatform.mail.service.impl.EMLImportExport;
import org.exoplatform.mail.service.impl.JCRDataStorage;
import org.exoplatform.mail.service.impl.MultipartReport;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.picocontainer.Startable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServiceImpl
implements MailService,
Startable {
    private static final Log logger = ExoLogger.getLogger((String)"cs.mail.service");
    private JCRDataStorage storage_;
    private EMLImportExport emlImportExport_;
    private Map<String, CheckingInfo> checkingLog_;
    private JobSchedulerService schedulerService_;
    private ContinuationService continuationService_;
    public List<MailUpdateStorageEventListener> listeners_ = new ArrayList<MailUpdateStorageEventListener>();

    public MailServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, JobSchedulerService schedulerService, RepositoryService reposervice) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, reposervice);
        this.emlImportExport_ = new EMLImportExport(this.storage_);
        this.checkingLog_ = new ConcurrentHashMap<String, CheckingInfo>();
        this.schedulerService_ = schedulerService;
    }

    @Override
    public String getMailHierarchyNode() throws Exception {
        return this.storage_.getMailHierarchyNode();
    }

    @Override
    public void removeCheckingInfo(String userName, String accountId) throws Exception {
        String key = userName + ":" + accountId;
        this.checkingLog_.remove(key);
    }

    @Override
    public CheckingInfo getCheckingInfo(String userName, String accountId) {
        String key = userName + ":" + accountId;
        CheckingInfo info = this.checkingLog_.get(key);
        return info;
    }

    @Override
    public List<Account> getAccounts(String userName) throws Exception {
        return this.storage_.getAccounts(userName);
    }

    @Override
    public Account getAccountById(String userName, String id) throws Exception {
        return this.storage_.getAccountById(userName, id);
    }

    public void saveAccount(String userName, Account account, boolean isNew) throws Exception {
        this.storage_.saveAccount(userName, account, isNew);
    }

    @Override
    public void updateAccount(String userName, Account account) throws Exception {
        this.saveAccount(userName, account, false);
    }

    @Override
    public void updateErrorAccount(String userName, Account account) throws Exception {
        IMAPStore store;
        this.saveAccount(userName, account, false);
        String accountId = account.getId();
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        String key = userName + ":" + accountId;
        if (info == null) {
            this.checkingLog_.put(key, new CheckingInfo());
        }
        if ((store = this.openIMAPConnection(userName, account, info)) != null) {
            this.synchImapFolders(userName, accountId);
        }
    }

    @Override
    public void removeAccount(String userName, String accountId) throws Exception {
        this.stopAllJobs(userName, accountId);
        this.storage_.removeAccount(userName, accountId);
    }

    @Override
    public Folder getFolder(String userName, String accountId, String folderId) throws Exception {
        return this.storage_.getFolder(userName, accountId, folderId);
    }

    @Override
    public String getFolderParentId(String userName, String accountId, String folderId) throws Exception {
        return this.storage_.getFolderParentId(userName, accountId, folderId);
    }

    @Override
    public boolean isExistFolder(String userName, String accountId, String parentId, String folderName) throws Exception {
        return this.storage_.isExistFolder(userName, accountId, parentId, folderName);
    }

    @Override
    public void saveFolder(String userName, String accountId, Folder folder) throws Exception {
        this.saveFolder(userName, accountId, folder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFolderImapOnline(String userName, String accountId, Folder folder) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            IMAPFolder imapFolder = null;
            try {
                ImapConnector connector = new ImapConnector(account);
                imapFolder = (IMAPFolder)connector.createFolder(folder);
                this.saveFolder(userName, accountId, null, (javax.mail.Folder)imapFolder);
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (imapFolder != null && imapFolder.isOpen()) {
                    imapFolder.close(true);
                }
            }
        } else {
            this.storage_.saveFolder(userName, accountId, folder);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFolder(String userName, String accountId, Folder folder, boolean b) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder() && b) {
            IMAPFolder imapFolder = null;
            try {
                ImapConnector connector = new ImapConnector(account);
                imapFolder = (IMAPFolder)connector.createFolder(folder);
                this.saveFolder(userName, accountId, null, (javax.mail.Folder)imapFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                if (imapFolder != null && imapFolder.isOpen()) {
                    imapFolder.close(true);
                }
            }
        } else {
            this.storage_.saveFolder(userName, accountId, folder);
        }
    }

    @Override
    public void saveFolder(String userName, String accountId, String parentId, Folder folder) throws Exception {
        this.saveFolder(userName, accountId, parentId, folder, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveFolderImapOnline(String userName, String accountId, String parentId, Folder folder) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            try {
                Folder parentFolder = this.getFolder(userName, accountId, parentId);
                ImapConnector connector = new ImapConnector(account);
                IMAPFolder imapFolder = (IMAPFolder)connector.createFolder(parentFolder, folder);
                if (imapFolder == null) return true;
                this.saveFolder(userName, accountId, parentFolder, (javax.mail.Folder)imapFolder);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        } else {
            this.storage_.saveFolder(userName, accountId, parentId, folder);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveFolder(String userName, String accountId, String parentId, Folder folder, boolean b) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder() && b) {
            try {
                Folder parentFolder = this.getFolder(userName, accountId, parentId);
                ImapConnector connector = new ImapConnector(account);
                IMAPFolder imapFolder = (IMAPFolder)connector.createFolder(parentFolder, folder);
                if (imapFolder == null) return;
                this.saveFolder(userName, accountId, parentFolder, (javax.mail.Folder)imapFolder);
                return;
            }
            catch (Exception e) {
                return;
            }
        } else {
            this.storage_.saveFolder(userName, accountId, parentId, folder);
        }
    }

    private void saveFolder(String userName, String accountId, Folder parentFolder, javax.mail.Folder serverFolder) throws Exception {
        String folderId = serverFolder.getType() != 2 ? Utils.generateFID(accountId, String.valueOf(((IMAPFolder)serverFolder).getUIDValidity()), true) : Utils.escapeIllegalJcrChars(serverFolder.getName());
        Folder folder = this.storage_.getFolder(userName, accountId, folderId);
        if (folder == null) {
            folder = new Folder();
            folder.setId(folderId);
            folder.setName(serverFolder.getName());
            folder.setURLName(serverFolder.getURLName().toString());
            folder.setNumberOfUnreadMessage(0L);
            folder.setTotalMessage(0L);
            folder.setPersonalFolder(true);
            folder.setType(serverFolder.getType());
            try {
                if (parentFolder == null) {
                    this.storage_.saveFolder(userName, accountId, folder);
                } else {
                    this.storage_.saveFolder(userName, accountId, parentFolder.getId(), folder);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void renameFolder(String userName, String accountId, String newName, String folderId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolder(userName, accountId, folderId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            try {
                ImapConnector connector = new ImapConnector(account);
                folder = connector.renameFolder(newName, folder);
            }
            catch (Exception e) {
                return;
            }
        }
        if (folder != null) {
            this.storage_.renameFolder(userName, accountId, newName, folder);
        }
    }

    private void deleteLocalFolder(String userName, String accountId, String folderId) throws Exception {
        this.storage_.removeUserFolder(userName, accountId, folderId);
    }

    @Override
    public void removeUserFolder(String userName, String accountId, String folderId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolder(userName, accountId, folderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            try {
                ImapConnector connector = new ImapConnector(account);
                success = connector.deleteFolder(folder);
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.removeUserFolder(userName, accountId, folderId);
        }
    }

    @Override
    public List<MessageFilter> getFilters(String userName, String accountId) throws Exception {
        return this.storage_.getFilters(userName, accountId);
    }

    @Override
    public MessageFilter getFilterById(String userName, String accountId, String filterId) throws Exception {
        return this.storage_.getFilterById(userName, accountId, filterId);
    }

    @Override
    public void saveFilter(String userName, String accountId, MessageFilter filter, boolean applyAll) throws Exception {
        String toFolder = filter.getApplyFolder();
        List<Message> messageList = this.storage_.getMessagePageList(userName, filter).getAll(userName);
        String fromFolder = null;
        if (messageList.size() > 0) {
            fromFolder = messageList.get(0).getFolders()[0];
        }
        this.moveMessages(userName, accountId, messageList, fromFolder, toFolder);
        this.storage_.saveFilter(userName, accountId, filter, applyAll);
    }

    @Override
    public void removeFilter(String userName, String accountId, String filterId) throws Exception {
        this.storage_.removeFilter(userName, accountId, filterId);
    }

    @Override
    public Message getMessageById(String userName, String accountId, String msgId) throws Exception {
        return this.storage_.getMessageById(userName, accountId, msgId);
    }

    @Override
    public void removeMessage(String userName, String accountId, Message message) throws Exception {
        this.storage_.removeMessage(userName, accountId, message);
    }

    @Override
    public void removeMessages(String userName, String accountId, List<Message> messages, boolean moveReference) throws Exception {
        this.storage_.removeMessages(userName, accountId, messages, moveReference);
    }

    @Override
    public void moveMessages(String userName, String accountId, List<Message> msgList, String currentFolderId, String destFolderId) throws Exception {
        boolean success;
        block5: {
            Account account = this.getAccountById(userName, accountId);
            Folder currentFolder = this.getFolder(userName, accountId, currentFolderId);
            Folder destFolder = this.getFolder(userName, accountId, destFolderId);
            success = true;
            if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
                try {
                    ImapConnector connector = new ImapConnector(account);
                    msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                    if (msgList == null) {
                        success = false;
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)("\n\n move message error " + e.getMessage()));
                }
            }
        }
        if (success) {
            this.storage_.moveMessages(userName, accountId, msgList, currentFolderId, destFolderId);
        }
    }

    @Override
    public void moveMessages(String userName, String accountId, List<Message> msgList, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder currentFolder = this.getFolder(userName, accountId, currentFolderId);
        Folder destFolder = this.getFolder(userName, accountId, destFolderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                if (msgList == null) {
                    success = false;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Mailservice: Move message error", (Throwable)e);
            }
        }
        if (success) {
            this.storage_.moveMessages(userName, accountId, msgList, currentFolderId, destFolderId, updateReference);
        }
    }

    @Override
    public void moveMessage(String userName, String accountId, Message msg, String currentFolderId, String destFolderId) throws Exception {
        boolean success;
        block6: {
            Account account = this.getAccountById(userName, accountId);
            Folder currentFolder = this.getFolder(userName, accountId, currentFolderId);
            Folder destFolder = this.getFolder(userName, accountId, destFolderId);
            success = true;
            if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
                try {
                    List<Message> msgList = new ArrayList<Message>();
                    ImapConnector connector = new ImapConnector(account);
                    msgList.add(msg);
                    msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                    if (msgList == null) {
                        success = false;
                    } else {
                        msg = msgList.get(0);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)"Mailservice: Move message fail", (Throwable)e);
                }
            }
        }
        if (success) {
            this.moveMessage(userName, accountId, msg, currentFolderId, destFolderId, true);
        }
    }

    @Override
    public void moveMessage(String userName, String accountId, Message msg, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder currentFolder = this.getFolder(userName, accountId, currentFolderId);
        Folder destFolder = this.getFolder(userName, accountId, destFolderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                List<Message> msgList = new ArrayList<Message>();
                msgList.add(msg);
                msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                if (msgList == null) {
                    success = false;
                } else {
                    msg = msgList.get(0);
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.moveMessage(userName, accountId, msg, currentFolderId, destFolderId, updateReference);
        }
    }

    @Override
    public MessagePageList getMessagePageList(String userName, MessageFilter filter) throws Exception {
        return this.storage_.getMessagePageList(userName, filter);
    }

    @Override
    public void saveMessage(String userName, Account account, String targetMsgPath, Message message, boolean isNew) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        msgList.add(message);
        String folderId = message.getFolders()[0];
        Folder destFolder = null;
        if (folderId != null) {
            destFolder = this.getFolder(userName, account.getId(), folderId);
        }
        if (destFolder != null && account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            ImapConnector connector = new ImapConnector(account);
            connector.createMessage(msgList, destFolder);
        }
        this.storage_.saveMessage(userName, account.getId(), targetMsgPath, message, isNew);
    }

    @Override
    public void saveMessage(String userName, String accountId, String targetMsgPath, Message message, boolean isNew) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        this.saveMessage(userName, account, targetMsgPath, message, isNew);
    }

    @Override
    public List<Message> getMessagesByTag(String userName, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Tag");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{tagId});
        return this.getMessages(userName, filter);
    }

    @Override
    public List<Message> getMessagesByFolder(String userName, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        List<Message> list = this.getMessages(userName, filter);
        return list;
    }

    @Override
    public List<Message> getMessages(String userName, MessageFilter filter) throws Exception {
        return this.storage_.getMessages(userName, filter);
    }

    @Override
    public void saveMessage(String userName, String accountId, Message message, boolean isNew) throws Exception {
        this.storage_.saveMessage(userName, accountId, message, isNew);
    }

    @Override
    public Message sendMessage(String userName, String accId, Message message) throws Exception {
        Account acc = this.getAccountById(userName, accId);
        return this.sendMessage(userName, acc, message);
    }

    @Override
    public Message sendMessage(String userName, Account acc, Message message) throws Exception {
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        String isSSl = acc.getServerProperties().get(Utils.SVR_OUTGOING_SSL);
        boolean isSMTPAuth = acc.isOutgoingAuthentication();
        Properties props = System.getProperties();
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        props.put(Utils.SVR_SMTP_HOST, outgoingHost);
        props.put(Utils.SVR_SMTP_PORT, outgoingPort);
        props.put("mail.smtp.dsn.notify", "SUCCESS,FAILURE ORCPT=rfc822;" + acc.getEmailAddress());
        props.put("mail.smtp.dsn.ret", "FULL");
        props.put("mail.smtp.socketFactory.port", outgoingPort);
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "true");
        props.put("mail.smtp.connectiontimeout", "0");
        props.put("mail.smtp.timeout", "0");
        String socketFactoryClass = "javax.net.SocketFactory";
        if (Boolean.valueOf(isSSl).booleanValue()) {
            socketFactoryClass = Utils.SSL_FACTORY;
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, socketFactoryClass);
        if (isSMTPAuth) {
            props.put(Utils.SVR_SMTP_AUTH, "true");
        } else {
            props.put(Utils.SVR_SMTP_AUTH, "false");
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        logger.debug((Object)" #### Sending email ... ");
        Transport transport = session.getTransport("smtp");
        try {
            if (!isSMTPAuth) {
                transport.connect();
            } else if (acc.useIncomingSettingForOutgoingAuthent()) {
                transport.connect(outgoingHost, Integer.parseInt(outgoingPort), smtpUser, acc.getIncomingPassword());
            } else {
                transport.connect(outgoingHost, Integer.parseInt(outgoingPort), acc.getOutgoingUserName(), acc.getOutgoingPassword());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"#### Can not connect to smtp server ...");
            throw ex;
        }
        Message msg = this.send(session, transport, message);
        transport.close();
        return msg;
    }

    @Override
    public Message sendMessage(String userName, Message message) throws Exception {
        return this.sendMessage(userName, message.getAccountId(), message);
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        msgList.add(message);
        this.sendMessages(msgList, message.getServerConfiguration());
    }

    @Override
    public void sendMessages(List<Message> msgList, ServerConfiguration serverConfig) throws Exception {
        Properties props = System.getProperties();
        props.put(Utils.SVR_INCOMING_USERNAME, serverConfig.getUserName());
        props.put(Utils.SVR_INCOMING_PASSWORD, serverConfig.getPassword());
        props.put(Utils.SVR_SMTP_USER, serverConfig.getUserName());
        props.put(Utils.SVR_SMTP_HOST, serverConfig.getOutgoingHost());
        props.put(Utils.SVR_SMTP_PORT, serverConfig.getOutgoingPort());
        boolean isSMTPAuth = serverConfig.isOutgoingAuthentication();
        if (isSMTPAuth) {
            props.put(Utils.SVR_SMTP_AUTH, "true");
        } else {
            props.put(Utils.SVR_SMTP_AUTH, "false");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_PORT, serverConfig.getOutgoingPort());
        if (serverConfig.isOutgoingSsl()) {
            props.put(Utils.SVR_INCOMING_SSL, String.valueOf(serverConfig.isSsl()));
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        Session session = Session.getDefaultInstance((Properties)props, null);
        Transport transport = session.getTransport("smtp");
        try {
            if (!isSMTPAuth) {
                transport.connect();
            } else {
                transport.connect(serverConfig.getOutgoingHost(), serverConfig.getUserName(), serverConfig.getPassword());
            }
        }
        catch (Exception e) {
            try {
                transport.connect();
            }
            catch (Exception ex) {
                logger.debug((Object)"#### Can not connect to smtp server ...");
                return;
            }
        }
        logger.debug((Object)" #### Sending email ... ");
        int i = 0;
        for (Message msg : msgList) {
            msg.setServerConfiguration(serverConfig);
            try {
                this.send(session, transport, msg);
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)(" #### Info : send fail at message " + i + " \n"));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
            }
        }
        logger.debug((Object)(" #### Info : Sent " + i + " email(s)"));
        transport.close();
    }

    private Message send(Session session, Transport transport, Message message) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        mimeMessage.setHeader("Content-Transfer-Encoding", "utf-8");
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        if (message.getMessageCc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)message.getMessageCc(), (boolean)true));
        }
        if (message.getMessageBcc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)message.getMessageBcc(), (boolean)false));
        }
        if (message.getReplyTo() != null) {
            mimeMessage.setReplyTo((Address[])Utils.getInternetAddress(message.getReplyTo()));
        }
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(message.getSendDate());
        List<Attachment> attachList = message.getAttachments();
        if (attachList != null && attachList.size() > 0) {
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
                contentPartRoot.setContent((Object)message.getMessageBody(), "text/plain; charset=utf-8");
            } else {
                contentPartRoot.setContent((Object)message.getMessageBody(), "text/html; charset=utf-8");
            }
            MimeMultipart multipPartContent = new MimeMultipart("mixed");
            MimeBodyPart mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)message.getMessageBody(), message.getContentType());
            multipPartContent.addBodyPart((BodyPart)mimeBodyPart1);
            for (Attachment att : attachList) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                InputStream inputStream = att.getInputStream();
                String contentType = att.getMimeType();
                ByteArrayDataSource dataSource = new ByteArrayDataSource(inputStream, contentType);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                mimeBodyPart.setDisposition("attachment");
                String fileName = att.getName();
                if (fileName != null && fileName.length() > 0) {
                    mimeBodyPart.setFileName(MimeUtility.encodeText((String)fileName, (String)"utf-8", null));
                }
                multipPartContent.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)multipPartContent);
        } else if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/plain; charset=utf-8");
        } else {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/html; charset=utf-8");
        }
        if (message.isReturnReceipt()) {
            mimeMessage.setHeader("Disposition-Notification-To", message.getReplyTo());
        }
        mimeMessage.setHeader("X-Priority", String.valueOf(message.getPriority()));
        String priority = "Normal";
        if (message.getPriority() == 1L) {
            priority = "High";
        } else if (message.getPriority() == 5L) {
            priority = "Low";
        }
        if (message.getPriority() != 0L) {
            mimeMessage.setHeader("Importance", priority);
        }
        Iterator<String> iter = message.getHeaders().keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            mimeMessage.setHeader(key, message.getHeaders().get(key));
        }
        try {
            mimeMessage.saveChanges();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            transport.sendMessage((javax.mail.Message)mimeMessage, mimeMessage.getAllRecipients());
            message.setId(MimeMessageParser.getMessageId((javax.mail.Message)mimeMessage));
            Enumeration enu = mimeMessage.getAllHeaders();
            while (enu.hasMoreElements()) {
                Header header = (Header)enu.nextElement();
                message.setHeader(header.getName(), header.getValue());
            }
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry, There was an error sending the message. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
            throw e;
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
            throw e;
        }
        finally {
            logger.debug((Object)(" #### Info : " + status));
        }
        logger.debug((Object)(" #### Info : " + status));
        return message;
    }

    @Override
    public void checkMail(String userName, String accountId) throws Exception {
        JobDetail job = this.loadCheckmailJob(userName, accountId);
    }

    @Override
    public void checkMail(String userName, String accountId, String folderId) throws Exception {
        if (Utils.isEmptyField(folderId)) {
            this.checkMail(userName, accountId);
        } else {
            JobDetail job = this.loadCheckmailJob(userName, accountId, folderId);
        }
    }

    private void executeJob(JobDetail job) {
        if (job != null) {
            try {
                this.schedulerService_.executeJob(job.getName(), job.getGroup(), job.getJobDataMap());
            }
            catch (Exception e) {
                logger.error((Object)("Failed to execute job " + job.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void stopCheckMail(String userName, String accountId) {
        CheckingInfo checkingInfo = this.getCheckingInfo(userName, accountId);
        if (checkingInfo != null) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)(" user [ " + userName + " ] request to stop checking emails"));
            }
            checkingInfo.setRequestStop(true);
            this.updateCheckingMailStatusByCometd(userName, accountId, checkingInfo);
        }
    }

    @Override
    public void stopAllJobs(String userName, String accountId) throws Exception {
        JobInfo info = CheckMailJob.getJobInfo(userName, accountId);
        this.stopCheckMail(userName, accountId);
        this.schedulerService_.removeJob(info);
    }

    private JobDetail loadCheckmailJob(String userName, String accountId) throws Exception {
        return this.loadCheckmailJob(userName, accountId, "");
    }

    private JobDetail loadCheckmailJob(String userName, String accountId, String folderId) throws Exception {
        JobInfo info = CheckMailJob.getJobInfo(userName, accountId);
        JobDetail job = this.findCheckmailJob(userName, accountId);
        if (job == null) {
            JobDataMap jobData = new JobDataMap();
            jobData.put("userName", userName);
            jobData.put("acountId", accountId);
            if (folderId != null && folderId.length() > 0) {
                jobData.put("folderId", folderId);
            }
            PeriodInfo periodInfo = new PeriodInfo(null, null, 0, 86400000L);
            this.schedulerService_.addPeriodJob(info, periodInfo, jobData);
        } else {
            JobDetail activeJob = this.findActiveCheckmailJob(userName, accountId);
            JobDataMap jobData = new JobDataMap();
            jobData.put("userName", userName);
            jobData.put("acountId", accountId);
            if (folderId != null && folderId.length() > 0) {
                jobData.put("folderId", folderId);
            }
            job.setJobDataMap(jobData);
            if (activeJob == null) {
                this.executeJob(job);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("job [ " + job.getName() + " ] still exist. Can not start new job!"));
                }
                job = new JobDetail(info.getJobName(), info.getGroupName(), info.getJob());
            }
        }
        return job;
    }

    private JobDetail findActiveCheckmailJob(String userName, String accountId) throws Exception {
        List list = this.schedulerService_.getAllExcutingJobs();
        for (Object obj : list) {
            JobExecutionContext jec = (JobExecutionContext)obj;
            JobDetail tmp = jec.getJobDetail();
            if (!tmp.getName().equals(userName + ":" + accountId)) continue;
            return tmp;
        }
        return null;
    }

    private JobDetail findCheckmailJob(String userName, String accountId) throws Exception {
        List list = this.schedulerService_.getAllJobs();
        for (Object obj : list) {
            JobDetail tmp = (JobDetail)obj;
            if (!tmp.getName().equals(userName + ":" + accountId)) continue;
            return tmp;
        }
        return null;
    }

    private LinkedHashMap<javax.mail.Message, List<String>> getMessages(LinkedHashMap<javax.mail.Message, List<String>> msgMap, javax.mail.Folder folder, boolean isImap, Date fromDate, Date toDate, List<MessageFilter> filters) throws Exception {
        javax.mail.Message msg;
        javax.mail.Message[] messages;
        Object searchTerm = null;
        if (fromDate != null && toDate != null && fromDate.equals(toDate)) {
            return msgMap;
        }
        if (!folder.isOpen()) {
            folder.open(2);
        }
        if (fromDate == null && toDate == null) {
            messages = folder.getMessages();
        } else {
            searchTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            Object dateTerm = null;
            if (fromDate != null) {
                dateTerm = new SentDateTerm(5, fromDate);
            }
            if (toDate != null) {
                dateTerm = dateTerm != null ? new AndTerm((SearchTerm)dateTerm, (SearchTerm)new SentDateTerm(1, toDate)) : new SentDateTerm(1, toDate);
            }
            searchTerm = !isImap ? new OrTerm((SearchTerm)searchTerm, (SearchTerm)dateTerm) : dateTerm;
            messages = folder.search((SearchTerm)searchTerm);
        }
        boolean beforeTime = false;
        boolean betweenTime = false;
        int filteredMsgNumber = 0;
        int getFrom = 0;
        for (MessageFilter filter : filters) {
            int k;
            beforeTime = false;
            betweenTime = false;
            SearchTerm st = this.getSearchTerm((SearchTerm)searchTerm, filter);
            javax.mail.Message[] filteredMsg = folder.search(st);
            filteredMsgNumber = filteredMsg.length;
            if (filteredMsgNumber <= 0) continue;
            getFrom = 0;
            if (fromDate != null) {
                for (k = 0; k < filteredMsgNumber && MimeMessageParser.getReceivedDate(filteredMsg[k]).getTime().before(fromDate); ++k) {
                    ++getFrom;
                }
            }
            for (k = filteredMsgNumber - 1; k >= 0; --k) {
                msg = filteredMsg[k];
                List<Object> filterList = msgMap.containsKey(msg) ? msgMap.get(msg) : new ArrayList();
                if (filterList == null) {
                    filterList = new ArrayList();
                }
                if (!filterList.contains(filter.getId())) {
                    filterList.add(filter.getId());
                }
                if (fromDate != null && toDate != null) {
                    if (!betweenTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                    betweenTime = true;
                    if (!isImap || k > getFrom) {
                        msgMap.put(msg, filterList);
                        continue;
                    }
                    betweenTime = false;
                    continue;
                }
                if (fromDate != null) {
                    if (isImap && k <= getFrom) continue;
                    msgMap.put(msg, filterList);
                    continue;
                }
                if (toDate != null) {
                    if (!beforeTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                    beforeTime = true;
                    msgMap.put(msg, filterList);
                    continue;
                }
                msgMap.put(msg, filterList);
            }
        }
        if (messages.length > 0) {
            beforeTime = false;
            betweenTime = false;
            getFrom = 0;
            if (fromDate != null) {
                Date receivedDate;
                for (int l = 0; l < messages.length && ((receivedDate = MimeMessageParser.getReceivedDate(messages[l]).getTime()).before(fromDate) || receivedDate.equals(fromDate)); ++l) {
                    ++getFrom;
                }
            }
            for (int l = messages.length; l > 0; --l) {
                msg = messages[l - 1];
                if (!msgMap.containsKey(msg)) {
                    if (fromDate != null && toDate != null) {
                        if (!betweenTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                        betweenTime = true;
                        if (!isImap || l > getFrom) {
                            msgMap.put(msg, null);
                            continue;
                        }
                        betweenTime = false;
                        continue;
                    }
                    if (fromDate != null) {
                        if (isImap && l <= getFrom) continue;
                        msgMap.put(msg, null);
                        continue;
                    }
                    if (toDate != null) {
                        if (!beforeTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                        beforeTime = true;
                        msgMap.put(msg, null);
                        continue;
                    }
                    msgMap.put(msg, null);
                    continue;
                }
                List<String> temp = msgMap.get(msg);
                msgMap.remove(msg);
                msgMap.put(msg, temp);
            }
        }
        return msgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchImapFolders(String userName, String accountId) throws Exception {
        IMAPStore store = null;
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        try {
            Account account = this.getAccountById(userName, accountId);
            store = this.openIMAPConnection(userName, account, info);
            if (store != null) {
                String key = userName + ":" + accountId;
                if (info == null) {
                    info = new CheckingInfo();
                    this.checkingLog_.put(key, info);
                }
                info.setSyncFolderStatus(302);
                this.synchImapFolders(userName, accountId, null, store.getDefaultFolder().list());
                info.setSyncFolderStatus(302);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (store != null && store.isConnected()) {
                store.close();
            }
            if (info != null) {
                info.setSyncFolderStatus(302);
            }
        }
    }

    private List<javax.mail.Folder> synchImapFolders(String userName, String accountId, Folder parentFolder, javax.mail.Folder[] folders) throws Exception {
        ArrayList<javax.mail.Folder> folderList = new ArrayList<javax.mail.Folder>();
        ArrayList<String> serverFolderId = new ArrayList<String>();
        for (javax.mail.Folder fd : folders) {
            String folderName = fd.getName();
            if (parentFolder == null && (folderName.equalsIgnoreCase(Utils.FD_DRAFTS) || folderName.equalsIgnoreCase(Utils.FD_SENT) || folderName.equalsIgnoreCase(Utils.FD_SPAM)) || folderName.equalsIgnoreCase(Utils.FD_TRASH)) continue;
            int folderType = fd.getType();
            if (!folderName.equalsIgnoreCase(Utils.FD_INBOX)) {
                String folderId;
                block10: {
                    folderId = folderType != 2 ? Utils.generateFID(accountId, String.valueOf(((IMAPFolder)fd).getUIDValidity()), true) : Utils.escapeIllegalJcrChars(folderName);
                    serverFolderId.add(folderId);
                    Folder folder = this.storage_.getFolder(userName, accountId, folderId);
                    if (folder == null) {
                        folder = new Folder();
                        folder.setId(folderId);
                        folder.setName(folderName);
                        folder.setURLName(fd.getURLName().toString());
                        folder.setNumberOfUnreadMessage(0L);
                        folder.setTotalMessage(0L);
                        folder.setPersonalFolder(true);
                        folder.setType(folderType);
                        try {
                            if (parentFolder == null) {
                                this.storage_.saveFolder(userName, accountId, folder);
                                break block10;
                            }
                            this.storage_.saveFolder(userName, accountId, parentFolder.getId(), folder);
                        }
                        catch (Exception e) {
                            logger.warn((Object)e);
                        }
                    } else if (!folder.getName().equalsIgnoreCase(folderName)) {
                        folder.setName(folderName);
                        folder.setURLName(fd.getURLName().toString());
                        this.saveFolder(userName, accountId, folder, false);
                    }
                }
                folderList.add(fd);
                if (folderType != 2 && fd.list().length <= 0) continue;
                folderList.addAll(this.synchImapFolders(userName, accountId, this.getFolder(userName, accountId, folderId), fd.list()));
                continue;
            }
            Folder inbox = this.getFolder(userName, accountId, Utils.generateFID(accountId, Utils.FD_INBOX, false));
            inbox.setURLName(fd.getURLName().toString());
            this.saveFolder(userName, accountId, inbox, false);
        }
        List<Folder> localFolders = null;
        localFolders = parentFolder == null ? this.getFolders(userName, accountId, true) : this.getSubFolders(userName, accountId, parentFolder.getPath());
        if (localFolders != null) {
            for (Folder f : localFolders) {
                if (serverFolderId.contains(f.getId())) continue;
                this.deleteLocalFolder(userName, accountId, f.getId());
            }
        }
        return folderList;
    }

    public IMAPStore openIMAPConnection(String userName, Account account) {
        return this.openIMAPConnection(userName, account, null);
    }

    public IMAPStore openIMAPConnection(String userName, Account account, CheckingInfo info) {
        try {
            logger.debug((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
            Properties props = System.getProperties();
            props.setProperty("mail.mime.base64.ignoreerrors", "true");
            String socketFactoryClass = "javax.net.SocketFactory";
            if (account.isIncomingSsl()) {
                socketFactoryClass = Utils.SSL_FACTORY;
            }
            props.setProperty("mail.imap.socketFactory.fallback", "false");
            props.setProperty("mail.imap.socketFactory.class", socketFactoryClass);
            Session session = Session.getDefaultInstance((Properties)props, null);
            IMAPStore imapStore = (IMAPStore)session.getStore("imap");
            try {
                imapStore.connect(account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), account.getIncomingUser(), account.getIncomingPassword());
            }
            catch (AuthenticationFailedException e) {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    this.updateAccount(userName, account);
                    logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                    logger.error((Object)("Exception while connecting to server : " + e.getMessage()));
                }
                if (info != null) {
                    info.setStatusCode(103);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
                return null;
            }
            catch (MessagingException e) {
                logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
                return null;
            }
            catch (IllegalStateException e) {
                logger.error((Object)"Exception while connecting to server", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
                return null;
            }
            return imapStore;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception while connecting to server", (Throwable)ex);
            return null;
        }
    }

    public POP3Store openPOPConnection(String userName, Account account, CheckingInfo info) {
        try {
            logger.debug((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
            if (info != null) {
                info.setStatusCode(101);
                this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
            }
            Properties props = System.getProperties();
            props.setProperty("mail.mime.base64.ignoreerrors", "true");
            props.put("mail.pop3.host", account.getIncomingHost());
            props.put("mail.pop3.user", account.getIncomingUser());
            props.put("mail.pop3.port", account.getIncomingPort());
            props.put("mail.pop3.starttls.enable", "true");
            props.put("mail.pop3.auth", "true");
            props.put("mail.pop3.socketFactory.port", account.getIncomingPort());
            props.put("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.pop3.socketFactory.fallback", "false");
            Session session = Session.getDefaultInstance((Properties)props, null);
            POP3Store pop3Store = (POP3Store)session.getStore("pop3");
            try {
                pop3Store.connect(account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), account.getIncomingUser(), account.getIncomingPassword());
            }
            catch (AuthenticationFailedException e) {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    this.updateAccount(userName, account);
                    logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                    logger.error((Object)("Exception while connecting to server : " + e.getMessage()));
                }
                if (info != null) {
                    info.setStatusCode(103);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
                return null;
            }
            catch (MessagingException e) {
                e.printStackTrace();
                logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
                return null;
            }
            catch (Exception e) {
                logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                StringWriter sw = new StringWriter();
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(userName, account.getId(), info);
                }
                return null;
            }
            return pop3Store;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<Message> removeMessageFromJCR(String userName, String accountId, List<Message> msgListFromJcrFolder, List<String> msgIDListFromMailServer) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (Message message : msgListFromJcrFolder) {
            String id = message.getId();
            if (!msgIDListFromMailServer.contains(id)) {
                this.removeMessage(userName, accountId, message);
                continue;
            }
            msgList.add(message);
        }
        return msgList;
    }

    public void addMessageNotInJCR(String userName, String accountId, String folderId, javax.mail.Folder mailServerFolder) throws Exception {
        Map<String, javax.mail.Message> msgServerMap = this.getServerMessageMap(mailServerFolder);
        List<String> msgIDListFromJcrFolder = this.getMessageIDFromJcrFolder(userName, accountId, folderId);
        if (!mailServerFolder.isOpen()) {
            mailServerFolder.open(2);
        }
        Set<String> msgKeySet = msgServerMap.keySet();
        for (String msgID : msgKeySet) {
            if (msgIDListFromJcrFolder.contains(msgID)) continue;
            this.storage_.saveTotalMessage(userName, accountId, msgID, msgServerMap.get(msgID), null);
        }
    }

    public void addMessageNotInJCR(String userName, String accountId, String folderId, List<javax.mail.Message> messageList) throws Exception {
        HashMap<String, javax.mail.Message> msgServerMap = new HashMap<String, javax.mail.Message>();
        for (javax.mail.Message message : messageList) {
            MimeMessage mimeMessage = (MimeMessage)message;
            msgServerMap.put(mimeMessage.getMessageID(), message);
        }
        List<String> msgIDListFromJcrFolder = this.getMessageIDFromJcrFolder(userName, accountId, folderId);
        for (String msgID : msgIDListFromJcrFolder) {
            if (msgServerMap.containsKey(msgID)) continue;
            this.storage_.saveTotalMessage(userName, accountId, msgID, (javax.mail.Message)msgServerMap.get(msgID), null);
        }
    }

    public List<String> getMessageIDFromJcrFolder(String userName, String accountId, String folderId) throws Exception {
        List<Message> msgListFromJcrFolder = this.getMessagesByFolder(userName, accountId, folderId);
        ArrayList<String> msgIDListFromJcrFolder = new ArrayList<String>();
        for (Message message : msgListFromJcrFolder) {
            msgIDListFromJcrFolder.add(message.getId());
        }
        return msgIDListFromJcrFolder;
    }

    public List<String> getMessageIDFromServerMailFolder(String userName, String accountId, javax.mail.Folder mailServerFolder) throws Exception {
        javax.mail.Message[] msgListFromMailServer;
        ArrayList<String> msgIDListFromMailServer = new ArrayList<String>();
        if (!mailServerFolder.isOpen()) {
            mailServerFolder.open(1);
        }
        for (javax.mail.Message message : msgListFromMailServer = mailServerFolder.getMessages()) {
            MimeMessage mimeMessage = (MimeMessage)message;
            msgIDListFromMailServer.add(mimeMessage.getMessageID());
        }
        return msgIDListFromMailServer;
    }

    public List<String> getMessageIDFromServerMailFolder(List<javax.mail.Message> messageList) throws Exception {
        ArrayList<String> msgIDListFromMailServer = new ArrayList<String>();
        for (javax.mail.Message message : messageList) {
            MimeMessage mimeMessage = (MimeMessage)message;
            msgIDListFromMailServer.add(mimeMessage.getMessageID());
        }
        return msgIDListFromMailServer;
    }

    public Map<String, javax.mail.Message> getServerMessageMap(javax.mail.Folder mailServerFolder) throws Exception {
        HashMap<String, javax.mail.Message> map = null;
        if (!mailServerFolder.isOpen()) {
            mailServerFolder.open(2);
        }
        javax.mail.Message[] msgListFromMailServer = mailServerFolder.getMessages();
        map = new HashMap<String, javax.mail.Message>();
        for (javax.mail.Message message : msgListFromMailServer) {
            MimeMessage mimeMessage = (MimeMessage)message;
            map.put(mimeMessage.getMessageID(), message);
        }
        return map;
    }

    public Map<String, javax.mail.Message> getServerMessageMap(String userName, String accountId, List<javax.mail.Message> messageList) {
        HashMap<String, javax.mail.Message> map = null;
        try {
            map = new HashMap<String, javax.mail.Message>();
            for (javax.mail.Message message : messageList) {
                MimeMessage mimeMessage = (MimeMessage)message;
                map.put(mimeMessage.getMessageID(), message);
            }
        }
        catch (MessagingException e) {
            // empty catch block
        }
        return map;
    }

    public void mergeMessageBetweenJcrAndServerMail(IMAPStore store, String userName, String accountId, String folderId, CheckingInfo info) throws Exception {
        Folder jcrFolder = this.getFolder(userName, accountId, folderId);
        if (jcrFolder == null || Utils.isEmptyField(jcrFolder.getURLName())) {
            jcrFolder = this.getFolder(userName, accountId, Utils.generateFID(accountId, Utils.FD_INBOX, false));
        }
        String urlName = jcrFolder.getURLName();
        if (jcrFolder != null && !Utils.isEmptyField(urlName)) {
            URLName url = new URLName(urlName);
            javax.mail.Folder mailServerFolder = store.getFolder(url);
            if (!mailServerFolder.isOpen()) {
                mailServerFolder.open(2);
            }
            if (mailServerFolder != null) {
                this.synchImapMessage(userName, accountId, mailServerFolder, info);
                List<String> msgIDListFromMailServer = this.getMessageIDFromServerMailFolder(userName, accountId, mailServerFolder);
                List<Message> msgListFromJcrFolder = this.getMessagesByFolder(userName, accountId, folderId);
                msgListFromJcrFolder = this.removeMessageFromJCR(userName, accountId, msgListFromJcrFolder, msgIDListFromMailServer);
                this.addMessageNotInJCR(userName, accountId, folderId, mailServerFolder);
                Map<String, javax.mail.Message> map = this.getServerMessageMap(mailServerFolder);
                for (Message message : msgListFromJcrFolder) {
                    if (info.isRequestStop()) {
                        throw new CheckMailInteruptedException("stop checking mail while synchronizing between email server and database!");
                    }
                    String id = message.getId();
                    javax.mail.Message serverMessage = map.get(id);
                    message.setHasStar(serverMessage.isSet(Flags.Flag.FLAGGED));
                    message.setUnread(!serverMessage.isSet(Flags.Flag.SEEN));
                    IMAPFolder serverFolder = (IMAPFolder)mailServerFolder;
                    message.setUID(String.valueOf(serverFolder.getUID(serverMessage)));
                    this.storage_.saveMessage(userName, accountId, message, false);
                }
            }
        }
    }

    private CheckingInfo createCheckingInfo(String userName, String accountId) {
        String key = userName + ":" + accountId;
        CheckingInfo info = new CheckingInfo();
        this.checkingLog_.put(key, info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSynchnizeImapServer(String userName, String accountId, String folderId, boolean synchFolders) throws Exception {
        CheckingInfo info;
        block18: {
            info = null;
            info = this.getCheckingInfo(userName, accountId);
            if (info == null) {
                info = this.createCheckingInfo(userName, accountId);
            } else {
                info.resetValues();
            }
            info.setAccountId(accountId);
            info.setStatusCode(101);
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
            Account account = this.getAccountById(userName, accountId);
            IMAPStore store = this.openIMAPConnection(userName, account, info);
            if (info.isRequestStop()) {
                throw new CheckMailInteruptedException("stopped checking emails!");
            }
            try {
                if (store != null) {
                    List<javax.mail.Folder> folderList = null;
                    if (synchFolders) {
                        info.setSyncFolderStatus(301);
                        info.setStatusCode(301);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        folderList = this.synchImapFolders(userName, accountId, null, store.getDefaultFolder().list());
                        info.setSyncFolderStatus(302);
                        info.setStatusCode(302);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                    }
                    if (info.isRequestStop()) {
                        throw new CheckMailInteruptedException("stopped checking emails!");
                    }
                    if (!Utils.isEmptyField(folderId)) {
                        this.mergeMessageBetweenJcrAndServerMail(store, userName, accountId, folderId, info);
                    } else if (folderList != null && folderList.size() > 0) {
                        for (javax.mail.Folder folder : folderList) {
                            if (!Utils.isEmptyField(info.getRequestingForFolder_()) && !info.getRequestingForFolder_().equals("checkall")) break;
                            if (info != null && info.isRequestStop()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                                }
                                throw new CheckMailInteruptedException("Stop getting mails from folder " + folder.getName() + " !");
                            }
                            this.synchImapMessage(userName, accountId, folder, info);
                        }
                    }
                    logger.debug((Object)"/////////////////////////////////////////////////////////////");
                    logger.debug((Object)"/////////////////////////////////////////////////////////////");
                    break block18;
                }
                return;
            }
            finally {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
        }
        if (info != null) {
            if (info.getStatusCode() != 200) {
                info.setStatusCode(200);
            }
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
        }
    }

    private void synchImapMessage(String userName, String accountId, javax.mail.Folder folder, CheckingInfo info) throws Exception {
        String[] localFolders;
        Account account = this.getAccountById(userName, accountId);
        boolean saved = false;
        int totalNew = -1;
        Info infoObj = new Info();
        if (folder == null) {
            return;
        }
        String folderId = null;
        String folderName = folder.getName();
        if (!folder.isOpen()) {
            folder.open(1);
        }
        logger.debug((Object)(" #### Getting mails from folder " + folderName + " !"));
        if (info != null) {
            info.setStatusCode(150);
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
        }
        folderId = Utils.generateFID(accountId, String.valueOf(((IMAPFolder)folder).getUIDValidity()), true);
        for (String localFolder : localFolders = Utils.DEFAULT_FOLDERS) {
            if (!localFolder.equalsIgnoreCase(folderName)) continue;
            folderId = Utils.generateFID(accountId, localFolder, false);
        }
        Folder eXoFolder = this.getFolder(userName, accountId, folderId);
        if (eXoFolder != null) {
            boolean leaveOnserver;
            Date checkFromDate = eXoFolder.getCheckFromDate();
            if (account.getCheckFromDate() == null) {
                checkFromDate = null;
            } else if (checkFromDate == null || checkFromDate.before(account.getCheckFromDate())) {
                checkFromDate = account.getCheckFromDate();
            }
            boolean isImap = account.getProtocol().equals(Utils.IMAP);
            boolean bl = leaveOnserver = isImap && Boolean.valueOf(account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER)) != false;
            if (info.isRequestStop()) {
                throw new CheckMailInteruptedException("stopped checking emails!");
            }
            LinkedHashMap<javax.mail.Message, List<String>> msgMap = this.getMessageMap(userName, accountId, folder, null, checkFromDate, null);
            if (info.isRequestStop()) {
                throw new CheckMailInteruptedException("stopped checking emails!");
            }
            totalNew = msgMap.size();
            logger.debug((Object)(" #### Folder " + folderName + " contains " + totalNew + " messages !"));
            if (totalNew > 0) {
                int i = 0;
                Date lastFromDate = null;
                Date receivedDate = null;
                ArrayList<javax.mail.Message> msgList = new ArrayList<javax.mail.Message>(msgMap.keySet());
                SpamFilter spamFilter = this.getSpamFilter(userName, account.getId());
                info.setStatusCode(150);
                this.updateCheckingMailStatusByCometd(userName, accountId, info);
                while (i < totalNew) {
                    block23: {
                        if (info != null && info.isRequestStop()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                            }
                            throw new CheckMailInteruptedException("Stop getting mails from folder " + folder.getName() + " !");
                        }
                        if (info != null && !Utils.isEmptyField(info.getRequestingForFolder_()) && !String.valueOf(((IMAPFolder)folder).getUIDValidity()).equals(Utils.getFolderNameFromFolderId(info.getRequestingForFolder_())) || info == null) break;
                        String[] folderIds = new String[]{folderId};
                        javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                        int unreadMsgCount = folder.getUnreadMessageCount();
                        if (info != null) {
                            info.setFetching(i + 1);
                        }
                        List<String> filterList = msgMap.get(msg);
                        try {
                            ArrayList<String> folderList = new ArrayList<String>();
                            ArrayList<String> tagList = new ArrayList<String>();
                            if (filterList != null && filterList.size() > 0) {
                                for (int j = 0; j < filterList.size(); ++j) {
                                    MessageFilter filter = this.getFilterById(userName, accountId, filterList.get(j));
                                    folderList.add(filter.getApplyFolder());
                                    String tagId = filter.getApplyTag();
                                    if (tagId == null || tagId.trim().length() <= 0) continue;
                                    tagList.add(tagId);
                                }
                                folderIds = folderList.toArray(new String[0]);
                            }
                            String folderStr = "";
                            for (int k = 0; k < folderIds.length; ++k) {
                                folderStr = folderStr + folderIds[k] + ",";
                            }
                            infoObj.setFolders(folderStr);
                            long msgUID = ((IMAPFolder)folder).getUID(msg);
                            saved = this.storage_.saveMessage(userName, accountId, msgUID, msg, folderIds, tagList, spamFilter, infoObj, this.continuationService_, false);
                            if (saved && !leaveOnserver) {
                                msg.setFlag(Flags.Flag.DELETED, true);
                            }
                            receivedDate = MimeMessageParser.getReceivedDate(msg).getTime();
                            if (i == 0) {
                                lastFromDate = receivedDate;
                            }
                            eXoFolder.setLastCheckedDate(receivedDate);
                            if (i == totalNew - 1) {
                                eXoFolder.setCheckFromDate(lastFromDate);
                            }
                            if (lastFromDate == null || eXoFolder.getLastStartCheckingTime() != null && !eXoFolder.getLastStartCheckingTime().before(lastFromDate)) break block23;
                            eXoFolder.setLastStartCheckingTime(lastFromDate);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ++i;
                            continue;
                        }
                    }
                    ++i;
                }
                this.saveFolder(userName, accountId, eXoFolder, false);
            }
        }
    }

    private LinkedHashMap<javax.mail.Message, List<String>> getMessageMap(String userName, String accountId, javax.mail.Folder folder, Date lastCheckedDate, Date checkFromDate, Date lastCheckedFromDate) throws Exception {
        boolean isImap;
        LinkedHashMap<javax.mail.Message, List<String>> msgMap = new LinkedHashMap<javax.mail.Message, List<String>>();
        List<MessageFilter> filters = this.getFilters(userName, accountId);
        Account account = this.getAccountById(userName, accountId);
        boolean bl = isImap = account.getProtocol().equals(Utils.IMAP);
        if (checkFromDate == null) {
            if (lastCheckedDate != null && lastCheckedFromDate != null) {
                msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
                msgMap = this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters);
            } else {
                msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null ? this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, null, null, filters));
            }
        } else if (lastCheckedDate != null && lastCheckedFromDate != null) {
            msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
            msgMap = this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters);
        } else {
            msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null && lastCheckedDate.after(checkFromDate) ? this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, checkFromDate, null, filters));
        }
        return msgMap;
    }

    @Override
    public List<Message> checkNewMessage(String userName, String accountId) throws Exception {
        return this.checkNewMessage(userName, accountId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> checkNewMessage(String username, String accountId, String folderId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        ArrayList<Message> messageList = new ArrayList<Message>();
        if (account != null) {
            try {
                if (account.getProtocol().equals(Utils.POP3)) {
                    List<Message> list = this.checkPop3Server(username, accountId);
                    return list;
                }
                if (account.getProtocol().equals(Utils.IMAP)) {
                    boolean synchFolder = this.getFolders(username, accountId, true).size() <= 0;
                    this.getSynchnizeImapServer(username, accountId, folderId, synchFolder);
                }
            }
            catch (CheckMailInteruptedException cme) {
                CheckingInfo info = this.getCheckingInfo(username, accountId);
                info.setRequestStop(false);
                info.assignInterruptedStatus();
                this.updateCheckingMailStatusByCometd(username, accountId, info);
            }
            catch (MessagingException e) {
                CheckingInfo info = this.getCheckingInfo(username, accountId);
                if (info != null) {
                    info.setStatusCode(102);
                    this.updateCheckingMailStatusByCometd(username, accountId, info);
                }
            }
            finally {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    this.updateAccount(username, account);
                }
            }
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> checkPop3Server(String userName, String accountId) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        ArrayList<Message> messageList = new ArrayList<Message>();
        if (account != null) {
            CheckingInfo info;
            block34: {
                info = null;
                info = this.getCheckingInfo(userName, accountId);
                if (info == null) {
                    info = this.createCheckingInfo(userName, accountId);
                } else {
                    info.resetValues();
                }
                info.setAccountId(accountId);
                if (Utils.isEmptyField(account.getIncomingPassword())) {
                    info.setStatusCode(103);
                    this.updateCheckingMailStatusByCometd(userName, accountId, info);
                    return messageList;
                }
                logger.debug((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
                info.setStatusCode(101);
                this.updateCheckingMailStatusByCometd(userName, accountId, info);
                int totalNew = 0;
                boolean isImap = account.getProtocol().equals(Utils.IMAP);
                String incomingFolder = account.getIncomingFolder().trim();
                URLName storeURL = new URLName(account.getProtocol(), account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), incomingFolder, account.getIncomingUser(), account.getIncomingPassword());
                POP3Store store = this.openPOPConnection(userName, account, info);
                if (store == null) {
                    return messageList;
                }
                if (info.isRequestStop()) {
                    throw new CheckMailInteruptedException("stopped checking emails");
                }
                javax.mail.Folder folder = store.getFolder(storeURL.getFile());
                if (info.isRequestStop()) {
                    throw new CheckMailInteruptedException("stopped checking emails");
                }
                try {
                    if (!folder.exists()) {
                        logger.debug((Object)(" #### Folder " + incomingFolder + " is not exists !"));
                        info.setStatusCode(104);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        store.close();
                        ArrayList<Message> arrayList = messageList;
                        return arrayList;
                    }
                    logger.debug((Object)(" #### Getting mails from folder " + incomingFolder + " !"));
                    info.setStatusCode(150);
                    this.updateCheckingMailStatusByCometd(userName, accountId, info);
                    folder.open(2);
                    Date lastCheckedDate = account.getLastCheckedDate();
                    Date lastCheckedFromDate = account.getLastStartCheckingTime();
                    Date checkFromDate = account.getCheckFromDate();
                    List<MessageFilter> filters = this.getFilters(userName, accountId);
                    LinkedHashMap<javax.mail.Message, List<String>> msgMap = new LinkedHashMap<javax.mail.Message, List<String>>();
                    if (checkFromDate == null) {
                        if (lastCheckedDate != null && lastCheckedFromDate != null) {
                            msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
                            msgMap = this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters);
                        } else {
                            msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null ? this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, null, null, filters));
                        }
                    } else if (lastCheckedDate != null && lastCheckedFromDate != null) {
                        msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
                        msgMap = this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters);
                    } else {
                        msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null && lastCheckedDate.after(checkFromDate) ? this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, checkFromDate, null, filters));
                    }
                    if (info.isRequestStop()) {
                        throw new CheckMailInteruptedException("stopped checking emails");
                    }
                    totalNew = msgMap.size();
                    logger.debug((Object)"=============================================================");
                    logger.debug((Object)"=============================================================");
                    logger.debug((Object)(" #### Folder contains " + totalNew + " messages !"));
                    long tt1 = System.currentTimeMillis();
                    boolean saved = false;
                    if (totalNew > 0) {
                        boolean leaveOnServer = Boolean.valueOf(account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER));
                        info.setTotalMsg(totalNew);
                        int i = 0;
                        Date lastFromDate = null;
                        Date receivedDate = null;
                        ArrayList<javax.mail.Message> msgList = new ArrayList<javax.mail.Message>(msgMap.keySet());
                        SpamFilter spamFilter = this.getSpamFilter(userName, account.getId());
                        String folderId = this.makeStoreFolder(userName, accountId, incomingFolder);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        while (i < totalNew) {
                            long t1;
                            block33: {
                                if (info != null && info.isRequestStop()) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                                    }
                                    throw new CheckMailInteruptedException("Stop getting mails from folder " + folder.getName() + " !");
                                }
                                javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                                info.setFetching(i + 1);
                                logger.debug((Object)("Fetching message " + (i + 1) + " ..."));
                                t1 = System.currentTimeMillis();
                                List<String> filterList = msgMap.get(msg);
                                try {
                                    String[] folderIds = new String[]{folderId};
                                    ArrayList<String> folderList = new ArrayList<String>();
                                    ArrayList<String> tagList = new ArrayList<String>();
                                    if (filterList != null && filterList.size() > 0) {
                                        for (int j = 0; j < filterList.size(); ++j) {
                                            MessageFilter filter = this.getFilterById(userName, accountId, filterList.get(j));
                                            folderList.add(filter.getApplyFolder());
                                            String tagId = filter.getApplyTag();
                                            if (tagId == null || tagId.trim().length() <= 0) continue;
                                            tagList.add(tagId);
                                        }
                                        folderIds = folderList.toArray(new String[0]);
                                    }
                                    String folderStr = "";
                                    for (int k = 0; k < folderIds.length; ++k) {
                                        folderStr = folderStr + folderIds[k] + ",";
                                    }
                                    Info infoObj = new Info();
                                    infoObj.setFolders(folderStr);
                                    saved = this.storage_.savePOP3Message(userName, accountId, msg, folderIds, tagList, spamFilter, infoObj, this.continuationService_);
                                    if (saved) {
                                        msg.setFlag(Flags.Flag.SEEN, true);
                                        if (!leaveOnServer) {
                                            msg.setFlag(Flags.Flag.DELETED, true);
                                        }
                                        info.setFetchingToFolders(folderStr);
                                        info.setMsgId(MimeMessageParser.getMessageId(msg));
                                    }
                                    receivedDate = MimeMessageParser.getReceivedDate(msg).getTime();
                                    if (i == 0) {
                                        lastFromDate = receivedDate;
                                    }
                                    account.setLastCheckedDate(receivedDate);
                                    if (i == totalNew - 1) {
                                        account.setCheckFromDate(lastFromDate);
                                    }
                                    if (lastFromDate == null || account.getLastStartCheckingTime() != null && !account.getLastStartCheckingTime().before(lastFromDate)) break block33;
                                    account.setLastStartCheckingTime(lastFromDate);
                                }
                                catch (Exception e) {
                                    info.setStatusCode(104);
                                    this.updateCheckingMailStatusByCometd(userName, accountId, info);
                                    ++i;
                                    continue;
                                }
                            }
                            long t2 = System.currentTimeMillis();
                            logger.debug((Object)("Message " + ++i + " saved : " + (t2 - t1) + " ms"));
                        }
                        long tt2 = System.currentTimeMillis();
                        logger.debug((Object)(" ### Check mail finished total took: " + (tt2 - tt1) + " ms"));
                        break block34;
                    }
                    if (info != null) {
                        info.setStatusCode(200);
                        this.updateCheckingMailStatusByCometd(userName, accountId, info);
                        ArrayList<Message> arrayList = messageList;
                        return arrayList;
                    }
                }
                finally {
                    folder.close(true);
                    store.close();
                }
            }
            info.setStatusCode(200);
            this.updateCheckingMailStatusByCometd(userName, accountId, info);
            logger.debug((Object)"/////////////////////////////////////////////////////////////");
            logger.debug((Object)"/////////////////////////////////////////////////////////////");
        }
        return messageList;
    }

    private String makeStoreFolder(String userName, String accountId, String incomingFolder) throws Exception {
        String folderId = Utils.generateFID(accountId, incomingFolder, false);
        Folder storeFolder = this.storage_.getFolder(userName, accountId, folderId);
        if (storeFolder == null) {
            folderId = Utils.generateFID(accountId, incomingFolder, true);
            Folder storeUserFolder = this.storage_.getFolder(userName, accountId, folderId);
            storeFolder = storeUserFolder != null ? storeUserFolder : new Folder();
            storeFolder.setId(folderId);
            storeFolder.setName(incomingFolder);
            storeFolder.setPersonalFolder(true);
            this.storage_.saveFolder(userName, accountId, storeFolder);
        }
        return folderId;
    }

    public SearchTerm getSearchTerm(SearchTerm sTerm, MessageFilter filter) throws Exception {
        if (!Utils.isEmptyField(filter.getFrom())) {
            FromStringTerm fsTerm = new FromStringTerm(filter.getFrom());
            if (filter.getFromCondition() == 0) {
                sTerm = sTerm == null ? fsTerm : new AndTerm(sTerm, (SearchTerm)fsTerm);
            } else if (filter.getFromCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)fsTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)fsTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getTo())) {
            RecipientStringTerm toTerm = new RecipientStringTerm(MimeMessage.RecipientType.TO, filter.getTo());
            if (filter.getToCondition() == 0) {
                sTerm = sTerm == null ? toTerm : new AndTerm(sTerm, (SearchTerm)toTerm);
            } else if (filter.getToCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)toTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)toTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getSubject())) {
            SubjectTerm subjectTerm = new SubjectTerm(filter.getSubject());
            if (filter.getSubjectCondition() == 0) {
                sTerm = sTerm == null ? subjectTerm : new AndTerm(sTerm, (SearchTerm)subjectTerm);
            } else if (filter.getSubjectCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)subjectTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)subjectTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getBody())) {
            BodyTerm bodyTerm = new BodyTerm(filter.getBody());
            if (filter.getBodyCondition() == 0) {
                sTerm = sTerm == null ? bodyTerm : new AndTerm(sTerm, (SearchTerm)bodyTerm);
            } else if (filter.getBodyCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)bodyTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)bodyTerm));
            }
        }
        return sTerm;
    }

    @Override
    public void createAccount(String userName, Account account) throws Exception {
        this.saveAccount(userName, account, true);
    }

    @Override
    public List<Folder> getFolders(String userName, String accountId) throws Exception {
        return this.storage_.getFolders(userName, accountId);
    }

    @Override
    public List<Folder> getFolders(String userName, String accountId, boolean isPersonal) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        List<Folder> gottenFolderList = this.storage_.getFolders(userName, accountId);
        Account account = this.getAccountById(userName, accountId);
        CheckingInfo info = this.getCheckingInfo(userName, accountId);
        POP3Store store = null;
        ArrayList<Folder> defaultFolders = new ArrayList<Folder>();
        for (Folder folder : gottenFolderList) {
            if (isPersonal) {
                if (!folder.isPersonalFolder()) continue;
                folders.add(folder);
                continue;
            }
            defaultFolders.add(folder);
        }
        if (info != null) {
            if (account.getProtocol().equals(Utils.POP3)) {
                store = this.openPOPConnection(userName, account, info);
            } else if (account.getProtocol().equals(Utils.IMAP)) {
                store = this.openIMAPConnection(userName, account, info);
            }
            for (Folder folder : defaultFolders) {
                String urlName = folder.getURLName();
                if (folder.isPersonalFolder()) continue;
                if (Utils.isEmptyField(urlName) && store != null) {
                    javax.mail.Folder fd = store.getFolder(folder.getName());
                    folder.setURLName(fd.getURLName().toString());
                    this.storage_.saveFolder(userName, accountId, folder);
                }
                folders.add(folder);
            }
        } else {
            for (Folder folder : defaultFolders) {
                if (folder.isPersonalFolder()) continue;
                folders.add(folder);
            }
        }
        return folders;
    }

    public List<Folder> getFolders_DUYROOT(String username, String accountId, boolean isPersonal) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        List<Folder> gottenFolderList = this.storage_.getFolders(username, accountId);
        Account account = this.getAccountById(username, accountId);
        CheckingInfo info = new CheckingInfo();
        String key = username + ":" + accountId;
        this.checkingLog_.put(key, info);
        POP3Store store = null;
        for (Folder folder : gottenFolderList) {
            String urlName = folder.getURLName();
            if (isPersonal) {
                if (!folder.isPersonalFolder()) continue;
                folders.add(folder);
                continue;
            }
            if (folder.isPersonalFolder()) continue;
            if (Utils.isEmptyField(urlName)) {
                if (account.getProtocol().equals(Utils.POP3)) {
                    store = this.openPOPConnection(username, account, info);
                } else if (account.getProtocol().equals(Utils.IMAP)) {
                    store = this.openIMAPConnection(username, account, info);
                }
                javax.mail.Folder fd = store.getFolder(folder.getName());
                folder.setURLName(fd.getURLName().toString());
                this.storage_.saveFolder(username, accountId, folder);
            }
            folders.add(folder);
        }
        return folders;
    }

    @Override
    public void addTag(String userName, String accountId, Tag tag) throws Exception {
        this.storage_.addTag(userName, accountId, tag);
    }

    @Override
    public void addTag(String userName, String accountId, List<Message> messages, List<Tag> tag) throws Exception {
        this.storage_.addTag(userName, accountId, messages, tag);
    }

    @Override
    public List<Tag> getTags(String userName, String accountId) throws Exception {
        return this.storage_.getTags(userName, accountId);
    }

    @Override
    public Tag getTag(String userName, String accountId, String tagId) throws Exception {
        return this.storage_.getTag(userName, accountId, tagId);
    }

    @Override
    public void removeTagsInMessages(String userName, String accountId, List<Message> msgList, List<String> tagIdList) throws Exception {
        this.storage_.removeTagsInMessages(userName, accountId, msgList, tagIdList);
    }

    @Override
    public void removeTag(String userName, String accountId, String tag) throws Exception {
        this.storage_.removeTag(userName, accountId, tag);
    }

    @Override
    public void updateTag(String userName, String accountId, Tag tag) throws Exception {
        this.storage_.updateTag(userName, accountId, tag);
    }

    @Override
    public List<Message> getMessageByTag(String userName, String accountId, String tagName) throws Exception {
        return this.storage_.getMessageByTag(userName, accountId, tagName);
    }

    @Override
    public MessagePageList getMessagePagelistByTag(String userName, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Tag");
        filter.setAccountId(accountId);
        filter.setTag(new String[]{tagId});
        return this.getMessagePageList(userName, filter);
    }

    @Override
    public MessagePageList getMessagePageListByFolder(String userName, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        return this.getMessagePageList(userName, filter);
    }

    @Override
    public MailSetting getMailSetting(String userName) throws Exception {
        return this.storage_.getMailSetting(userName);
    }

    @Override
    public void saveMailSetting(String userName, MailSetting newSetting) throws Exception {
        this.storage_.saveMailSetting(userName, newSetting);
    }

    @Override
    public boolean importMessage(String userName, String accountId, String folderId, InputStream inputStream, String type) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mimeMessage = new MimeMessage(session, inputStream);
        long[] msgUID = new long[]{0L};
        boolean result = false;
        try {
            msgUID = this.importMessageIntoServerMail(userName, accountId, folderId, mimeMessage);
            this.emlImportExport_.importMessage(userName, accountId, folderId, mimeMessage, msgUID);
            result = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    private long[] importMessageIntoServerMail(String userName, String accountId, String folderId, MimeMessage mimeMessage) throws Exception {
        IMAPFolder remoteFolder = null;
        long[] uid = new long[]{0L};
        try {
            remoteFolder = this.getIMAPFolder(userName, accountId, folderId);
            if (remoteFolder != null) {
                if (!remoteFolder.isOpen()) {
                    remoteFolder.open(2);
                }
                javax.mail.Message[] messages = new javax.mail.Message[]{mimeMessage};
                javax.mail.Message[] updatedMsgs = remoteFolder.addMessages(messages);
                uid[0] = remoteFolder.getUIDNext();
                remoteFolder.close(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in importing message into remote folder", (Throwable)e);
        }
        return uid;
    }

    private boolean importMessageIntoServerMail(String userName, String accountId, String folderId, MimeMessage mimeMessage, long[] msgUID) throws Exception {
        boolean result = false;
        try {
            IMAPFolder remoteFolder = this.getIMAPFolder(userName, accountId, folderId);
            if (remoteFolder != null) {
                if (!remoteFolder.isOpen()) {
                    remoteFolder.open(2);
                }
                javax.mail.Message[] messages = new javax.mail.Message[]{mimeMessage};
                javax.mail.Message[] updatedMsgs = remoteFolder.addMessages(messages);
                msgUID[0] = remoteFolder.getUIDNext();
                if (updatedMsgs.length == 1) {
                    result = true;
                }
                remoteFolder.close(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in importing message into remote folder", (Throwable)e);
        }
        return result;
    }

    private IMAPFolder getIMAPFolder(String userName, String accountId, String folderId) throws Exception {
        Folder folder = this.getFolder(userName, accountId, folderId);
        Account account = this.getAccountById(userName, accountId);
        IMAPStore store = this.openIMAPConnection(userName, account);
        URLName remoteURL = new URLName(folder.getURLName());
        IMAPFolder remoteFolder = null;
        if (store != null) {
            remoteFolder = (IMAPFolder)store.getFolder(remoteURL);
        }
        return remoteFolder;
    }

    @Override
    public OutputStream exportMessage(String userName, String accountId, Message message) throws Exception {
        return this.emlImportExport_.exportMessage(userName, accountId, message);
    }

    @Override
    public SpamFilter getSpamFilter(String userName, String accountId) throws Exception {
        return this.storage_.getSpamFilter(userName, accountId);
    }

    @Override
    public void saveSpamFilter(String userName, String accountId, SpamFilter spamFilter) throws Exception {
        this.storage_.saveSpamFilter(userName, accountId, spamFilter);
    }

    @Override
    public void toggleMessageProperty(String userName, String accountId, List<Message> msgList, String folderId, String property, boolean value) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        Folder folder = this.getFolder(userName, accountId, folderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                if (property.equals(Utils.EXO_STAR)) {
                    if (folder != null && !Utils.isEmptyField(folder.getName())) {
                        success = connector.setIsStared(msgList, value, folder);
                    } else {
                        ArrayList<Message> l = new ArrayList<Message>();
                        for (Message m : msgList) {
                            folder = this.getFolder(userName, accountId, m.getFolders()[0]);
                            if (folder == null) continue;
                            l.add(m);
                            success = connector.setIsStared(l, value, folder);
                        }
                    }
                } else if (property.equals(Utils.EXO_ISUNREAD)) {
                    if (folder != null && !Utils.isEmptyField(folder.getName())) {
                        success = value ? connector.markAsUnread(msgList, folder) : connector.markAsRead(msgList, folder);
                    } else {
                        for (Message m : msgList) {
                            folder = this.getFolder(userName, accountId, m.getFolders()[0]);
                            if (folder == null) continue;
                            ArrayList<Message> l = new ArrayList<Message>();
                            l.add(m);
                            if (value) {
                                success = connector.markAsUnread(l, folder);
                                continue;
                            }
                            success = connector.markAsRead(l, folder);
                        }
                    }
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.toggleMessageProperty(userName, accountId, msgList, property, value);
        }
    }

    public List<AccountData> getAccountDatas(SessionProvider sProvider) throws Exception {
        return null;
    }

    @Override
    public String getFolderHomePath(String userName, String accountId) throws Exception {
        return this.storage_.getFolderHomePath(userName, accountId);
    }

    @Override
    public List<Folder> getSubFolders(String userName, String accountId, String parentPath) throws Exception {
        return this.storage_.getSubFolders(userName, accountId, parentPath);
    }

    @Override
    public List<Message> getReferencedMessages(String userName, String accountId, String msgPath) throws Exception {
        return this.storage_.getReferencedMessages(userName, accountId, msgPath);
    }

    @Override
    public Account getDefaultAccount(String userName) throws Exception {
        MailSetting mailSetting = this.storage_.getMailSetting(userName);
        String defaultAccount = mailSetting.getDefaultAccount();
        Account account = null;
        if (defaultAccount != null) {
            account = this.getAccountById(userName, defaultAccount);
        } else {
            List<Account> accList = this.getAccounts(userName);
            if (accList.size() > 0) {
                account = this.getAccounts(userName).get(0);
            }
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message loadTotalMessage(String userName, String accountId, Message msg) throws Exception {
        Account account = this.getAccountById(userName, accountId);
        IMAPStore store = null;
        javax.mail.Folder fd = null;
        try {
            if (account.getProtocol().equals(Utils.IMAP)) {
                store = this.openIMAPConnection(userName, account);
                if (store != null) {
                    javax.mail.Message message = null;
                    URLName url = new URLName(this.getFolder(userName, accountId, msg.getFolders()[0]).getURLName());
                    fd = store.getFolder(url);
                    if (fd != null) {
                        if (!fd.isOpen()) {
                            fd.open(2);
                        }
                        message = ((IMAPFolder)fd).getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                        msg = this.storage_.loadTotalMessage(userName, accountId, msg, message);
                    }
                }
            } else if (account.getProtocol().equals(Utils.POP3)) {
                CheckingInfo info = this.getCheckingInfo(userName, accountId);
                store = this.openPOPConnection(userName, account, info);
                msg = this.storage_.loadTotalMessage(userName, accountId, msg);
            }
        }
        catch (Exception e) {
            try {
                msg = this.storage_.loadTotalMessage(userName, accountId, msg, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            logger.info((Object)"Download content failure");
        }
        finally {
            if (store != null && store.isConnected()) {
                store.close();
            }
            if (fd != null && fd.isOpen()) {
                fd.close(true);
            }
        }
        return msg;
    }

    public void start() {
        for (MailUpdateStorageEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof MailUpdateStorageEventListener) {
            this.listeners_.add((MailUpdateStorageEventListener)listener);
        }
    }

    private Properties getAccountProperties(Account acc) {
        Properties props = System.getProperties();
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        String isSSl = acc.getServerProperties().get(Utils.SVR_OUTGOING_SSL);
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        props.put(Utils.SVR_SMTP_HOST, outgoingHost);
        props.put(Utils.SVR_SMTP_PORT, outgoingPort);
        props.put("mail.smtp.dsn.notify", "SUCCESS,FAILURE ORCPT=rfc822;" + acc.getEmailAddress());
        props.put("mail.smtp.dsn.ret", "FULL");
        props.put("mail.smtp.socketFactory.port", outgoingPort);
        props.put(Utils.SVR_SMTP_AUTH, "true");
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "true");
        props.put("mail.smtp.connectiontimeout", "0");
        props.put("mail.smtp.timeout", "0");
        String socketFactoryClass = "javax.net.SocketFactory";
        if (Boolean.valueOf(isSSl).booleanValue()) {
            socketFactoryClass = Utils.SSL_FACTORY;
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, socketFactoryClass);
        return props;
    }

    @Override
    public boolean sendReturnReceipt(String userName, String accId, String msgId, ResourceBundle res) throws Exception {
        Account acc = this.getAccountById(userName, accId);
        Message msg = this.getMessageById(userName, accId, msgId);
        String subject = new String("Disposition notification");
        String text = new String("The message sent on {0} to {1} with subject \"{2}\" has been displayed. This is no guarantee that the message has been read or understood.");
        if (res != null) {
            try {
                subject = res.getString("UIMessagePreview.msg.return-receipt-subject");
            }
            catch (MissingResourceException e) {
                subject = new String("Disposition notification");
            }
            try {
                text = res.getString("UIMessagePreview.msg.return-receipt-text");
            }
            catch (MissingResourceException e) {
                text = new String("The message sent on {0} to {1} with subject \"{2}\" has been displayed. This is no guarantee that the message has been read or understood.");
            }
        }
        text = text.replace("{0}", msg.getSendDate().toString());
        text = text.replace("{1}", msg.getMessageTo());
        text = text.replace("{2}", msg.getSubject());
        Message receiptMsg = new Message();
        receiptMsg.setMessageTo(msg.getFrom());
        receiptMsg.setSubject(subject);
        receiptMsg.setSendDate(new Date());
        DispositionNotification disNotification = new DispositionNotification();
        disNotification.getNotifications().setHeader("Reporting-UA", "cs.exoplatform.com; CS-Mail");
        disNotification.getNotifications().setHeader("MDN-Gateway", "smtp; " + acc.getOutgoingHost());
        disNotification.getNotifications().setHeader("Original-Recipient", "rfc822; " + msg.getFrom());
        disNotification.getNotifications().setHeader("Final-Recipient", "rfc822; " + acc.getUserDisplayName() + "<" + acc.getEmailAddress() + ">");
        disNotification.getNotifications().setHeader("Original-Message-ID", msg.getId());
        disNotification.getNotifications().setHeader("Disposition", "manual-action/MDN-sent-automatically; displayed");
        MultipartReport report = new MultipartReport(text, disNotification);
        Properties props = this.getAccountProperties(acc);
        Session session = Session.getDefaultInstance((Properties)props, null);
        logger.debug((Object)" #### Sending email ... ");
        SMTPTransport transport = (SMTPTransport)session.getTransport("smtp");
        try {
            if (!acc.isOutgoingAuthentication()) {
                transport.connect();
            } else if (acc.useIncomingSettingForOutgoingAuthent()) {
                transport.connect(acc.getOutgoingHost(), Integer.parseInt(acc.getOutgoingPort()), acc.getIncomingUser(), acc.getIncomingPassword());
            } else {
                transport.connect(acc.getOutgoingHost(), Integer.parseInt(acc.getOutgoingPort()), acc.getOutgoingUserName(), acc.getOutgoingPassword());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"#### Can not connect to smtp server ...");
            throw ex;
        }
        MailcapCommandMap mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcap.addMailcap("message/disposition-notification;; x-java-content-handler=org.exoplatform.mail.service.impl.Message_DispositionNotification");
        CommandMap.setDefaultCommandMap((CommandMap)mailcap);
        this.sendReturnReceipt(session, (Transport)transport, receiptMsg, report);
        transport.close();
        return true;
    }

    private void sendReturnReceipt(Session session, Transport transport, Message message, MultipartReport report) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        mimeMessage.setHeader("Content-Transfer-Encoding", "utf-8");
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(message.getSendDate());
        mimeMessage.setContent((Multipart)report);
        mimeMessage.saveChanges();
        try {
            transport.sendMessage((javax.mail.Message)mimeMessage, mimeMessage.getAllRecipients());
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry, There was an error sending the message. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
            throw e;
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
            throw e;
        }
        logger.debug((Object)(" #### Info : " + status));
    }

    @Override
    public ContinuationService getContinuationService() {
        return this.continuationService_;
    }

    @Override
    public void setContinuationService(ContinuationService continuationService) {
        this.continuationService_ = continuationService;
    }

    @Override
    public void updateCheckingMailStatusByCometd(String userName, String accountId, CheckingInfo info) {
        block4: {
            if (info != null && info.hasChanged()) {
                try {
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    JsonValue json = generatorImpl.createJsonObject((Object)info.getStatus());
                    this.continuationService_.sendMessage(userName, "/eXo/Application/mail/ckmailsts/" + accountId, (Object)json);
                    info.setHasChanged(false);
                }
                catch (JsonException je) {
                    logger.warn((Object)("can not send cometd message to client [ " + userName + " ]!"), (Throwable)je);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("n\n can not send update message to UI " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public BufferAttachment getAttachmentFromDMS(String userName, String relPath) throws Exception {
        return this.storage_.getAttachmentFromDMS(userName, relPath);
    }

    @Override
    public String[] getDMSDataInfo(String userName) throws Exception {
        return this.storage_.getDMSDataInfo(userName);
    }

    @Override
    public Node getDMSSelectedNode(String userName, String relPath) throws Exception {
        return this.storage_.getDMSSelectedNode(userName, relPath);
    }

    class CheckMailInteruptedException
    extends Exception {
        private String message;

        public CheckMailInteruptedException(String msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

