/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.connector.fckeditor.FCKFileHandler;
import org.exoplatform.ecm.connector.fckeditor.FCKFolderHandler;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.FileUploadHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseConnector {
    protected FCKFolderHandler folderHandler;
    protected FCKFileHandler fileHandler;
    protected FileUploadHandler fileUploadHandler;
    protected RepositoryService repositoryService;
    private static Log log = ExoLogger.getLogger(BaseConnector.class);
    protected VotingService votingService;
    protected LinkManager linkManager;
    protected LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
    protected WebSchemaConfigService webSchemaConfigService;

    protected abstract Node getRootContentStorage(Node var1) throws Exception;

    protected abstract String getContentStorageType() throws Exception;

    public BaseConnector() {
        this.repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        this.webSchemaConfigService = (WebSchemaConfigService)WCMCoreUtils.getService(WebSchemaConfigService.class);
        this.votingService = (VotingService)WCMCoreUtils.getService(VotingService.class);
        this.linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.folderHandler = new FCKFolderHandler(container);
        this.fileHandler = new FCKFileHandler(container);
        this.fileUploadHandler = new FileUploadHandler();
    }

    protected Response buildXMLResponseOnExpand(String currentFolder, String runningPortal, String workspaceName, String repositoryName, String jcrPath, String command) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node sharedPortalNode = this.livePortalManagerService.getLiveSharedPortal(sessionProvider, repositoryName);
        Node activePortalNode = this.getCurrentPortalNode(repositoryName, jcrPath, runningPortal, sharedPortalNode);
        if (currentFolder.length() == 0 || "/".equals(currentFolder)) {
            return this.buildXMLResponseForRoot(activePortalNode, sharedPortalNode, command);
        }
        String currentPortalRelPath = "/" + activePortalNode.getName() + "/";
        String sharePortalRelPath = "/" + sharedPortalNode.getName() + "/";
        Node webContent = this.getWebContent(repositoryName, workspaceName, jcrPath);
        if (!activePortalNode.getPath().equals(sharedPortalNode.getPath()) && currentFolder.startsWith(sharePortalRelPath)) {
            if (currentFolder.equals(sharePortalRelPath)) {
                return this.buildXMLResponseForPortal(sharedPortalNode, null, command);
            }
            Node currentContentStorageNode = this.getCorrectContentStorage(sharedPortalNode, null, currentFolder);
            return this.buildXMLResponseForContentStorage(currentContentStorageNode, command);
        }
        if (!activePortalNode.getPath().equals(sharedPortalNode.getPath()) && currentFolder.startsWith(currentPortalRelPath)) {
            return this.buildXMLResponseCommon(activePortalNode, webContent, currentFolder, command);
        }
        return this.buildXMLResponseCommon(sharedPortalNode, webContent, currentFolder, command);
    }

    protected Response buildXMLResponseCommon(Node activePortal, Node webContent, String currentFolder, String command) throws Exception {
        String webContentRelPath;
        String activePortalRelPath = "/" + activePortal.getName() + "/";
        if (currentFolder.equals(activePortalRelPath)) {
            return this.buildXMLResponseForPortal(activePortal, webContent, command);
        }
        if (webContent != null && currentFolder.startsWith(webContentRelPath = activePortalRelPath + webContent.getName() + "/")) {
            if (currentFolder.equals(webContentRelPath)) {
                return this.buildXMLResponseForPortal(webContent, null, command);
            }
            Node contentStorageOfWebContent = this.getCorrectContentStorage(activePortal, webContent, currentFolder);
            return this.buildXMLResponseForContentStorage(contentStorageOfWebContent, command);
        }
        Node correctContentStorage = this.getCorrectContentStorage(activePortal, null, currentFolder);
        return this.buildXMLResponseForContentStorage(correctContentStorage, command);
    }

    protected Response buildXMLResponseForRoot(Node currentPortal, Node sharedPortal, String command) throws Exception {
        Document document = null;
        Node rootNode = currentPortal.getSession().getRootNode();
        Element rootElement = FCKUtils.createRootElement(command, rootNode, rootNode.getPrimaryNodeType().getName());
        document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Folders");
        Element files = document.createElement("Files");
        Element sharedPortalElement = null;
        Element currentPortalElement = null;
        if (sharedPortal != null) {
            sharedPortalElement = this.folderHandler.createFolderElement(document, sharedPortal, sharedPortal.getPrimaryNodeType().getName());
            folders.appendChild(sharedPortalElement);
        }
        if (currentPortal != null && !currentPortal.getPath().equals(sharedPortal.getPath())) {
            currentPortalElement = this.folderHandler.createFolderElement(document, currentPortal, currentPortal.getPrimaryNodeType().getName());
            folders.appendChild(currentPortalElement);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    protected Response buildXMLResponseForPortal(Node node, Node webContent, String command) throws Exception {
        Node storageNode = this.getRootContentStorage(node);
        Element rootElement = FCKUtils.createRootElement(command, node, this.folderHandler.getFolderType(node));
        Document document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Folders");
        Element files = document.createElement("Files");
        Element storageElement = this.folderHandler.createFolderElement(document, storageNode, storageNode.getPrimaryNodeType().getName());
        folders.appendChild(storageElement);
        Element webContentElement = null;
        if (webContent != null) {
            webContentElement = this.folderHandler.createFolderElement(document, webContent, webContent.getPrimaryNodeType().getName());
            folders.appendChild(webContentElement);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    protected Response buildXMLResponseForContentStorage(Node node, String command) throws Exception {
        Element rootElement = FCKUtils.createRootElement(command, node, this.folderHandler.getFolderType(node));
        Document document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Foders");
        Element files = document.createElement("Files");
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            String sourceType;
            String fileType;
            Node child = iterator.nextNode();
            if (child.isNodeType(FCKUtils.EXO_HIDDENABLE)) continue;
            String folderType = this.folderHandler.getFolderType(child);
            if (folderType != null) {
                Element folder = this.folderHandler.createFolderElement(document, child, folderType);
                folders.appendChild(folder);
            }
            if ((fileType = this.fileHandler.getFileType(child, sourceType = this.getContentStorageType())) == null) continue;
            Element file = this.fileHandler.createFileElement(document, child, fileType);
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    protected Node getCorrectContentStorage(Node activePortal, Node webContent, String currentFolder) throws Exception {
        if (currentFolder == null || currentFolder.trim().length() == 0) {
            return null;
        }
        Node rootContentStorage = null;
        String rootContentStorageRelPath = null;
        if (activePortal != null && webContent == null) {
            rootContentStorage = this.getRootContentStorage(activePortal);
            rootContentStorageRelPath = "/" + activePortal.getName() + "/" + rootContentStorage.getName() + "/";
        } else if (activePortal != null && webContent != null) {
            rootContentStorage = this.getRootContentStorage(webContent);
            rootContentStorageRelPath = "/" + activePortal.getName() + "/" + webContent.getName() + "/" + rootContentStorage.getName() + "/";
        }
        if (currentFolder.equals(rootContentStorageRelPath)) {
            return rootContentStorage;
        }
        try {
            String correctStorageRelPath = currentFolder.replace(rootContentStorageRelPath, "");
            correctStorageRelPath = correctStorageRelPath.substring(0, correctStorageRelPath.length() - 1);
            return rootContentStorage.getNode(correctStorageRelPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Response getResponse(Document document) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
    }

    protected Node getContent(String repositoryName, String workspaceName, String jcrPath, String NodeTypeFilter, boolean isSystemSession) throws Exception {
        if (jcrPath == null || jcrPath.trim().length() == 0) {
            return null;
        }
        try {
            SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
            ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
            Session session = sessionProvider.getSession(workspaceName, repository);
            Node content = (Node)session.getItem(jcrPath);
            if (content.isNodeType("exo:taxonomyLink")) {
                content = this.linkManager.getTarget(content);
            }
            if (NodeTypeFilter == null || NodeTypeFilter != null && content.isNodeType(NodeTypeFilter)) {
                return content;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getContent: ", (Throwable)e);
        }
        return null;
    }

    protected Node getContent(String repositoryName, String workspaceName, String jcrPath) throws Exception {
        return this.getContent(repositoryName, workspaceName, jcrPath, null, true);
    }

    protected Node getWebContent(String repositoryName, String workspaceName, String jcrPath) throws Exception {
        return this.getContent(repositoryName, workspaceName, jcrPath, "exo:webContent", true);
    }

    protected Node getCurrentPortalNode(String repositoryName, String jcrPath, String runningPortal, Node sharedPortal) throws Exception {
        if (jcrPath == null || jcrPath.length() == 0) {
            return null;
        }
        Node currentPortal = null;
        List<Node> livePortaNodes = new ArrayList();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            livePortaNodes = this.livePortalManagerService.getLivePortals(sessionProvider, repositoryName);
            if (sharedPortal != null) {
                livePortaNodes.add(sharedPortal);
            }
            for (Node portalNode : livePortaNodes) {
                String portalPath = portalNode.getPath();
                if (!jcrPath.startsWith(portalPath)) continue;
                currentPortal = portalNode;
            }
            if (currentPortal == null) {
                currentPortal = this.livePortalManagerService.getLivePortal(sessionProvider, repositoryName, runningPortal);
            }
            return currentPortal;
        }
        catch (Exception e) {
            return null;
        }
    }
}

