/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.manager.IdentityManager;

public class UserToIdentityEventListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(UserToIdentityEventListener.class);
    private IdentityManager identityManager;
    private List<String> ignoredList;

    public UserToIdentityEventListener(InitParams initParams) {
        ValuesParam valueParams = initParams.getValuesParam("ignored-list");
        this.ignoredList = valueParams.getValues();
    }

    public void postSave(User user, boolean isNew) {
        if (isNew) {
            if (this.ignoredList.contains(user.getUserName())) {
                return;
            }
            if (this.identityManager == null) {
                this.identityManager = (IdentityManager)PortalContainer.getComponent(IdentityManager.class);
            }
            this.identityManager.getOrCreateIdentity("organization", user.getUserName());
        }
    }

    public void postDelete(User user) {
    }
}

