/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.timeout;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutExt;
import org.jboss.util.timeout.TimeoutPriorityQueue;
import org.jboss.util.timeout.TimeoutPriorityQueueImpl;
import org.jboss.util.timeout.TimeoutTarget;

public class TimeoutFactory {
    private static final String priorityQueueProperty = TimeoutPriorityQueue.class.getName();
    private static final String priorityQueueName = TimeoutPriorityQueueImpl.class.getName();
    private static TimeoutFactory singleton;
    private static int timeoutFactoriesCount;
    private static Class<?> priorityQueueClass;
    private static BasicThreadPool DEFAULT_TP;
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private Thread workerThread;
    private ThreadPool threadPool;
    private TimeoutPriorityQueue queue;

    public static synchronized TimeoutFactory getSingleton() {
        if (singleton == null) {
            singleton = new TimeoutFactory(DEFAULT_TP);
        }
        return singleton;
    }

    public static Timeout createTimeout(long time, TimeoutTarget target) {
        return TimeoutFactory.getSingleton().schedule(time, target);
    }

    public TimeoutFactory(ThreadPool threadPool) {
        this.threadPool = threadPool;
        try {
            this.queue = (TimeoutPriorityQueue)priorityQueueClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate " + priorityQueueClass, e);
        }
        this.workerThread = new Thread("TimeoutFactory-" + timeoutFactoriesCount++){

            public void run() {
                TimeoutFactory.this.doWork();
            }
        };
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    public TimeoutFactory() {
        this(DEFAULT_TP);
    }

    public Timeout schedule(long time, TimeoutTarget target) {
        if (this.cancelled.get()) {
            throw new IllegalStateException("TimeoutFactory has been cancelled");
        }
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        if (target == null) {
            throw new IllegalArgumentException("Null timeout target");
        }
        return this.queue.offer(time, target);
    }

    public Timeout schedule(long time, Runnable run) {
        return this.schedule(time, new TimeoutTargetImpl(run));
    }

    public void cancel() {
        if (!this.cancelled.getAndSet(true)) {
            this.queue.cancel();
        }
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        while (!this.cancelled.get()) {
            TimeoutExt work = this.queue.take();
            if (work == null) continue;
            TimeoutWorker worker = new TimeoutWorker(work);
            try {
                this.threadPool.run(worker);
            }
            catch (Throwable t) {
                ThrowableHandler.add(1, t);
            }
            TimeoutExt timeoutExt = work;
            synchronized (timeoutExt) {
                work.done();
            }
        }
        this.queue.cancel();
    }

    static {
        timeoutFactoriesCount = 0;
        DEFAULT_TP = new BasicThreadPool("Timeouts");
        DEFAULT_TP.setBlockingMode(BlockingMode.RUN);
        String priorityQueueClassName = priorityQueueName;
        ClassLoader cl = TimeoutFactory.class.getClassLoader();
        try {
            priorityQueueClassName = System.getProperty(priorityQueueProperty, priorityQueueName);
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            priorityQueueClass = cl.loadClass(priorityQueueClassName);
        }
        catch (Exception e) {
            throw new NestedRuntimeException(e.toString(), e);
        }
    }

    private static class TimeoutTargetImpl
    implements TimeoutTarget {
        Runnable runnable;

        TimeoutTargetImpl(Runnable runnable) {
            this.runnable = runnable;
        }

        public void timedOut(Timeout ignored) {
            this.runnable.run();
        }
    }

    private static class TimeoutWorker
    implements Runnable {
        private TimeoutExt work;

        TimeoutWorker(TimeoutExt work) {
            this.work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.work.getTimeoutTarget().timedOut(this.work);
            }
            catch (Throwable t) {
                ThrowableHandler.add(1, t);
            }
            TimeoutExt timeoutExt = this.work;
            synchronized (timeoutExt) {
                this.work.done();
            }
        }
    }
}

