/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.link;

import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.plugin.link.UILinkActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class LinkUIActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(LinkUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, Activity activity) {
        UILinkActivity uiLinkActivity = (UILinkActivity)uiActivity;
        Validate.notNull((Object)activity.getTitle(), (String)"activity_.getTitle() must not be null.");
        try {
            this.getLinkDataFromJSON(activity, uiLinkActivity);
        }
        catch (JSONException e) {
            uiLinkActivity.setLinkSource(activity.getUrl());
            uiLinkActivity.setLinkTitle(activity.getTitle());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private void getLinkDataFromJSON(Activity activity, UILinkActivity uiLinkActivity) throws JSONException {
        JSONObject titleData = new JSONObject(activity.getTitle());
        if (titleData != null) {
            if (!titleData.isNull("link")) {
                uiLinkActivity.setLinkSource(titleData.getString("link"));
            }
            if (!titleData.isNull("title")) {
                uiLinkActivity.setLinkTitle(titleData.getString("title"));
            }
            if (!titleData.isNull("image")) {
                uiLinkActivity.setLinkImage(titleData.getString("image"));
            }
            if (!titleData.isNull("description")) {
                uiLinkActivity.setLinkDescription(titleData.getString("description"));
            }
            if (!titleData.isNull("comment")) {
                uiLinkActivity.setLinkComment(titleData.getString("comment"));
            }
        }
    }
}

