/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.ea;

import java.io.Serializable;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.ea.EAExoCacheConfig;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAExoCacheCreator
implements ExoCacheCreator {
    public static final String EXPECTED_IMPL = "EA";
    protected long defaultExpirationTimeout;

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return EAExoCacheConfig.class;
    }

    @Override
    public ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache) throws ExoCacheInitException {
        if (config instanceof EAExoCacheConfig) {
            EAExoCacheConfig eaConfig = (EAExoCacheConfig)config;
            return this.create(config, cache, eaConfig.getMaxNodes(), eaConfig.getMinTimeToLive(), eaConfig.getExpirationTimeout());
        }
        long period = config.getLiveTime();
        return this.create(config, cache, config.getMaxSize(), period > 0L ? period * 1000L : 0L, this.defaultExpirationTimeout);
    }

    private ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache, int maxNodes, long minTimeToLive, long expirationTimeout) throws ExoCacheInitException {
        Configuration configuration = cache.getConfiguration();
        ExpirationAlgorithmConfig ea = new ExpirationAlgorithmConfig();
        ea.setMaxNodes(maxNodes);
        ea.setMinTimeToLive(minTimeToLive);
        ea.setExpirationKeyName("expiration");
        EvictionRegionConfig erc = new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)ea);
        EvictionConfig evictionConfig = configuration.getEvictionConfig();
        evictionConfig.setDefaultEvictionRegionConfig(erc);
        return new EAExoCache(config, cache, ea, expirationTimeout);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EAExoCache
    extends AbstractExoCache<Serializable, Object> {
        private long expirationTimeout;
        private final ExpirationAlgorithmConfig ea;

        public EAExoCache(ExoCacheConfig config, Cache<Serializable, Object> cache, ExpirationAlgorithmConfig ea, long expirationTimeout) {
            super(config, cache);
            this.ea = ea;
            this.expirationTimeout = expirationTimeout;
        }

        @Override
        protected Object putOnly(Serializable key, Object value) {
            Fqn<Serializable> fqn = this.getFqn(key);
            Long future = new Long(System.currentTimeMillis() + this.expirationTimeout);
            this.cache.put(fqn, (Object)"expiration", (Object)future);
            return this.cache.put(fqn, (Object)key, value);
        }

        public void setMaxSize(int max) {
            this.ea.setMaxNodes(max);
        }

        public void setLiveTime(long period) {
            this.ea.setMinTimeToLive(period);
        }

        @ManagedName(value="MaxNodes")
        @ManagedDescription(value="This is the maximum number of nodes allowed in this region. 0 denotes immediate expiry, -1 denotes no limit.")
        public int getMaxSize() {
            return this.ea.getMaxNodes();
        }

        @ManagedName(value="MinTimeToLive")
        @ManagedDescription(value="the minimum amount of time a node must be allowed to live after being accessed before it is allowed to be considered for eviction. 0 denotes that this feature is disabled, which is the default value.")
        public long getLiveTime() {
            return this.ea.getMinTimeToLive();
        }

        @Managed
        @ManagedName(value="ExpirationTimeout")
        @ManagedDescription(value="This is the timeout after which the cache entry must be evicted.")
        public long getExpirationTimeout() {
            return this.expirationTimeout;
        }

        @Managed
        public void setExpirationTimeout(long expirationTimeout) {
            this.expirationTimeout = expirationTimeout;
        }
    }
}

