/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.TypeFactory;

public class Set
extends Collection {
    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
    }

    public Set(PersistentClass owner) {
        super(owner);
    }

    public boolean isSet() {
        return true;
    }

    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return TypeFactory.sortedSet(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getComparator());
        }
        if (this.hasOrder()) {
            return TypeFactory.orderedSet(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
        }
        return TypeFactory.set(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getKey().getColumnIterator());
            Iterator iter = this.getElement().getColumnIterator();
            while (iter.hasNext()) {
                Column col;
                Object selectable = iter.next();
                if (!(selectable instanceof Column) || (col = (Column)selectable).isNullable()) continue;
                pk.addColumn(col);
            }
            if (pk.getColumnSpan() != this.getKey().getColumnSpan()) {
                this.getCollectionTable().setPrimaryKey(pk);
            }
        }
    }

    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

